/* class written by jeff goke, jjgoke@cs.csbsju.edu -- (c) 1994.
   this class may be freely used/distributed as long as credit is
   given to the author, jeff goke */

/* much of this class was by Al Gifford.  Please see the individual
   functions for further information. */

#ifndef __GIFFORD_H
#define __GIFFORD_H

#include "bstring.h"
#include <DOS.H> // for date functions

class gifford
	{
/* The following functions were borrowed from DATES.C by Al Gifford
   The program was released March 26, 1993
   These functions are used in major INTERMEM calculations and I'd
   like to extend a thanks to the author for these excellent date
   routines.  */
	public:

	int	weeknum (int day, int month, int year);
	/* function by Jeff Goke returns the week number of a given day
	   in a given month in a given year */

	char *  DayName(char day);
	/* function returns the day, based on MonthName.  This function
	   written by Jeff Goke by making a few changes to MonthName */

	bstring pretty_date (int day, int month, int year);
	/* function returns a string containing the date
	   by Jeff Goke */


	char *  Number (int num);
	/* prints 1st, 2nd, etc.  Jeff Goke function.*/

	struct date ConvertGregorian(long JulianDate);
	/*----------------------------------------------------------------------
	**   Function returns Gregorian date using the DOS.H date structure.
	**   Julian Date is number of Days since January 1, 1900 (Day 1).
	*/
	unsigned short ConvertJulian(char day,char month,short year);
	/*----------------------------------------------------------------------
	**   Function returns number of days for Julian date.
	**   Julian Date is number of Days since January 1, 1900 (Day 1).
	*/
	short CountLeapYear(short year1,short year2);
	/*----------------------------------------------------------------------
	**   Function counts number of leapyears between two years.
	**   Years must have all 4 digits.
	*/
	short LeapYear(short year);
	/*----------------------------------------------------------------------
	**   Function returns true (1) if year (all 4 digits) is a leap year,
	**      otherwise it returns false(0).
	*/
	short DaysInMonth(char month,short year);
	/*----------------------------------------------------------------------
	**   Function returns the number of days in a given month.
	**   The month is 1-12 and the year must have all 4 digits.
	*/
	char DayOfWeek(char day,char month,short year);
	/*----------------------------------------------------------------------
	**   Function returns the day of the week (0-6 : Sunday-Saturday).
	*/
	char *MonthName(char month);
	};

#endif /* __DATA_H */