/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     EDITOR.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/



#ifndef __EDITOR_H_INCLUDED__
#define __EDITOR_H_INCLUDED__

#ifdef __cplusplus
extern "C" {
#endif

/* info texts */

#ifndef TXT_NOTENOUGHMEMORY
#define TXT_NOTENOUGHMEMORY    INI_TEXT("Not enough memory")
#endif

/* editor' init flags */

#define  EF_REWRITEUNABLE    0x01


#define  EDITOR_CHAR_ENTER      '\n'  /* ascii 10 */
#define  EDITOR_LINE_SIZE       1
#define  EDITOR_TAB_SIZE        5

#define  EDITOR_CUR_VISIBLE           0x0001
#define  EDITOR_CUR_VISIBLE2          0x0002
#define  EDITOR_CUR_VISIBLETICK       0x0004

extern l_color  pal_editor[];

typedef struct t_editor *p_editor;

typedef struct t_editor {

   struct t_scroller obclass;

   l_text            text;
   l_text            line_ptr;
   l_long            line_from;
   l_long            line_num;
   l_long            line;
   l_long            line_pos;
   l_long            line_longest;

   l_int             cursor_flags;
   l_rect            cursor_last_height;
   t_point           cursor_last_pos;

   t_rect            sel_from;
   t_point           sel_old;
   l_long            sel_ok;
   t_rect            sel_safe_dd;

   l_int             flags;
   /* If something edited in the editor */
   l_bool            edit;

   l_text          (*lntxtlen) ( p_editor o, l_long line, l_long *len );
   l_long          (*lnmax) ( p_editor o, l_long *nlongest );
   l_text          (*lnptr) ( p_editor o, l_long line );
   l_text          (*posptr) ( p_editor o, l_long line, l_long pos );
   l_long          (*sizeto) ( l_text from, l_long deltaln, l_long deltapos );
   l_long          (*lnlen) ( p_editor o, l_long line );
   l_long          (*lnlenptr) ( p_editor o, l_text ptr );
   l_long          (*xsize_of_line) ( p_editor o, l_long line, l_long max );
   l_long          (*ysize_of_line) ( p_editor o, l_long line, l_long h, l_long (*p) );
   void            (*draw_cursor) ( p_editor o, l_bool sh );
   void            (*draw_cursor_ex) ( p_editor o, l_long line, l_long pos, l_int active );
   void            (*show_cursor) ( p_editor o, l_bool show );
   t_rect          (*get_cursor_rect) ( p_editor o, l_long oldline, l_long oldpos );
   l_long          (*charsin_size) ( p_editor o, l_rect size, l_long line, l_long pos, l_int plus );
   l_long          (*charsin) ( p_editor o, l_long line, l_long pos, l_int plus );
   l_long          (*linesin) ( p_editor o, l_long line, l_int plus );
   l_long          (*linesin2) ( p_editor o, l_long line, l_int plus, l_bool erlast );
   l_long          (*linesin_size) ( p_editor o, l_rect size, l_long line, l_int plus, l_bool erlast );
   l_int           (*lines_inpage) ( p_editor o );
   void            (*draw_select) ( p_editor o, t_rect dst, t_rect src );
   void            (*select_text) ( p_editor o, l_long line1, l_long pos1, l_long line2, l_long pos2 );

   t_rect          (*get_select_rect) ( p_editor o );
   l_bool          (*is_in_select_rect) ( p_editor o, t_point where );

   l_bool          (*insstr) ( p_editor o, l_long pos, l_text str );
   l_bool          (*delstr) ( p_editor o, l_long pos, l_long size );
   l_int           (*delchr) ( p_editor o, l_long line, l_long pos );
   l_bool          (*inschr) ( p_editor o, l_int chr, l_long line, l_long pos );

   l_bool          (*set_text) ( p_editor o, l_text txt );
   t_rect          (*line_rect) ( p_editor o, l_long line );
   t_rect          (*real_line_rect) ( p_editor o, l_long line );

   void            (*draw_box_ex) ( p_editor o, l_long linefrom );
   void            (*draw_box) ( p_editor o );
   void            (*draw_line) ( p_editor o, l_long line );

   void            (*realpos) ( p_editor o, l_long *line, l_long *pos );
   void            (*redraw_text) ( p_editor o, l_long newline, l_long newpos, l_int keycode );

   t_point         (*cursor_mouse_pos) ( p_editor o, t_point where );
   void            (*refresh_delta) ( p_editor o );
   void            (*set_edit) ( p_editor o, l_bool edit );

} t_editor;

extern p_editor def_editor;

#define EDITOR(o) ((p_editor)(o))

#define DEF_EDITOR_FUNC(y) DEF_FUNC(def_editor,y);
#define DEF_EDITOR_VIEW_FUNC(y) DEF_FUNC(VIEW(def_editor),y);
#define DEF_EDITOR_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_editor),y);

#define ed_sel_clear(o)      ((o)->sel_from = rect_empty)
#define ed_sel_dd_clear(o)   ((o)->sel_safe_dd = rect_empty)
#define ed_is_wable(o)       (!((o)->flags & EF_REWRITEUNABLE))
#define ed_is_sel(o)         ((o)->sel_from.a.x != (o)->sel_from.b.x || (o)->sel_from.a.y != (o)->sel_from.b.y && ((o)->sel_from.a.x >= 0 && (o)->sel_from.a.y >= 0))
#define ed_is_sel_dd(o)      ((o)->sel_safe_dd.a.x != (o)->sel_safe_dd.b.x || (o)->sel_safe_dd.a.y != (o)->sel_safe_dd.b.y && ((o)->sel_safe_dd.a.x >= 0 && (o)->sel_safe_dd.a.y >= 0))
#define ed_is_sel_none(o)    ((o)->sel_from.a.x == (o)->sel_from.b.x && (o)->sel_from.a.y == (o)->sel_from.b.y && ((o)->sel_from.a.x >= 0 && (o)->sel_from.a.y >= 0))

p_editor  _editor_init ( p_editor o, t_rect r, l_int flags );
extern p_editor  (*editor_init) ( p_editor o, t_rect r, l_int flags );

p_editor  editor_new ( t_rect r, l_int flags );

#ifdef __cplusplus
}
#endif

#endif

