/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XFILEDLG.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XFILEDLG_H_INCLUDED__
#define __XFILEDLG_H_INCLUDED__

#include<matrixos.h>
#include"xwindow.h"
#include"xflist.h"
#include"xfhist.h"
#include"xtxtline.h"
#include"xtoolbar.h"
#include"xguifile.h"

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif


typedef struct t_filedlg_listbox *p_filedlg_listbox;
typedef struct t_filedlg_listbox {

  struct t_filelistbox   obclass;

  l_bool          save;
  l_bool          opendir;

  p_filehistory   fileshistory;
  p_textline      filesline;
  p_window        modal_window;

  void        (*set_modal) ( p_filedlg_listbox o, p_window w );
  void        (*connect_fileshistory) ( p_filedlg_listbox o, p_filehistory fh );
  void        (*disconnect_fileshistory) ( p_filedlg_listbox o );
  void        (*connect_filesline) ( p_filedlg_listbox o, p_textline tl );
  void        (*disconnect_filesline) ( p_filedlg_listbox o );

} t_filedlg_listbox;

#define FILEDLG_LISTBOX(o) ((p_filedlg_listbox)(o))

extern p_filedlg_listbox def_filedlg_listbox;

#define DEF_FILEDLG_FUNC(y) DEF_FUNC(def_filedlg_listbox,y)
#define DEF_FILEDLG_FILELISTBOX_FUNC(y) DEF_FUNC(LISTBOX(def_filedlg_listbox),y)
#define DEF_FILEDLG_FILELISTBOX_LISTBOX_SCROLLER(y) DEF_FUNC(SCROLLER(def_filedlg_listbox),y)
#define DEF_FILEDLG_FILELISTBOX_LISTBOX_SCROLLER_VIEW_FUNC(y) DEF_FUNC(VIEW(def_filedlg_listbox),y)
#define DEF_FILEDLG_FILELISTBOX_LISTBOX_SCROLLER_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_filedlg_listbox),y)

extern p_filedlg_listbox (*filedlg_listbox_init) ( p_filedlg_listbox o, t_rect r, l_text path, l_int flags );
p_filedlg_listbox _filedlg_listbox_init ( p_filedlg_listbox o, t_rect r, l_text path, l_int flags );

p_filedlg_listbox  filedlg_listbox_new ( t_rect r, l_text path, l_int flags );


/**
 *
*/
void  filedlg_new ( l_text caption, l_text path );


/**
 * Makes new modal file dialog with @caption and starting path @path, where
 * @flags indicates type of modal file dailog.
 *
 * FDLG_OPEN_DIR - Open dialog will be shown by "Ok" button and directory
 *                 can be returned as well.
 * FDLG_OPEN_OK  - Open dialog will be shown by "Ok" button
 * FDLG_OPEN     - Open dialog will be shown by "Open" button
 * FDLG_SAVE     - Save dialog will be shown by "Save" button
 *
 * NOTE :
 * The memory returned by this call must be freed by the caller.
*/
l_text  filedlg_new_modal ( l_text caption, l_text path, l_int flags );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xfiledlg.h */
