/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XFLIST.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XFLIST_H_INCLUDED__
#define __XFLIST_H_INCLUDED__

#include<matrixos.h>

#include"xlistbox.h"
#include"xficon.h"


#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

/**
 * Flags for filelistbox
*/
#define FLBF_OPENINNEWWINDOW  0x0001
#define FLBF_COLLECT_BY_NAME  0x0002
#define FLBF_COLLECT_BY_TIME  0x0004
#define FLBF_COLLECT_BY_SIZE  0x0008


typedef struct t_filelistbox *p_filelistbox;
typedef struct t_filelistbox {

  struct t_listbox   obclass;

  l_text             path;
  l_text             path_name;

  p_vector           list_dir;
  p_vector           list_file;

  p_vector           history;
  l_int              history_pos;
  l_int              fflags;

  void         (*newlink) ( p_filelistbox o );
  l_bool       (*in_sys_path) ( p_filelistbox o );
  void         (*reset_details_bounds) ( p_filelistbox o );
  l_bool       (*list) ( p_filelistbox o, l_text path, l_bool add );
  l_text       (*get_path) ( p_filelistbox o );
  l_bool       (*go_parent) ( p_filelistbox o );
  l_bool       (*go_back) ( p_filelistbox o );
  l_bool       (*go_next) ( p_filelistbox o );
  p_vector     (*get_selected_files) ( p_filelistbox o, l_bool all );
  l_bool       (*refresh_list) ( p_filelistbox o );
  void         (*on_unselect_menu) ( p_filelistbox o );
  void         (*collect_by) ( p_filelistbox o );
  void         (*collect_by_name) ( p_filelistbox o );
  void         (*collect_by_time) ( p_filelistbox o );
  void         (*collect_by_size) ( p_filelistbox o );

  p_file_iconview  (*generate_file_iconview) ( p_filelistbox o, t_rect r,
                             l_text path, p_icon icon, l_rect icon_size, l_int flags,
                             l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                             l_dword  on_press_arg, p_menu (*on_menu)(p_file_iconview o) );


  void         (*get_properties) ( p_filelistbox o );
  void         (*makelinks_to) ( p_filelistbox o, p_vector to_path );
  void         (*makefolder) ( p_filelistbox o );

  void         (*fillbox) ( p_filelistbox o, p_file f, l_text ext, l_int attrib );
  void         (*fillbox_by_vector) ( p_filelistbox o, p_vector v, l_int view_style );

} t_filelistbox;

#define FILELISTBOX(o) ((p_filelistbox)(o))

extern p_filelistbox def_filelistbox;

#define DEF_FILELISTBOX_FUNC(y) DEF_FUNC(def_filelistbox,y)
#define DEF_FILELISTBOX_LISTBOX_FUNC(y) DEF_FUNC(LISTBOX(def_filelistbox),y)
#define DEF_FILELISTBOX_LISTBOX_SCROLLER(y) DEF_FUNC(SCROLLER(def_filelistbox),y)
#define DEF_FILELISTBOX_LISTBOX_SCROLLER_VIEW_FUNC(y) DEF_FUNC(VIEW(def_filelistbox),y)
#define DEF_FILELISTBOX_LISTBOX_SCROLLER_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_filelistbox),y)


extern p_filelistbox (*filelistbox_init) ( p_filelistbox o, t_rect r, l_text path, l_int flags );
p_filelistbox _filelistbox_init ( p_filelistbox o, t_rect r, l_text path, l_int flags );


p_filelistbox  filelistbox_new ( t_rect r, l_text path, l_int flags );


/**
 * This function is called when the file icon inside the iconview is
 * pressed.
*/
l_bool fileicon_on_press ( p_iconview o, l_dword on_press_arg );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xflist.h */

