/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XGUIFILE.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XGUIFILE_H_INCLUDED__
#define __XGUIFILE_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif



/* Retcodes in function gui_file_run */
#define FR_ERROR      -2
#define FR_DIRECTORY  -1
#define FR_OK          0

/* Flags used in gui_file_dlg */
#define  FDLG_OPEN      0
#define  FDLG_OPEN_OK   1
#define  FDLG_SAVE      2
#define  FDLG_OPEN_DIR  3


/**
 *
*/
extern l_bool  (*gui_file_is_sysdep) ( l_text path );
l_bool  _gui_file_is_sysdep ( l_text path );


/**
 *
*/
extern l_int   (*gui_file_run) ( p_file f, l_bool in_new_window );
l_int   _gui_file_run ( p_file f, l_bool in_new_window );


/**
 *
*/
extern l_text  (*gui_file_dlg) ( l_text caption, p_file path, l_int flags );
l_text  _gui_file_dlg ( l_text caption, p_file path, l_int flags );


/**
 *
*/
extern void  (*gui_file_new_folder) ( p_file f, t_point p );
void    _gui_file_new_folder ( p_file f, t_point p );


/**
 *
*/
extern void  (*gui_file_get_properties) ( p_file f, t_point p );
void    _gui_file_get_properties ( p_file f, t_point p );


/**
 *
*/
extern void  (*gui_file_makelinks_to) ( p_file f, p_vector to_path );
void    _gui_file_makelinks_to ( p_file f, p_vector to_path );


/**
 *
*/
extern l_bool  (*gui_file_copy) ( p_file f, p_vector src );
l_bool  _gui_file_copy ( p_file f, p_vector src );


/**
 *
*/
extern l_bool  (*gui_file_rename) ( p_file f, p_vector src );
l_bool  _gui_file_rename ( p_file f, p_vector src );


/**
 *
*/
extern l_bool  (*gui_file_remove) ( p_vector src );
l_bool  _gui_file_remove ( p_vector src );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xguifile.h */

