/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XICON.H                                       */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XICON_H_INCLUDED__
#define __XICON_H_INCLUDED__

#include<matrixos.h>
#include"xlistbox.h"

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

/*
  Icon palette. It's set in Icon initializing function as the palette
  of the Icon. This settings are only default. The real settings are
  read from registers when the xIcon library is load into the memory.

  You can later get these values from your view ( in this case from the
  Icon ) by calling my_view->get_color(my_view, @index) where index
  is the index of these values. E.g. my_Icon->get_color(my_Icon, 0)
  is CO_SYSx20.

  Note that these values are not used. There is [colors] section in
  registers, from where are colors read. See "but_ini"
  at the bottom of this file for more information.
*/
extern l_color  pal_iconview[];


extern l_int iconview_efects;

/*
  Icon flags used for t_icon.flags
*/

/**
 * Icon's image and text will placed at the same level in one line,
 * where icon will be placed on the right from the text.
*/
#define IF_HORIZONTAL    0x0001

/**
 * Icon's image will be placed in the centerx of top and and text is placed
 * under the image, centered too.
*/
#define IF_VERTICAL      0x0002

/**
 * Icon will have more than one section of text.
 *
*/
#define IF_DETAILS       0x0004

/*
 Icon's image will be destroyed, whenever the object (icon) is destroyed.
 If you use system static icon, this flags can't be used.
*/
#define IF_SELFIMAGE     0x0008

/**
 *
*/
#define IF_SETFLAGSURE   0x0010

/**
 * This flags is used if icon can't be moved
*/
#define IF_CANTMOVE      0x0020

/**
 * This flags is used when data are draged over the icon. Not used by user
*/
#define IF_DRAGOVER      0x2000

/**
 * This flags is used drag and drop is disabled
*/
#define IF_NODRAG        0x4000


typedef struct t_iconview   *p_iconview;
typedef struct t_iconview {

  struct t_listchild  obclass;

  l_int        flags;
  p_icon       icon;
  p_vector*    details_bounds;
  l_rect       icon_size;
  l_dword      on_press_arg;

  l_bool     (*on_press)( p_iconview o, l_dword on_press_arg );
  t_rect     (*get_text_rect) ( p_iconview o );
  t_rect     (*get_icon_rect) ( p_iconview o );
  l_text     (*get_details_texts) ( p_iconview o );
  p_vector   (*get_details_bounds) ( p_iconview o );
  void       (*set_details_bounds) ( p_iconview o, p_vector *details_bounds );
  l_text     (*get_details_text_element) ( p_iconview o, l_int element );
  t_rect     (*get_details_rect_element) ( p_iconview o, l_int element );
  void       (*fit_size) ( p_iconview o );

  void       (*draw_as_details_icon) ( p_iconview o );
  void       (*draw_as_large_icon) ( p_iconview o );
  void       (*draw_as_list_item) ( p_iconview o );

} t_iconview;

#define ICONVIEW(o)   ((p_iconview)(o))

extern p_iconview  def_iconview;

#define DEF_ICONVIEW_FUNC(y) DEF_FUNC(def_iconview,y)
#define DEF_ICONVIEW_LISTCHILD_FUNC(y) DEF_FUNC(LISTCHILD(def_iconview),y)
#define DEF_ICONVIEW_LISTCHILD_VIEW_FUNC(y) DEF_FUNC(VIEW(def_iconview),y)
#define DEF_ICONVIEW_LISTCHILD_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_iconview),y)


/**
 * Creates an icon of the bitmap @icon, where flags may be the combination
 * of following values :
 *
 * IF_SELFIMAGE -  Icon's image will be destroyed, whenever this object
 * is prepared for destroying in function icon_done.
 * If you use system static icon, this flags can't be used.
 *
 * IF_STRETCH   -  Icon's image will be stretched to the size of
 * the icon, otherwise it's centered.
 *
 * IF_HORIZONTAL -  Icon's image and text will placed at the same
 * level in one line, where icon will be placed on the right from the text.
 *
 * IF_VERTICAL -  It's set default. Icon's image will be placed in
 * the centerx of top and and text is placed under the image, centered too.
 *
 * IF_CANTMOVE -  This flags is used if icon can't be moved
 *
 * @caption - is the title of the icon. May be NULL.
 * @on_press - the function that will be called whenever the icon was
 *             pressed. This should point to your function that will
 *             manage the icon press.
 * @on_press_arg - is the argument to be inserted as the 2nd one, when
 *                 function @on_press is called.
*/
extern p_iconview  (*iconview_init) ( p_iconview o, t_rect r, l_text caption,
                                      p_icon icon, l_rect icon_size,
                                      l_int flags, l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                                      l_dword on_press_arg );

p_iconview  _iconview_init ( p_iconview o, t_rect r, l_text caption,
                             p_icon icon, l_rect icon_size, l_int flags,
                             l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                             l_dword on_press_arg );



/**
 * Creates an icon of the bitmap @icon, where flags may be the combination
 * of following values :
 *
 * IF_SELFIMAGE -  Icon's image will be destroyed, whenever this object
 * is prepared for destroying in function icon_done.
 * If you use system static icon, this flags can't be used.
 *
 * IF_STRETCH   -  Icon's image will be stretched to the size of
 * the icon, otherwise it's centered.
 *
 * IF_HORIZONTAL -  Icon's image and text will placed at the same
 * level in one line, where icon will be placed on the right from the text.
 *
 * IF_VERTICAL -  It's set default. Icon's image will be placed in
 * the centerx of top and and text is placed under the image, centered too.
 *
 * IF_CANTMOVE -  This flags is used if icon can't be moved
 *
 * @caption - is the title of the icon. May be NULL.
 * @on_press - the function that will be called whenever the icon was
 *             pressed. This should point to your function that will
 *             manage the icon press.
 * @on_press_arg - is the argument to be inserted as the 2nd one, when
 *                 function @on_press is called.
 *
 * Note :
 * The usage is the same as the icon_init function, but this will set
 * bounds of the iconview @r to the correct width and height.
 *
 *
*/
p_iconview  iconview_new ( t_rect r, l_text caption, p_icon icon,
                           l_rect icon_size, l_int flags,
                           l_bool (*on_press)(p_iconview o, l_dword on_press_arg),
                           l_dword on_press_arg );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xicon.h */

