/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XMSGBOX.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XMSGBOX_H_INCLUDED__
#define __XMSGBOX_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif


#define MSGF_ICON_QUESTION             0x000000001
#define MSGF_ICON_ERROR                0x000000002
#define MSGF_ICON_WARNING              0x000000003
#define MSGF_ICON_INFO                 0x000000004
#define MSGF_ICON_BOMB                 0x000000005
#define MSGF_ICON_OVERWRITE            0x000000006
#define MSGF_ICON_GET(x)               ((x)&~0xFFFFFFF0)

#define MSGF_DEFAULT1                  0x000000020
#define MSGF_DEFAULT2                  0x000000040
#define MSGF_DEFAULT3                  0x000000080
#define MSGF_DEFAULT4                  0x000000100
#define MSGF_DEFAULT_GET(x)            ((x)&~0xFFFFF00F)

#define MSGF_OK                        0x000001000
#define MSGF_YESNO                     0x000002000
#define MSGF_YESNOCANCEL               0x000004000
#define MSGF_OKCANCEL                  0x000008000
#define MSGF_RETRYCANCEL               0x000010000
#define MSGF_ABORTRETRYIGNORE          0x000020000
#define MSGF_OVERWRITE                 0x000040000
#define MSGF_BUTTON_GET(x)             ((x)&~0x00000FFF)

/* Results of message box */

#ifndef MSG_DIALOG_CANCEL
#define MSG_DIALOG_CANCEL        1
#endif
#ifndef MSG_DIALOG_YES
#define MSG_DIALOG_YES           2
#endif
#ifndef MSG_DIALOG_IGNORE
#define MSG_DIALOG_IGNORE        3
#endif
#ifndef MSG_DIALOG_OK
#define MSG_DIALOG_OK            4
#endif
#ifndef MSG_DIALOG_NO
#define MSG_DIALOG_NO            5
#endif
#ifndef MSG_DIALOG_RETRY
#define MSG_DIALOG_RETRY         6
#endif
#ifndef MSG_DIALOG_ABORT
#define MSG_DIALOG_ABORT         7
#endif
#ifndef MSG_DIALOG_YESTOALL
#define MSG_DIALOG_YESTOALL      8
#endif
#ifndef MSG_DIALOG_SKIP
#define MSG_DIALOG_SKIP          9
#endif


typedef struct t_msgbox_sheet *p_msgbox_sheet;
typedef struct t_msgbox_sheet {

      /* The icon of the message box */
      p_bitmap     icon;
      /* Default caption of the message box */
      l_text       caption;
      /* The number of buttons in the message box */
      l_int        button_number;
      /* The number of the button that's set as default */
      l_int        button_default;
      /* The vector of strings, where each element represents one
         button name.
      */
      p_vector     button_names;
      /* The vector of rectangles, where each element represents the
         bounds of the button from the 0,0.
      */
      p_vector     button_rects;

      /* The vector of functions, where each element represents the
         function of the button that's called whenever the button is pressed.
      */
      p_vector     button_on_presses;

} t_msgbox_sheet;


/**
 * Puts the message box to the center of the desktop, where
 * @flags is the combination of 3 elements :
 * 1. buttons
 * 2. which button is default
 * 3. the icon of the message box
 *
 * By this way you can select what type of your message box will be
 * displayed.
 *
 * Options of buttons :
 *
 * MSGF_OK                - Ok button will be displayed.
 * MSGF_YESNO             - Yes, No, buttons will be displayed
 * MSGF_YESNOCANCEL       - Yes, No, Cancel buttons will be displayed
 * MSGF_OKCANCEL          - Ok, Cancel buttons will be displayed
 * MSGF_RETRYCANCEL       - Retry, Cancel buttons will be displayed
 * MSGF_ABORTRETRYIGNORE  - Abort, Retry, Ignore buttons will be displayed
 *
 * Options of icons & window captions :
 *
 * MSGF_ICON_QUESTION     - Icon for the Question dialog will be displayed,
 *                          with the caption "Question" if no @caption is
 *                          defined.
 * MSGF_ICON_ERROR        - Icon for the Error dialog will be displayed,
 *                          with the caption "Error" if no @caption is
 *                          defined.
 * MSGF_ICON_WARNING      - Icon for the Warning dialog will be displayed,
 *                          with the caption "Warning" if no @caption is
 *                          defined.
 * MSGF_ICON_BOMB         - Icon for the System Error dialog will be
 *                          displayed, with the caption "System Error" if
 *                          no @caption is defined.
 *
 * Options of wich button will be set as default :
 *
 * MSGF_DEFAULT1          - the first button from the Options of buttons
 *                          will be set as default.
 * MSGF_DEFAULT2          - the second button from the Options of buttons
 *                          will be set as default.
 * MSGF_DEFAULT3          - the third button from the Options of buttons
 *                          will be set as default.
 *
 * @caption - set the caption of this message box. If not selected, the
 *            default caption is set from the MSGF_ICON_XXXX type.
 *
 * @content - the content of the message box in the formated text style,
 *            used by the same way as standard C "printf" function.
*/
l_dword  msgbox2 ( l_dword flags, l_text caption, l_text content, VA_LIST argp );


/**
 * Puts the message box to the center of the desktop, where
 * @flags is the combination of 3 elements :
 * 1. buttons
 * 2. which button is default
 * 3. the icon of the message box
 *
 * By this way you can select what type of your message box will be
 * displayed.
 *
 * Options of buttons :
 *
 * MSGF_OK                - Ok button will be displayed.
 * MSGF_YESNO             - Yes, No, buttons will be displayed
 * MSGF_YESNOCANCEL       - Yes, No, Cancel buttons will be displayed
 * MSGF_OKCANCEL          - Ok, Cancel buttons will be displayed
 * MSGF_RETRYCANCEL       - Retry, Cancel buttons will be displayed
 * MSGF_ABORTRETRYIGNORE  - Abort, Retry, Ignore buttons will be displayed
 *
 * Options of icons & window captions :
 *
 * MSGF_ICON_QUESTION     - Icon for the Question dialog will be displayed,
 *                          with the caption "Question" if no @caption is
 *                          defined.
 * MSGF_ICON_ERROR        - Icon for the Error dialog will be displayed,
 *                          with the caption "Error" if no @caption is
 *                          defined.
 * MSGF_ICON_WARNING      - Icon for the Warning dialog will be displayed,
 *                          with the caption "Warning" if no @caption is
 *                          defined.
 * MSGF_ICON_BOMB         - Icon for the System Error dialog will be
 *                          displayed, with the caption "System Error" if
 *                          no @caption is defined.
 *
 * Options of wich button will be set as default :
 *
 * MSGF_DEFAULT1          - the first button from the Options of buttons
 *                          will be set as default.
 * MSGF_DEFAULT2          - the second button from the Options of buttons
 *                          will be set as default.
 * MSGF_DEFAULT3          - the third button from the Options of buttons
 *                          will be set as default.
 *
 * @caption - set the caption of this message box. If not selected, the
 *            default caption is set from the MSGF_ICON_XXXX type.
 *
 * @content - the content of the message box in the formated text style,
 *            used by the same way as standard C "printf" function.
*/
l_dword  msgbox ( l_dword flags, l_text caption, l_text content, ... );


/**
 * Tranlates @icon, @button, @bdefault states to the t_msgbox_sheet
 * structure.
 *
 * Returns 7 if all flags was translated.
 * 0x01 for icons
 * 0x02 for buttons
 * 0x04 for default
*/
extern l_int (*msgbox_sheet) ( l_dword icon, l_dword button, l_dword bdefault, p_msgbox_sheet ret );
l_int _msgbox_sheet ( l_dword icon, l_dword button, l_dword bdefault, p_msgbox_sheet ret );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xmsgbox.h */

