/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XSCROLL.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/


#ifndef __SCROLLER_H_INCLUDED__
#define __SCROLLER_H_INCLUDED__

#ifdef __cplusplus
extern "C" {
#endif


/* scroll after move types */

#define SCROLL_NOW        false
#define SCROLL_AFTER      true

/* scrollbar flags */

#define SBF_SCROLL_AFTER_MOVE       0x0001


/* scroller flags for scrollbars */

#define SF_HORSCROLLBAR   0x00001
#define SF_VERSCROLLBAR   0x00002
#define SF_SCROLLACCEL    0x00004
#define SF_AFTERMOVE      0x00008



extern l_bool   scroll_after;
extern l_bool   scroll_accel;
extern l_int    scroll_diff;

extern l_color  pal_scrollbar[];


typedef struct t_scroller *p_scroller;
typedef struct t_hscrollbar *p_hscrollbar;
typedef struct t_vscrollbar *p_vscrollbar;


/* t_hscrollbar */

typedef struct t_hscrollbar {

  struct t_view   obclass;

  p_scroller      scroller;
  l_int           flags;
  l_byte          statebut;
  l_timestamp     oldevent_time;

  void          (*draw_bar) ( p_hscrollbar o );
  l_rect        (*get_bar_size) ( p_hscrollbar o );
  l_rect        (*get_bar_pos) ( p_hscrollbar o );
  l_rect        (*get_bar_minsize) ( p_hscrollbar o );
  l_rect        (*get_real_pos) ( p_hscrollbar o, l_rect pos );
  void          (*left_button_press) (p_hscrollbar o, p_event event);
  void          (*right_button_press) (p_hscrollbar o, p_event event);
  void          (*draw_button) ( p_hscrollbar o, l_int state );
  void          (*refresh_scollx) ( p_hscrollbar o );

} t_hscrollbar;

extern p_hscrollbar     def_hscrollbar;

#define DEF_HSCROLLBAR_FUNC(y) DEF_FUNC(def_hscrollbar,y)
#define DEF_HSCROLLBAR_VIEW_FUNC(y) DEF_FUNC(VIEW(def_hscrollbar),y)
#define DEF_HSCROLLBAR_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_hscrollbar),y)

#define HSCROLLBAR(o)   ((p_hscrollbar)(o))


/* t_vscrollbar */

typedef struct t_vscrollbar {

  struct t_view   obclass;

  p_scroller      scroller;
  l_int           flags;
  l_byte          statebut;
  l_timestamp     oldevent_time;

  void          (*draw_bar) ( p_vscrollbar o );
  l_rect        (*get_bar_size) ( p_vscrollbar o );
  l_rect        (*get_bar_pos) ( p_vscrollbar o );
  l_rect        (*get_bar_minsize) ( p_vscrollbar o );
  l_rect        (*get_real_pos) ( p_vscrollbar o, l_rect pos );
  void          (*up_button_press) (p_vscrollbar o, p_event event);
  void          (*down_button_press) (p_vscrollbar o, p_event event);
  void          (*draw_button) ( p_vscrollbar o, l_int state );
  void          (*refresh_scolly) ( p_vscrollbar o );

} t_vscrollbar;

#define VSCROLLBAR(o)   ((p_vscrollbar)(o))

extern p_vscrollbar     def_vscrollbar;

#define DEF_VSCROLLBAR_FUNC(y) DEF_FUNC(def_vscrollbar,y)
#define DEF_VSCROLLBAR_VIEW_FUNC(y) DEF_FUNC(VIEW(def_vscrollbar),y)
#define DEF_VSCROLLBAR_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_vscrollbar),y)

/* t_scroller */

typedef struct t_scroller {

  struct t_view   obclass;

  l_rect          deltax;
  l_rect          deltay;

  l_rect          aftmovex;
  l_rect          aftmovey;

  l_int           flags;
  p_hscrollbar    horbar;
  p_vscrollbar    verbar;

  l_char          scroll_auto;

  t_rect  (*scroll_limits) ( p_scroller o );
  t_point (*scroll_size) ( p_scroller o );
  void    (*scroll_place) ( p_scroller o, l_rect dx, l_rect dy, l_bool aft_move );
  void    (*recalc_positions) ( p_scroller o, l_rect dx, l_rect dy );
  t_point (*max_unvisible_lines) ( p_scroller o );
  t_point (*max_unvisible_size) ( p_scroller o );
  t_point (*max_visible_size) ( p_scroller o );
  t_point (*max_logical_size) ( p_scroller o );
  void    (*set_scrollbars) ( p_scroller o, l_int bars );
  l_int   (*get_flags) ( p_scroller o );
  void    (*set_flags) ( p_scroller o, l_int flag, l_bool set );
  void    (*refresh_flags) ( p_scroller o, l_int flag, l_bool set );

} t_scroller;

#define SCROLLER(o)   ((p_scroller)(o))

extern p_scroller     def_scroller;

#define DEF_SCROLLER_FUNC(y) DEF_FUNC(def_scroller,y)
#define DEF_SCROLLER_VIEW_FUNC(y) DEF_FUNC(VIEW(def_scroller),y)
#define DEF_SCROLLER_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_scroller),y)

#define draw_scroller_bars(o) SUB_CODE { \
  if ( SCROLLER(o)->horbar ) SCROLLER(o)->horbar->refresh_scollx ( SCROLLER(o)->horbar ); \
  if ( SCROLLER(o)->verbar ) SCROLLER(o)->verbar->refresh_scolly ( SCROLLER(o)->verbar ); \
  if ( SCROLLER(o)->horbar ) VIEW(SCROLLER(o)->horbar)->draw_view(VIEW(SCROLLER(o)->horbar));\
  if ( SCROLLER(o)->verbar ) VIEW(SCROLLER(o)->verbar)->draw_view(VIEW(SCROLLER(o)->verbar));\
} END_CODE


#define calc_realposx(o,x) (low_math_ceil(_D(x) / _D(_GZ(SCROLLER(o)->deltax)))*_D(SCROLLER(o)->deltax))
#define calc_realposy(o,y) (low_math_ceil(_D(y) / _D(_GZ(SCROLLER(o)->deltay)))*_D(SCROLLER(o)->deltay))

#define refresh_scroller_bars(o) SUB_CODE {\
  if ( SCROLLER(o)->horbar ) SCROLLER(o)->horbar->refresh_scollx ( SCROLLER(o)->horbar ); \
  if ( SCROLLER(o)->verbar ) SCROLLER(o)->verbar->refresh_scolly ( SCROLLER(o)->verbar ); \
} END_CODE

#define reset_scroller(o) SUB_CODE { \
   VIEW(o)->scroll.x = 0; \
   VIEW(o)->scroll.y = 0; \
} END_CODE


/* hscrollbar functions */

extern p_hscrollbar   (*hscrollbar_init) ( p_hscrollbar o, t_rect r, p_scroller f );
p_hscrollbar   _hscrollbar_init ( p_hscrollbar o, t_rect r, p_scroller f );

p_hscrollbar   hscrollbar_new ( t_rect r, p_scroller f );


/* vscrollbar functions */

extern p_vscrollbar   (*vscrollbar_init) ( p_vscrollbar o, t_rect r, p_scroller f );
p_vscrollbar   _vscrollbar_init ( p_vscrollbar o, t_rect r, p_scroller f );

p_vscrollbar   vscrollbar_new ( t_rect r, p_scroller f );


/* scroller functions */

extern p_scroller   (*scroller_init) ( p_scroller o, t_rect r, l_int flags );
p_scroller   _scroller_init ( p_scroller o, t_rect r, l_int flags );

p_scroller   scroller_new ( t_rect r, l_int flags );


#ifdef __cplusplus
}
#endif

#endif

