/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XSTAT.H                                       */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XSTAT_H_INCLUDED__
#define __XSTAT_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"xlistbox.h"

/*
  Static Text palette. It's set in static text initializing function as
  the palette of the static text. This settings are only default.
  The real settings are read from registers when the xstat library is
  load into the memory.

  You can later get these values from your view ( in this case from the
  static text ) by calling my_view->get_color(my_view, @index) where index
  is the index of these values. E.g. my_stattext->get_color(my_stattext, 0)
  is CO_SYSx20.

  Note that these values are not used. There is [colors] section in
  registers, from where are colors read. See "but_ini"
  at the bottom of this file for more information.
*/
extern l_color  pal_stattext[];

#define  SF_SELFIMAGE   0x1000

/*
  Static Text is used for drawing formated text to the screen.
*/
typedef struct t_stattext *p_stattext;
typedef struct t_stattext {

/**
 * Inherited functions / variabes from t_view and t_object objects
*/
  struct t_view  obclass;

/**
 * Formated text
*/
  l_text     text;

/**
 * Alignment of the text in the stattext object
*/
  l_int      align;

  void       (*set_text) ( p_stattext o, l_text t );

} t_stattext;

#define STATTEXT(o) ((p_stattext)(o))

extern p_stattext def_stattext;

#define DEF_STATTEXT_FUNC(y) DEF_FUNC(def_stattext,y)
#define DEF_STATTEXT_VIEW_FUNC(y) DEF_FUNC(VIEW(def_stattext),y)
#define DEF_STATTEXT_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_stattext),y)


/*
  Static Text is used for drawing formated text to the screen.
*/
typedef struct t_static *p_static;
typedef struct t_static {

/**
 * Inherited functions / variabes from t_view and t_object objects
*/
  struct t_view  obclass;

  p_bitmap  bitmap;

  l_int     flags;

  void      (*set_bitmap) ( p_static o, p_bitmap b, l_int flags );

} t_static;

#define STATIC(o) ((p_static)(o))

extern p_static def_static;

#define DEF_STATIC_FUNC(y) DEF_FUNC(def_stattext,y)
#define DEF_STATIC_VIEW_FUNC(y) DEF_FUNC(VIEW(def_static),y)
#define DEF_STATIC_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_static),y)


/**
 * Creates static text usefull for drawing formated text to the screen.
 * This object is default - disabled so it can't have a focus. It's only
 * a drawing object.
*/
extern p_stattext (*stattext_init_ex) ( p_stattext o, t_rect r, l_int align, l_text text, VA_LIST argp );
p_stattext _stattext_init_ex ( p_stattext o, t_rect r, l_int align, l_text text, VA_LIST argp );

p_stattext stattext_init ( p_stattext o, t_rect r, l_int align, l_text text, ... );

/**
 * Creates static text usefull for drawing formated text to the screen.
 * This object is default - disabled so it can't have a focus. It's only
 * a drawing object.
 *
 * By this function couldn't use _malloc(sizeof(t_stattext))
*/
p_stattext stattext_new ( t_rect r, l_int align, l_text text, ... );


/**
 * Initializes the new static view filled by the bitmap @bitmap. This view
 * is disable and unselectable by default.
 *
*/
extern p_static   (*static_init) ( p_static o, t_rect r, p_bitmap bitmap, l_int flags );
p_static   _static_init ( p_static o, t_rect r, p_bitmap bitmap, l_int flags );


/**
 * Creates the new static view filled by the bitmap @bitmap. This view
 * is disable and unselectable by default.
*/
p_static   static_new ( t_rect r, p_bitmap bitmap, l_int flags );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xstat.h */
