/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XWINDOW.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XWINDOW_H_INCLUDED__
#define __XWINDOW_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include<matrixos.h>
#include"xmenu.h"

/*
  The following WF_XXXX flags are set in "window_init" function in the field
  flags. This field may be the combination of any of the followings...
*/
/*
  Makes ability to resize the window.
*/
#define WF_RESIZE          0x0001
#define WF_MINIMIZE        0x0002
#define WF_MAXIMIZE        0x0004
#define WF_STATEMINIMIZED  0x0020
#define WF_STATEMAXIMIZED  0x0040
#define WF_APPLICATION     (WF_RESIZE|WF_MINIMIZE|WF_MAXIMIZE)

#define WF_SELFIMAGE       0x0200

extern l_color  pal_window[];

typedef struct t_window* p_window;
typedef struct t_window {

  struct t_view  obclass;

  l_text         caption;
  l_int          flags;
  t_rect         restore_bounds;
  p_bitmap       icon;
  p_menuitem     addmenu;

  void       (*draw_title) ( p_window o );
  void       (*draw_work_area) ( p_window o );
  void       (*draw_title_icon) ( p_window o );
  void       (*draw_title_X) ( p_window o, l_bool press );
  l_bool     (*on_icon_pressed) ( p_window o );
  void       (*app_trans_ev)(p_object o, t_event *event);
  l_bool     (*on_maximize) ( p_window o );
  l_bool     (*on_minimize) ( p_window o );
  l_bool     (*on_restore) ( p_window o );
  p_menu     (*generate_menu) ( p_window o, p_menuitem add );
  void       (*set_caption) ( p_window o, l_text caption );

} t_window;
/*
   convert object to t_window struct, BUT it must be allocated as t_window or
   as an inherited object from t_window.
*/
#define WINDOW(o)   ((p_window)(o))

extern p_window def_window;

#define DEF_WINDOW_FUNC(y) DEF_FUNC(def_window,y)
#define DEF_WINDOW_VIEW_FUNC(y) DEF_FUNC(VIEW(def_window),y)
#define DEF_WINDOW_VIEW_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_window),y)

/*
  Initializes new window in rectangle @r. This window will have the
  caption bar with the title @caption. @o must be the new allocated
  memory not lower that size of t_window. When you have a window
  initialized, you can change all things in t_window, t_view and t_object
  before the inserting to the parent. Defualt parent is @desktop for
  windows, but you can choose also button :) for this purpose. All views
  can have other views as a man can have a child and child is higher then
  his parent.


  Returns @o.
*/
extern p_window  (*window_init) ( p_window o, t_rect r, l_text caption, l_int flags, p_bitmap icon );
p_window  _window_init ( p_window o, t_rect r, l_text caption, l_int flags, p_bitmap icon );


/*
  Initializes new window in rectangle @r. This window will have the
  caption bar with the title @caption. @o must be the new allocated
  memory not lower that size of t_window. When you have a window
  initialized, you can change all things in t_window, t_view and t_object
  before the inserting to the parent. Defualt parent is @desktop for
  windows, but you can choose also button :) for this purpose. All views
  can have other views as a man can have a child and child is higher then
  his parent.

  Returns @o.

 * Note :
 * Use this function in end-level programming and function _window_init in
 * API library when you will need to make inherited object from the window.
*/
p_window  window_new ( t_rect r, l_text caption, l_int flags, p_bitmap icon );

#ifdef __cplusplus
}
#endif

/* end of file xwindow.h */
#endif

