/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     BASICS.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/


#ifndef __BASICS_H_INCLUDED__
#define __BASICS_H_INCLUDED__

#include<stdio.h>
#include<string.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include <stdarg.h>

#define VA_LIST  va_list
#define VA_START va_start
#define VA_END   va_end

#ifndef strsize
#define strsize(p,v)    _strsize(p,v)
#endif
#ifndef min
#define min(x,y)    _min(x,y)
#endif
#ifndef max
#define max(x,y)    _max(x,y)
#endif
#ifndef imin
#define imin(x,y)   min((l_int)(x),(l_int)(y))
#endif
#ifndef imax
#define imax(x,y)   max((l_int)(x),(l_int)(y))
#endif
#ifndef umin
#define umin(x,y)   min((l_word)(x),(l_word)(y))
#endif
#ifndef umax
#define umax(x,y)   max((l_word)(x),(l_word)(y))
#endif
#ifndef lmin
#define lmin(x,y)   min((l_long)(x),(l_long)(y))
#endif
#ifndef lmax
#define lmax(x,y)   max((l_long)(x),(l_long)(y))
#endif
#ifndef dmin
#define dmin(x,y)   min((l_dword)(x),(l_dword)(y))
#endif
#ifndef dmax
#define dmax(x,y)   max((l_dword)(x),(l_dword)(y))
#endif

#ifndef MX_ID
#define MX_ID(a,b,c,d) ((a<<24) | (b<<16) | (c<<8) | d)
#endif

#ifndef MX_IDI
#define MX_IDI(a,b)    ((c<<8) | d)
#endif

#ifndef MAKEWORD
#define MAKEWORD(h,l)  (((h)<<8)+(l))
#endif
#ifndef MAKELONG
#define MAKELONG(h,l)  (((h)<<16)+(l))
#endif
#ifndef LOWORD
#define LOWORD(w)      (((w)<<16)>>16)
#endif
#ifndef HIWORD
#define HIWORD(w)      ((w)>>16)
#endif
#ifndef LOBYTE
#define LOBYTE(b)      (((b)<<8)>>8)
#endif
#ifndef HIBYTE
#define HIBYTE(b)      ((b)>>8)
#endif

#ifndef BUFFER_FORMAT_TEXT
#define BUFFER_FORMAT_TEXT   512
#endif

#ifndef             NULL
#define NULL        ((void*)0)
#endif

#ifndef false
#define false       0
#endif
#ifndef true
#define true        1
#endif

#ifndef TRUE
#define TRUE        true
#endif
#ifndef FALSE
#define FALSE       false
#endif

typedef const void               *cl_ptr;
typedef const int                 cl_bool;
typedef const long                cl_long;
typedef const int                 cl_int;
typedef const char                cl_char;
typedef const long                cl_rect;
typedef const double              cl_relrect;
typedef const long                cl_fixed;
typedef const long                cl_time;
typedef const int                 cl_color;
typedef const unsigned char       cl_byte;
typedef const unsigned short      cl_ushort;
typedef const unsigned int        cl_word;
typedef const unsigned long       cl_dword;
typedef const long long           cl_big;
typedef const long long           cl_timestamp;
typedef const short int           cl_short;
typedef const char               *cl_text;
typedef const long                cl_process;
typedef const double              cl_double;
typedef const float               cl_float;
typedef const long                cl_handle;
typedef const size_t              cl_size_t;
typedef const char                cl_tag[32];

typedef void                     *l_ptr;
typedef int                       l_bool;
typedef long                      l_long;
typedef int                       l_int;
typedef char                      l_char;
typedef long                      l_rect;
typedef double                    l_relrect;
typedef long                      l_fixed;
typedef long                      l_time;
typedef int                       l_color;
typedef unsigned char             l_byte;
typedef unsigned int              l_word;
typedef unsigned short            l_ushort;
typedef unsigned long             l_dword;
typedef long long                 l_big;
typedef long long                 l_timestamp;
typedef short int                 l_short;
typedef char                     *l_text;
typedef long                      l_process;
typedef double                    l_double;
typedef long                      l_handle;
typedef float                     l_float;
typedef size_t                    l_size_t;
typedef char                      l_tag[32];
typedef l_int                   (*l_func)();
#define _D(x)                     ((l_double)(x))
#define _F(x)                     ((l_double)(x))
#define _FGZ(x)                   _fmax(0.00000001, x)
#define _DGZ(x)                   _FGZ(x)
#define _GZ(x)                    lmax(1, x)
#define _GEZ(x)                   lmax(0, x)
#define __FREE_FUNC(x)            ((void(*)(l_ptr))(x))

extern l_double _fmin ( l_double x, l_double y );
extern l_double _fmax ( l_double x, l_double y );
extern l_big  _min ( l_big x, l_big y );
extern l_big  _max ( l_big x, l_big y );
extern l_long _strsize ( l_text p, l_text v );
extern void    nothing();
extern l_ptr   copy_type ( l_ptr  what, l_long size );

#define l_tag_cpy(x,y)  low_str_strncpy((l_text)x, (l_text)y, sizeof(l_tag))
#define l_tag_cmp(x,y)  (low_str_stricmp(x,y))
#define l_tag_test(x,y) (!l_tag_cmp(x,y))

#define clear_type(t,s)  if (t) low_mem_memset(t, 0, s)
#define clear_table(t,s) clear_type(t,s)

#define SUB_CODE do
#define END_CODE while (0)


#define BITSPERBYTE 8

#define CHARBITS    8
#define SHORTBITS   16
#define INTBITS     32
#define LONGBITS    32
#define PTRBITS     32
#define DOUBLEBITS  64
#define FLOATBITS   32

#define MINSHORT    ((l_short)0x8000)
#define MININT      ((l_int)0x80000000L)
#define MINLONG     ((l_long)0x80000000L)

#define MAXSHORT    ((l_short)0x7fff)
#define MAXINT      ((l_int)0x7fffffff)
#define MAXLONG     ((l_long)0x7fffffff)

#define MAXDOUBLE   1.79769313486231570e+308
#define MAXFLOAT    ((l_float)3.40282346638528860e+38)
#define MINDOUBLE   2.22507385850720140e-308
#define MINFLOAT    ((l_float)1.17549435082228750e-38)
#define _IEEE       0
#define _DEXPLEN    11
#define _FEXPLEN    8
#define _HIDDENBIT  1
#define DMAXEXP     ((1 << _DEXPLEN - 1) - 1 + _IEEE)
#define FMAXEXP     ((1 << _FEXPLEN - 1) - 1 + _IEEE)
#define DMINEXP     (-DMAXEXP)
#define FMINEXP     (-FMAXEXP)

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif

