/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     DRVBAS.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __DRVBAS_H_INCLUDED__
#define __DRVBAS_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"

#define CO_NOCOLOR  -1

typedef l_byte     *l_font_bitmap;

typedef void        t_bitmap;
typedef t_bitmap   *p_bitmap;

typedef void        t_font;
typedef t_font     *p_font;

typedef struct t_cursor *p_cursor;
typedef struct t_cursor {

  l_rect    xhot;
  l_rect    yhot;
  l_int     show_time;
  l_int     number;

  p_bitmap  bitmap[1];

} t_cursor;


typedef struct t_rgb *p_rgb;
typedef struct t_rgb {

   unsigned char r, g, b;
   unsigned char filler;

} t_rgb;

typedef t_rgb l_palette[256];

typedef struct t_v3d  *p_v3d;
typedef struct t_v3d                /* a 3d point (fixed point version) */
{
   l_fixed x, y, z;                 /* position */
   l_fixed u, v;                    /* texture map coordinates */
   l_int c;                         /* color */

} t_v3d;


typedef struct t_v3df *p_v3df;
typedef struct t_v3df                 /* a 3d point (floating point version) */
{
   l_float x, y, z;                   /* position */
   l_float u, v;                      /* texture map coordinates */
   l_int c;                           /* color */

} t_v3df;


/* LOW WHAT DRIVER MESSAGES */

extern l_text   low_need_platform;
extern l_text   low_need_cpu;

extern l_long   low_need_memory;
extern l_long   low_need_disk;

extern l_text   low_info_name;
extern l_long   low_info_version;

extern l_text   low_now_bitmap_struct;
extern l_text   low_now_cursor_struct;
extern l_text   low_now_font_struct;
extern l_text   low_now_datafile_struct;

extern l_text   low_now_driver_init;
extern l_text   low_now_driver_timer;
extern l_text   low_now_driver_mouse;
extern l_text   low_now_driver_key;
extern l_text   low_now_driver_grx;
extern l_text   low_now_driver_font;
extern l_text   low_now_driver_text;
extern l_text   low_now_driver_pal;
extern l_text   low_now_driver_datafile;
extern l_text   low_now_driver_load_bmp;
extern l_text   low_now_driver_save_bmp;
extern l_text   low_now_driver_emulator;

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of drvbas.h */

