/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XBITMAP.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XBITMAP_H_INCLUDED__
#define __XBITMAP_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

typedef struct t_bitmap_manager *p_bitmap_manager;
typedef struct t_bitmap_manager {

  l_text     content_type;

  p_bitmap (*loader)(p_file f, p_rgb pal);
  l_bool   (*saver)(p_file f, p_bitmap bitmap, p_rgb pal);

} t_bitmap_manager;

extern p_vector bitmap_manager;

/*
  Loads bitmap from the file filename and returns palette in @pal arrgument

  Filename must responded to content_type ( extension of the file ) that
  was previously added to bitmap_manager by function bitmap_manager_add
*/
p_bitmap bitmap_load ( l_text filename, p_rgb pal );


/*
  Saves bitmap to the file filename. Palette of the bitmap must be defined
  in @pal argument if there must be pallete for this content type or depth.

  Filename must responded to content_type ( extension of the file ) that
  was previously added to bitmap_manager by function bitmap_manager_add
*/
l_bool   bitmap_save ( l_text filename, p_bitmap bitmap, p_rgb pal );

/*
  Adds the new bitmap loader, saver of the @conent_type ( extension of the file )

  @loader will load the file @f and returns bitmap or NULL if there is no
  bitmap and @pal as the palette of the bitmap.

  Note:
  The memory returned by @loader must be freed by the caller by function
  low_grx_destroy_bitmap.

  @saver will save the file @f and returns true or false if something
  was wrong.

  NOTE:

  Both, @loader, @saver gets file @f succesfull opened and CAN'T be closed
  by the @loader, @saver.

  @loader gets file @f opened by flags F_BINARY|F_READ
  @saver  gets file @f opened by flags F_BINARY|F_WRITE
*/
void     bitmap_manager_add ( l_text content_type, p_bitmap (*loader)(p_file f, p_rgb pal), l_bool   (*saver)(p_file f, p_bitmap bitmap, p_rgb pal) );


/*
  Removes the content_type loader/saver from the bitmap_manager.
  Returns true if content_type was succesfull removed, otherwise false
  if content_type was not placed in bitmap_manager
*/
l_bool           bitmap_manager_remove ( l_text content_type );

p_bitmap_manager bitmap_manager_search_by_content ( l_text content_type );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xbitmap.h */

