/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XCOLORS.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XCOLORS_H_INCLUDED__
#define __XCOLORS_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


/* definuje nazov sekcie farieb v hlavnom INI subore */
#define  REG_COLORS             "colors"

/*
   Farebny triplet, ktory je definovany cervenov, zelenov, modrou farbou.
   Vysledna farba je brana ako neviditelna. Pouziva sa napriklad ako pozadie
   pre ikony.
*/
#define  CO_SKIP_RED             255
#define  CO_SKIP_GREEN             0
#define  CO_SKIP_BLUE            255

/*
   Farebny triplet, ktory je definovany cervenov, zelenov, modrou farbou.
   Vysledna farba je brana ako hot-point kursoru.
*/
#define  CO_HOTPOINT_RED         255
#define  CO_HOTPOINT_GREEN       150
#define  CO_HOTPOINT_BLUE        255

/* Zistuje, ci farba "x" je farba, alebo je to ukoncovaci znak
   v palete farieb. Vyuziva sa napriklad v objektoch akym je okno,
   kde tvori poslednu farbu v palete farieb.
*/
#define  CO_ISCOLOR(x)           ((x) != CO_NOCOLOR)

/*
  Zakladne systemove farebne indexy. Skutocnu farbu ziskate pouzitim
  jedneho z indexov vo funkcii COLOR(x), kde "x" je jeden z nasledujucich
  indexov.
*/
#ifndef  CO_NOCOLOR
#define  CO_NOCOLOR             -1
#endif
#define  CO_BLACK                0
#define  CO_BLUE                 1
#define  CO_GREEN                2
#define  CO_CYAN                 3
#define  CO_RED                  4
#define  CO_MAGENDA              5
#define  CO_BROWN                6
#define  CO_LIGHTGRAY            7
#define  CO_DARKGRAY             8
#define  CO_LIGHTBLUE            9
#define  CO_LIGHTGREEN           10
#define  CO_LIGHTCYAN            11
#define  CO_LIGHTRED             12
#define  CO_LIGHTMAGENDA         13
#define  CO_YELLOW               14
#define  CO_WHITE                15

#define  CO_SYSx0                0
#define  CO_SYSx1                1
#define  CO_SYSx2                2
#define  CO_SYSx3                3
#define  CO_SYSx4                4
#define  CO_SYSx5                5
#define  CO_SYSx6                6
#define  CO_SYSx7                7
#define  CO_SYSx8                8
#define  CO_SYSx9                9
#define  CO_SYSx10               10
#define  CO_SYSx11               11
#define  CO_SYSx12               12
#define  CO_SYSx13               13
#define  CO_SYSx14               14
#define  CO_SYSx15               15
#define  CO_SYSx16               16
#define  CO_SYSx17               17
#define  CO_SYSx18               18
#define  CO_SYSx19               19
#define  CO_SYSx20               20
#define  CO_SYSx21               21
#define  CO_SYSx22               22
#define  CO_SYSx23               23
#define  CO_SYSx24               24
#define  CO_SYSx25               25
#define  CO_SYSx26               26
#define  CO_SYSx27               27

/* Zisti skutocnu farbu zo systemovej palety. "n" sa pouziva
   ako jeden zo systemovych indexov.
*/
#define COLOR(n) ((n)<colors_standard[0]?colors_standard[n+1]:0)

/* Obsahuje systemove farby */
extern l_color *colors_standard;

/* Obsahuje systemovu paletu farieb */
extern l_byte palette_standard[];

/*
  Vracia farbu nazvanu ako "name_of_color" z hlavneho INI suboru zo
  sekcie [colors].

  Priklad:

  l_color x = color_get_from_ini("3D_background");
*/
l_color  color_get_from_register ( l_text name_of_color );

/*
  interne funkcie
*/
l_color *color_trans_palette ( l_byte *rgb );

void colors_init ( void );
void colors_done ( void );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xcolors.h */

