/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XERROR.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XERROR_H_INCLUDED__
#define __XERROR_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


/**
 * Called only by the system in the case, it's seems the system is going to
 * crash.
*/
extern l_int  (*error_system) ( l_text str, ... );


/**
 * Called only by the system crash brake. It's absolutly lowest layer of
 * error showing.
*/
extern l_int  (*error_low) ( l_text str, ... );


/**
 * Called by any caller in the case of Not enought memory, etc...
*/
extern l_int  (*error) ( l_text str, ... );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xerror.h */

