/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XFIXED.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XFIXED_H_INCLUDED__
#define __XFIXED_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

l_fixed  fixed_atan ( l_fixed x );
l_fixed  fixed_atan2 ( l_fixed y, l_fixed x );
l_fixed  fixed_sqrt ( l_fixed x);
l_int    fixed_toi ( l_fixed x );
l_double fixed_tof ( l_fixed x );
l_fixed  fixed_itofix ( l_int x );
l_fixed  fixed_ftofix ( l_double x );
l_fixed  fixed_cos ( l_fixed x );
l_fixed  fixed_sin ( l_fixed x );
l_fixed  fixed_tan ( l_fixed x );
l_fixed  fixed_acos ( l_fixed x );
l_fixed  fixed_asin ( l_fixed x );
l_fixed  fixed_add ( l_fixed x, l_fixed y );
l_fixed  fixed_sub ( l_fixed x, l_fixed y );
l_fixed  fixed_mul ( l_fixed x, l_fixed y );
l_fixed  fixed_div ( l_fixed x, l_fixed y );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xfixed.h */
