/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XFONTS.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XFONTS_H_INCLUDED__
#define __XFONTS_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


typedef struct t_font_loaded *p_font_loaded;
typedef struct t_font_loaded {

  p_font                    font;
  l_text                    name;
  l_int                     weight;

  l_char                    reserved[24];

} t_font_loaded;

/*
  Fonts loaded in the system
*/
extern p_vector font_loaded_system ;

/*
  Returns width of string (str) defined by font (f) and length (l).
  if l < 0  => string_length
*/
#define     FONT_GETSTRWIDTH(f,str,l)  font_string_width(f, str, l)
/* return height of font (f) */
#define     FONT_GETSTRHEIGHT(f)       font_height(f)
/* return width of char (ch) defined by font (f) */
#define     FONT_GETWIDTH(f,ch)        xgrx_text_char_sizex(f, ch)
/* return average width of font (f) */
#define     FONT_GETAVWIDTH(f)         xgrx_text_char_sizex(f, 'w')
/* return height of font */
#define     FONT_GETHEIGHT(f)          font_height(f)


/*
  Adds the new font defined by name @name and font @font of @weight to
  the system fonts.

  Returns ZERO if font was succesfull inserted. Negative number in error,
  positive if the font with the @name and @weight is installed
*/
l_int  font_loaded_add ( p_font f, l_text name, l_int weight );


/*
  Loads fonts from system registers from section @name_of_chunk
*/
void    font_loaded_load ( l_text name_of_chunk );


/*
  Unloads all fonts that was installed in the system
*/
void    font_loaded_unload ( void );


/*
  Returns font that was inserted as @fontname with height @h and @weight.

  If @weight is -1, ignores weight.
  If @height is -1, ignores height.
*/
p_font  font_loaded_get ( l_text fontname, l_int weight, l_rect h );


/*
  Returns font installed as @fontname and @weight.
*/
p_font  font_loaded_get_by_weight ( l_text fontname, l_rect weight );


/*
  Returns @weight of font installed as @fontname.
*/
l_int   font_loaded_weight ( l_text fontname );


/*
  Returns font installed as @fontname and @height.
*/
p_font  font_loaded_get_by_height ( l_text fontname, l_rect height );


/*
  Returns font installed as @fontname.
*/
p_font  font_loaded_get_by_name ( l_text fontname );


/*
  Returns height of the font @p, if the font exists,
  otherwise returns ZERO.
*/
l_rect  font_height ( p_font p );


/*
  Returns width of the string defined by font @p,
  if the font exists, otherwise returns ZERO.
*/
l_rect  font_string_width ( p_font p, l_text txt, l_int len );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xfonts.h */

