/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XGRADDS.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XGRADDS_H_INCLUDED__
#define __XGRADDS_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"
#include"xgrx.h"

/**
 * Draws icon to graphics device @o at position @x,@y and gets the icon of
 * resolution defined by @size. If icon not exists in this size, it draws
 * stretched icon to fit this size.

  @size - one of the following values :
          32   - for 32x32 icons
          16   - for 16x16 icons
          64   - for 64x64 icons
          116  - for 16x16 monochrome
          132  - for 32x32 monochrome
          164  - for 64x64 monochrome
*/
void gr_draw_icon ( p_graphics o, p_icon i, l_rect x, l_rect y, l_int size);

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xgradds.h */
