/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XGRX.H                                        */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XGRX_H_INCLUDED__
#define __XGRX_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

#define  TX_ALIGNS
#define  TX_ALIGN_LEFT     0x01
#define  TX_ALIGN_TOP      0x02
#define  TX_ALIGN_RIGHT    0x04
#define  TX_ALIGN_BOTTOM   0x08
#define  TX_ALIGN_CENTERX  0x10
#define  TX_ALIGN_CENTERY  0x20
#define  TX_ALIGN_CENTER   (TX_ALIGN_CENTERX|TX_ALIGN_CENTERY)
#define  TX_ALIGN_DEFAULT  (TX_ALIGN_TOP|TX_ALIGN_LEFT) // or 0
#define  TX_UNDERLINE      0x40
#define  TX_STRIKELINE     0x80
#define  TX_NOSMOOTHTEXT   0x100

typedef  struct t_vector  t_icon;
typedef  p_vector  p_icon;

/*
  Returns the width of the character @ch
*/
l_rect xgrx_text_char_sizex ( p_font f, l_char ch );


/**
 * Release memory of icon and returns NULL.
*/
p_icon xgrx_destroy_icon ( p_icon icon );


/*
  Returns the size @x,@y of the formated text
*/
void   xgrx_text_size_of_format ( l_text text, p_font f, l_rect *x, l_rect *y );


/*
  Returns number of characters that are available to show in "width".
*/
l_int  xgrx_text_size_in ( l_text text, p_font f, l_rect width );


/*
  Draws character
*/
void xgrx_text_draw_char ( p_bitmap bmp, p_font f, l_char chr, l_rect x, l_rect y, l_color fg, l_color bg );


/*
  Draws selected text
  @sfrom - selected text from
  @sto   - selected text to
  @align - only TX_ALIGN_LEFT of x coord is supported
  @fg1   - foreground of non-selected text
  @bg1   - background of non-selected text
  @fg2   - foreground of selected text
  @bg2   - background of selected text
*/
void xgrx_text_draw_selected ( p_bitmap  bmp, p_font f, l_text txt, l_int size,
                               l_int sfrom, l_int sto,
                               l_rect x1, l_rect y1, l_rect x2, l_rect y2,
                               l_int align, l_color fg1, l_color bg1,
                               l_color fg2, l_color bg2, l_bool clip );


/*
  Draws doubled text
  @fg1  - text of background
  @fg2  - text of foreground
*/
void xgrx_text_draw_double ( p_bitmap  bmp, p_font f, l_text txt, l_int size,
                             l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_int align,
                             l_color fg1, l_color fg2, l_bool clip );


/*
  Draws simple text

  @f     - font of the text
  @s     - text ended by \0
  @len   - length of the text. If @len is < 0, the whole text is drawn
  @x     - x coord of text
  @y     - y coord of text
  @align - alignmnet of the text
  @fg    - foreground color of text
  @bg    - background of the text. If don't want to use color - simple type
           CO_NOCOLOR
*/
void xgrx_text_draw ( p_bitmap  bmp, p_font f, l_text s, l_int len,
                      l_rect x, l_rect y, l_int align, l_color fg, l_color bg );

/*
  Draws simple text cliped by the rect @x1,@y1,@x2,@y2

  @f     - font of the text
  @s     - text ended by \0
  @len   - length of the text. If @len is < 0, the whole text is drawn
  @x1    - the left coord of the text
  @y1    - the top coord of the text
  @x2    - the right coord of the text
  @y2    - the bottom coord of the text
  @align - alignmnet of the text
  @fg    - foreground color of text
  @bg    - background of the text. If don't want to use color - simple type
           CO_NOCOLOR
*/
void xgrx_text_draw_rect ( p_bitmap bmp, p_font f, l_text s, l_int len,
                           l_rect x1, l_rect y1, l_rect x2, l_rect y2,
                           l_int align, l_color fg, l_color bg, l_bool clip );

/*
  Draws lined rect. The lines are speparated by the other one by +2 pixels
*/
void xgrx_lined_rect ( p_bitmap bmp, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_color one, l_color two );

/*
  Gradient area from the left to right or top to bottom
  in the rect @x1,@y1,@x2,@y2.

  @direct - 1 - for horizontal gradient
  @direct - 2 - for vertical gradient
*/
void xgrx_fade_rect ( p_bitmap b, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_color one, l_color two, l_char direct );


/*
  Draws button rounded by circle
*/
void xgrx_arc_button ( p_bitmap b, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_rect rad, l_color lt, l_color rb );


/*
  Draws filled rectangle rounded by circle
*/
void xgrx_arc_rectfill ( t_bitmap *b, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_rect rad, l_color c );

/*
  Draws filled arc-rectangle rounded by non-filled arc-rectangle
  @c2 - backgound
  @c1 - arc-rectangle
*/
void xgrx_arc_rectfill_ex ( t_bitmap *b, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_rect rad, l_color c, l_color c2 );

void xgrx_light_image ( p_bitmap b, p_bitmap sprite, l_rect x1, l_rect y1, l_color dr, l_color dg, l_color db );

void xgrx_make_glass ( p_bitmap b );

/**
 * Makes alphas image with a color @rr,@gg,@bb and blends this image with
 * the alpha index @alpha as the range from 0..100
*/
void xgrx_alpha_image ( p_bitmap b, p_bitmap bg, l_int dx, l_int dy,
                        l_int sx1, l_int sy1, l_int sx2, l_int sy2,
                        l_color rr, l_color gg, l_color bb, l_int alpha );

/*
  Fills rectangle by the @sprite
*/
void xgrx_sprite_rectfill ( p_bitmap b, p_bitmap sprite, l_rect x1, l_rect y1, l_rect x2, l_rect y2 );

/*
  Draw 3D rectangle

  @lt - color of left-top corner
  @rb - color of right-bottom corner
*/
void xgrx_button ( p_bitmap b, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_color lt, l_color rb );



/*
  Converts resource's bitmaps into system depended bitmap and ignores color
  defined by RGB order as @r,@g,@b. If @r or @g or @b colors are -1,-1,-1,
  function will return bitmap as is - without color-ignoring.

  Returns new bitmap on succesfull, otherwise returns NULL
*/
p_bitmap xgrx_conv_to_system_bitmap2 ( p_res_bitmap resbmp, l_int r, l_int g, l_int b );


/*
  Converts resource's bitmaps into system depended bitmap.

  Returns new bitmap on succesfull, otherwise returns NULL
*/
p_bitmap xgrx_conv_to_system_bitmap ( p_res_bitmap resbmp );


/*
  Converts resource's bitmaps ( icons ) into system depended bitmap.
  Bitmaps in resource are in 24 bits per pixel format, so it's important
  to convert them into system' byte format. Icons used the same resource
  format and the no-color is paint by 255,0,255 in RGB order.

  Returns new bitmap on succesfull, otherwise returns NULL

*/
p_bitmap xgrx_conv_to_system_icon ( p_res_icon resico );


/* This function supports both - animated and not-animated cursor */
void xgrx_cursor_free ( p_cursor cur );


/*
  Converts resource's cursor into system depended cursor structure.
  This function doesnt's support animated cursors.

  Returns new bitmap on succesfull, otherwise returns NULL
*/
p_cursor xgrx_conv_to_system_cursor ( p_res_cursor rescur );


/*
  Returns bitmap from icon that has more than one bitmap.

  @size - one of the following values :
          32   - for 32x32 icons
          16   - for 16x16 icons
          64   - for 64x64 icons
          116  - for 16x16 monochrome
          132  - for 32x32 monochrome
          164  - for 64x64 monochrome
*/
p_bitmap xgrx_icon_get_bitmap ( p_icon icon, l_rect size );

/*
  Returns new bitmap from icon that has more than one bitmap.

  @size - one of the following values :
          16   - for 16x16 icons
          32   - for 32x32 icons
          64   - for 64x64 icons
          116  - for 16x16 monochrome
          132  - for 32x32 monochrome
          164  - for 64x64 monochrome
*/
p_bitmap xgrx_icon_duplicate_bitmap ( p_icon icon, l_rect size );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xgrx.h */

