/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XINI.H                                        */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/


#ifndef __XINI_H_INCLUDED__
#define __XINI_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

#define INI_STRING      1
#define INI_HEXANUM     2
#define INI_DECANUM     3

/*
  from "c" return red color
  F.e. "c" == 0xFF0015
  Red color is FF
  Green color is 00
  Blue color is 15
*/

#define getini_red(c)   ((l_byte)((c)>>16))
#define getini_green(c) ((l_byte)(((c)<<16)>>24))
#define getini_blue(c)  ((l_byte)(((c)<<24)>>24))

#define ini_data  l_char

/*
   used as an output for
   "ini_rgb ini_get_color ( char *filename, char *ininame, char *ixname );"
   function.
*/
typedef struct ini_rgb {

  l_int r; /* red */
  l_int g; /* green */
  l_int b; /* blue */
  l_int x; /* reserved */

} ini_rgb;


ini_data *ini_search ( l_text mem, l_text ininame, l_int _alloc );
l_text   *ini_values_get ( l_text strvalue );
void      ini_values_free ( l_text *values );
l_int     ini_data_get_linenum ( ini_data *dat );
l_text    ini_def_get_line ( l_text *def, ini_data *dat, l_int line );
l_text   *ini_def_get_function ( l_text *def, l_text one );
l_text    ini_data_get_value ( ini_data *dat, l_text ixname );
l_long    ini_get_long ( l_text filename, l_text ininame, l_text ixname );
ini_rgb   ini_get_color ( l_text filename, l_text ininame, l_text ixname );
l_text    ini_get ( l_text filename, l_text ininame, l_text ixname );
l_int     ini_data_get_execute ( ini_data *data, l_int (*run)(l_text), void (**process_func)(l_long cur, l_long sz, l_text filename ) );
ini_data *ini_data_get ( l_text filename, l_text ininame );

#ifdef __cplusplus
} /* end of poor C code */
#endif

/* end of xini.h */
#endif

