/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XKEYBRD.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XKEYBRD_H_INCLUDED__
#define __XKEYBRD_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


/* state settings */

/* key was pressed */
#define  KB_SF_KEYDOWN       0x0000020
/* key was released */
#define  KB_SF_KEYUP         0x0000040
/* key-shift was released */
#define  KB_SF_SHIFTDOWN     0x0000080
/* key-shift was released */
#define  KB_SF_SHIFTUP       0x0000100

/*
  Object t_keyboard is used for getting information from keyboard.

  This object is placed in t_driver object. Whenever is
  OBJECT(driver)->translate_event... called it calls also translate_event function
  from t_keyboard, t_mouse, ... structures.
  If keyboard was pressed, the t_object.state is set to flag
  KB_SF_KEYDOWN. It also sets t_keyboard.code to pressed keycode,
  t_keyboard.shifts to shift state of pressed keycode.
*/
typedef struct t_keyboard *p_keyboard;
typedef struct t_keyboard {

  /*
    Inherite variables / functions from t_object class
  */
  struct t_object obclass;

  /*
    The code of last pressed key
  */
  l_int     code;

  /*
    Info about shifts that were pressed.
    These shifts are available from "_depkeyb.h" :

    KB_SHIFT_FLAG
    KB_CTRL_FLAG
    KB_ALT_FLAG
    KB_LWIN_FLAG
    KB_RWIN_FLAG
    KB_MENU_FLAG
    KB_SCROLOCK_FLAG
    KB_NUMLOCK_FLAG
    KB_CAPSLOCK_FLAG
    KB_INALTSEQ_FLAG
    KB_ACCENT1_FLAG
    KB_ACCENT1_S_FLAG
    KB_ACCENT2_FLAG
    KB_ACCENT2_S_FLAG
  */
  l_int     shifts;

  /*
    ASCII character of pressed key
  */
  l_char    keychar;

  /*
    Stuffs a key into the keyboard buffer, just as if the user had pressed
    it. The parameter is in the same format as returned by
    t_keyboard.readkey.
  */
  void   (*simulate_keypress) ( p_keyboard o, l_int keycode );

  /*
    Enable or disable ctrl_alt_del
  */
  void   (*set_ctrl_alt_del_flag) ( p_keyboard o, l_bool enable );

  /*
    Tests if ctrl_alt_del is enable
  */
  l_bool (*get_ctrl_alt_del_flag) ( p_keyboard o );

  /*
    Returns the next character from the keyboard buffer. If the buffer is
    empty, it waits until a key is pressed. The low byte of the return value
    contains the ASCII code of the key, and the high byte the scancode. The
    scancode remains the same whatever the state of the shift, ctrl and alt
    keys. The ASCII code is affected by shift and ctrl in the normal way
    (shift changes case, ctrl+letter gives the position of that letter in the
    alphabet, eg. ctrl+A = 1, ctrl+B = 2, etc). Pressing alt+key returns only
    the scancode, with a zero ASCII code in the low byte.
  */
  l_int  (*readkey) ( p_keyboard o );

  /*
    Clears keyboard buffer. It's called after each key_translate_event call.
  */
  void   (*clear_buffer) ( p_keyboard o );

  /*
    Tests if keyboard was pressed and wasn't read by readkey.
  */
  l_bool (*keypressed) ( p_keyboard o );


  /*
    The code of pre-last pressed shift-key. Internal.
  */
  l_int     old_code;

  /*
    The code of pre-last pressed shift-key. Internal.
  */
  l_int     old_shifts;

} t_keyboard;

/* GLOBAL keyboard class */
extern p_keyboard keyb;
extern p_keyboard def_keyboard;

#define KEYBOARD(o) ((p_keyboard)(o))
#define DEF_KEYBOARD_FUNC(y) DEF_FUNC(def_keyboard,y)

/*
   Installs the keyboard.
*/
extern t_keyboard*   (*key_init) ( p_keyboard o );
t_keyboard* _key_init ( p_keyboard o );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xkeybrd.h */

