/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XLOCHOST.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XLOCHOST_H_INCLUDED__
#define __XLOCHOST_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"
#include"xprotocl.h"

typedef struct t_localhost *p_localhost;
typedef struct t_localhost {

   t_protocol  obclass;

   /* path, where /DEV directory is placed */
   l_text      system_path;

} t_localhost;

extern  p_localhost def_localhost;
extern  p_localhost localhost;

#define DEF_LOCALHOST_FUNC(y) DEF_FUNC(def_localhost,y)
#define LOCALHOST(o) ((p_localhost)(o))

#define LOCALHOST_TEMPORARY "localhost://tmp"

p_localhost  def_localhost_init ( p_localhost o, l_text prefix );

extern p_localhost  localhost_init ( p_localhost o, l_text prefix );
extern p_localhost  localhost_free ( p_localhost o );

l_text _host_linkdir_open ( l_text filename );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xlochost.h */

