/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XMEMTEMP.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XMEMTEMP_H_INCLUDED__
#define __XMEMTEMP_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


typedef struct t_mtemp *p_mtemp;
typedef struct t_mtemp {

    /* allocated block */
    l_ptr     *ptr;

    /* number of bytes writen into ptr */
    l_long     writen;
    /* the current position */
    l_long     pos;
    /* the lenght succefull alloceted in block */
    l_long     block;
    /* delta of allocation */
    l_long     delta;
    /* maximum size of block */
    l_long     limit;

} t_mtemp;


/*
  Creates new memory temporary used to writing and reading data from
  memory.
  @block - the first block of allocation
  @delta - delta that will increased each block when will overflow
  @limit - limit of block that can be overflow

  Returns new p_mtemp that must be later releases by caller, by function
  mtemp_close.
*/

p_mtemp  mtemp_open ( l_long block, l_long delta, l_long limit );

/*
   Reads @sz number of bytes to @ptr and returns size in bytes succesfull
   read and increases current position by @sz.

   Usage :

   l_long s;
   mtemp_read(p, &s, sizeof(l_long));
*/
l_long  mtemp_read ( p_mtemp p, l_ptr ptr, l_long sz );

/*
  Sets the current position to @where.

  @Whence can be :

  0 - sets the physical position as @where
  1 - sets the position as delta from the current position
*/
l_bool  mtemp_set_pos ( p_mtemp p, l_long where, l_int whence );


/*
   Returns the current position in the memory
*/
l_long  mtemp_get_pos ( p_mtemp p );


/*
   Returns the pointer of memory
*/
l_ptr   mtemp_get_ptr ( p_mtemp p );


/*
   Returns succesfull allocated memory till now.
*/
l_long  mtemp_length ( p_mtemp p );


/*
   Writes @sz number of bytes to @ptr and returns size in bytes succesfull
   writen and increases current position by @sz.
*/
l_long  mtemp_write ( p_mtemp p, l_ptr ptr, l_long sz );


/*
   Reads the string from the temporary memory that will previously stored
   by function mtem_writestr and was stored at the same position as the
   current position of reading string is.
   @ptr - text returned by the function ended by '\0'

   Returns the size of bytes succesfull read. Please note that this size
   is not the size of string, but by default the size of string+4+1.

   Note :
   The memory returned in @ptr by this call must be freed by the caller.
*/
l_long  mtemp_read_string ( p_mtemp p, l_text *ptr );


/*
   Writes the string to the temporary memory that.
   @ptr - text that will be stored in the temp memory ended by '\0'

   Returns the size of bytes succesfull read. Please note that this size
   is not the size of string, but by default the size of string+4+1.

   This function firstly copy the length of text +sizeof(l_char), then
   copy the string of the size "size+sizeof(l_char)".
*/
l_long  mtemp_write_string ( p_mtemp p, l_text text );


/*
  Close the temporary memory, that was opened by mtemp_open, see above.
  If the memory temporary existed, this function return true, otherwise
  false.
*/
l_bool  mtemp_close ( p_mtemp p );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xmtemp.h */

