/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XMXFGEN.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XMXFGEN_H_INCLUDED__
#define __XMXFGEN_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

#define MXFILE_MAGIC  MX_ID('M','X','0','1')

typedef struct t_mxfile_header *p_mxfile_header;
typedef struct t_mxfile_header {

  l_long    magic;
  /* flags for mx_header */
  l_long    flags;
  /* number of imports */
  l_long    n_imports;
  /* number of relocation */
  l_long    n_relocs;
  /* offset to export table */
  l_long    o_exptable;
  /* appliction size */
  l_long    a_size;
  /* Offset (!after t_mxfile_header!), where the resource are stored.
     When you read t_mxfile_header, add this offset and you will get
     the offset of first byte in resource file. In the case o_resource
     is 0, there is no resource.
  */
  l_long    o_resource;

  /* Offset of main application function
  */
  l_long    o_main;

  /**
   * Offset of done application function
  */
  l_long    o_done;

  /**
   * Offset of instance application function
  */
  l_long    o_instance;

  /* long file name, in the file starts with long that indicated size of
     string and then is stored the string.
  */
  l_text    lfn;
  /* icon name in resources, in the file starts with long that indicated size
     of string and then is stored the string.
  */
  l_text    icon_name;

} t_mxfile_header;


#define MXFILE_ERR_TOO_MANY_SECTIONS -1
#define MXFILE_ERR_LD_EXECUTION      -2
#define MXFILE_ERR_NOT_TEMP          -3
#define MXFILE_ERR_BAD_COFF_FILE     -4

/*
  Generates MatrixOS Executable file from DJ's COFF file, where @src is
  DJ's COFF and dst is MatrixOS Executable.
  @long_name - it's support of for applications with long names that are
               executing on computers with 8 character length filename.
  @libs      - libraries, we want to link to the executable.
  @icon_name - the name of icon in resources.
  @resource  - the file, where resources are placed.

  Returns error or 0 if all was succesfull.

  Error may be one of follwoing :

  MXFILE_ERR_TOO_MANY_SECTIONS
  MXFILE_ERR_LD_EXECUTION
  MXFILE_ERR_NOT_TEMP
  MXFILE_ERR_BAD_COFF_FILE

Note :

  Each resource should have more icons for the name IconName.
  Must have one 32x32 but for better quality in showing is better
  to add also 16x16.
  Then can add 64x64 and at the end animated icons in the same order.

  0. 32x32 - must
  1. 16x16 - should
  2. 64x64 - may
  3. 32x32 monochrome - may
  4. 16x16 monochrome - may
  5. 64x64 monochrome - may
  6. 32x32 animated - may
  7. 16x16 animated - may
  9. 64x64 animated - may

  Why we start with 32x32 and then continue with 16x16. It's because
  desktop need to have this resolution and window need to have 16x16, but
  in the case you add only one icon it's better to (zoom out) then
  (zoom in) - higher lose of quality.
*/
l_int   mxfile_generate ( l_text src, l_text dst, l_text long_name, l_text libs, l_text icon_name, l_text resource_file );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xmxfgen.h */

