/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XMXFLOAD.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XMXFLOAD_H_INCLUDED__
#define __XMXFLOAD_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


extern void(*mxf_first_ctor[])() __asm__("mxf_first_ctor");
extern void(*mxf_last_ctor[])()  __asm__("mxf_last_ctor");
extern void(*mxf_first_dtor[])() __asm__("mxf_first_dtor");
extern void(*mxf_last_dtor[])()  __asm__("mxf_last_dtor");


#define MXFCPPCONSTRUCT() SUB_CODE {\
                        l_long i=0;\
                        for (i=0; i<mxf_last_ctor-mxf_first_ctor; i++)\
                        mxf_first_ctor[i]();\
                      } END_CODE
#define MXFCPPDESTRUCT() SUB_CODE { \
                        l_long i=0;\
                        for (i=0; i<mxf_last_dtor-mxf_first_dtor; i++)\
                        mxf_first_dtor[i]();\
                      } END_CODE


#define MXFEXPORTCLASS(x)  "_"#x, (l_text)(&(x)),
#define MXFEXPORT(x)  "_"#x, (l_text)(&(x)),
#define MXFEXPORT_BEGIN   static l_text _MXFEXPORTTABLE[] = {
#define MXFEXPORT_END     0, 0 };


typedef struct t_mxfload_error *p_mxfload_error;
typedef struct t_mxfload_error {

  p_vector     error_strings;
  l_text       filename;

  void         (*add) ( l_text err, ... );
  void         (*see) ( void );

} t_mxfload_error;

p_mxfload_error (*mxfloaderr_create) ( l_text filename );


/* Information about applications */
p_vector mxfload_handles;

/*
  The following format must have each MXFEXPORT.
*/
typedef struct t_mxfile_symbol *p_mxfile_symbol;
typedef struct t_mxfile_symbol {

  l_text    name;	   /* Symbol's name ("printf", "strlen" and so on */
  l_long    offset;  /* Symbol's offset - pointer to the function/variable */

} t_mxfile_symbol;

/**
 * Selects that only one time can be application loaded in
*/
#define MXFH_ONEINSTANCE   0x0000000001

/*
  Add exports to global export table.

  Returns -1 on error, 0 on success.
*/
l_int mxfload_add_exports ( p_mxfile_symbol x );


/*
  The same as above "mxfload_add_exports", but set _MXFEXPORTTABLE as @x
*/
#define mxfload_export()   mxfload_add_exports((p_mxfile_symbol)(_MXFEXPORTTABLE))


#define MXFLOAD_ERR_CANNOTOPEN          -1
#define MXFLOAD_ERR_NOTENOUGHMEMORY     -2
#define MXFLOAD_ERR_INCORRECTFILE       -3
#define MXFLOAD_ERR_BADFILE             -4
#define MXFLOAD_ERR_UNRESOLVEDEXTERNALS -5
#define MXFLOAD_ERR_INSTANCEFAILED      -6
#define MXFLOAD_ERR_MAINFUNCNOTFOUND    -20
#define MXFLOAD_ERR_MAINFUNCRETCODE     -100
#define MXFLOAD_OK(x) ((x) <= MXFLOAD_ERR_MAINFUNCRETCODE)

#define MXFLOAD_FLAG_INFORMATION         0x01
#define MXFLOAD_FLAG_LOAD                0x02
#define MXFLOAD_FLAG_EXECUTE             0x04
#define MXFLOAD_FLAG_ICONS               0x08
#define MXFLOAD_FLAG_RUN                 (MXFLOAD_FLAG_EXECUTE|MXFLOAD_FLAG_LOAD)

/*
  Load file "filename" of MXF format.

  @flags - MXFLOAD_FLAG_INFORMATION. If set this flag, @lfn and @icon_name
           will conatin application name and the name of icon that's stored
           in the resources of this file.
           MXFLOAD_FLAG_LOAD. Load the application/library and add exports
           to global export table.
           MXFLOAD_FLAG_EXECUTE. Execute application, only if application
           contain main function AppMain.
           Note : Please note that MXF format can export function/variables
           from the application too. But be carefull, because in the case
           you end the application, all exports are erased from the memory
           and another application that used them will crash. You must
           close library/application in the push/pop order. ( Last loaded
           must be closed as the first ).
           MXFLOAD_FLAG_ICONS. Returns vector in @icons where, icons are
           stored named @icon_name.
  @args  - arguments of executed file. Each argument is separated by "%%"

  Returns 0 on success, otherwise one of MXFLOAD_ERR_XXX.

  Note :
  The memory returned by this call in @lfn, @icon_name must be freed by
  the caller.
*/

l_int     mxfload2 ( l_text filename, l_text args, l_int flags, l_text *lfn, l_text *icon_name, p_vector *resource );

/**
 * Search for handle in loaded list.
*/
l_handle  mxfload_find_handle ( l_text filename );

/**
 * Search for handle in loaded list.
*/
l_handle  mxfload_find_handle_app ( p_object app );

/*
  Returns the pointer of symbol defined by "name" from global symbols,
  or NULL on error.
*/
l_ptr   mxfload_get_symbol ( l_text name );


/**
 * Quits application or library and dispose it from the memory.
 * Returns TRUE if succesfull exited.
*/
l_bool internal_exit ( l_handle id );

/*
  Returns Application name of application @id. Each application/library
  gets @id in app_main, lib_main function as 2nd argument.
*/
l_text internal_lfn ( l_handle id );

/**
 * Sets main application object for this handle
*/
p_object internal_get_application ( l_handle id );


/**
 * Registers new application
*/
p_object internal_register_application ( l_handle id, p_object app );


/**
 * Sets main application object for this handle
*/
l_bool internal_set_application ( l_handle id, p_object app );


/*
  Returns Resources of application @id. Each application/library
  gets @id in app_main, lib_main function as 2nd argument.
*/
p_vector internal_resource ( l_handle id );


/*
  Returns path of application @id. Each application/library
  gets @id in app_main, lib_main function as 2nd argument.
*/
l_text internal_path ( l_handle id );

/**
 * Sets flags for current process, see MXFH_XXXX
*/
l_dword  internal_set_flags ( l_handle id, l_dword flags, l_bool set );

/**
 * Gets flags of the current process
*/
l_dword  internal_get_flags ( l_handle id );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif

