/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XPROGRAM.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XPROGRAM_H_INCLUDED__
#define __XPROGRAM_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

#include"./codedep/_depio.h"
#include"./codedep/_depbmp.h"
#include"./codedep/_depcpmt.h"
#include"./codedep/_depmem.h"
#include"./codedep/_deplog.h"
#include"./codedep/_depstr.h"
#include"./codedep/_depgrx.h"
#include"./codedep/_deppal.h"
#include"./codedep/_depinit.h"
#include"./codedep/_depfont.h"
#include"./codedep/_deptmr.h"
#include"./codedep/_depmath.h"
#include"./codedep/_depkeyb.h"
#include"./codedep/_depmous.h"
#include"./codedep/_depsig.h"
#include"./codedep/_depasy.h"

#include"defs.h"
#include"xvector.h"
#include"xerror.h"
#include"xfixed.h"
#include"xstring.h"
#include"xproper.h"
#include"xmemtemp.h"
#include"xcoord.h"
#include"xprotocl.h"
#include"xlochost.h"
#include"xdeshost.h"
#include"xtrash.h"
#include"xmemory.h"
#include"xfile.h"
#include"xgraphic.h"
#include"xfilter.h"
#include"xobject.h"
#include"xini.h"
#include"xregs.h"
#include"xmouse.h"
#include"xasydev.h"
#include"xbitmap.h"
#include"xkeybrd.h"
#include"xscreen.h"
#include"xresfile.h"
#include"xdrives.h"
#include"xgrx.h"
#include"xgradds.h"
#include"xexec.h"
#include"xfonts.h"
#include"xcolors.h"
#include"xsigerr.h"
#include"xmxfgen.h"
#include"xmxfload.h"
#include"xdrivers.h"
#include"xlist.h"
#include"xview.h"
#include"xdesktop.h"
#include"xgrxfont.h"

#define qube_set_function(_w,_f,_nf) (*_w).##_f = _nf
#define qube_set_variable(_w,_f,_nf) (*_w).##_f = _nf
#define qube_get_function(_w,_f) (*_w).##_f
#define qube_get_variable(_w,_f) (*_w).##_f

/**
 * This function is called when [startup] register section is read and for
 * each line in the section is called function by current position of
 * line @cur, maximum lines @sz and @filename that's currently executed.
*/
extern void  (*program_startup_process) ( l_long cur, l_long sz, l_text filename );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xprogram.h */

