/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XPROPER.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XPROPER_H_INCLUDED__
#define __XPROPER_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"

/**
 * Properties struct is used for getting infomration about
 * a values inside the system, where @proper_name is the name of
 * getting information, @proper_value is just the information and
 * there may be a case when we can't use static information, so
 * we used @proper_dynamic_value as the function. This function is
 * called only if proper_value is NULL.
*/
typedef struct t_properties *p_properties;
typedef struct t_properties {

        l_text     proper_name;
        l_dword    proper_value;
        l_dword  (*proper_dynamic_value)();

} t_properties;

/**
 * Vector of system properties
*/
extern p_vector  properties_system;


/**
 * Releases the memory of one properties and returns NULL.
*/
void  properties_free ( l_ptr p );


/**
 * Creates one properties
*/
static p_properties properties_new ( l_text name, l_dword value, l_dword (*dynamic_value)() );


/**
 * Gets properties by name @name.
*/
p_properties properties_get_prop ( p_vector prop, l_text name );


/**
 * This function add a properties to vector @prop and returns the new
 * vector @prop. If the @name exists in one of properties in vector
 * @prop, this properties will be changed by new values.
*/
p_vector  properties_add ( p_vector prop, l_text name, l_dword value, l_dword (*dynamic_value)() );


/**
 * Gets the value from properties vector. If @name no exists as the name
 * of one of properties inside the vector, it returns NULL, otherwise it
 * returns @t_properties.proper_value if not NULL, or
 * @t_properties.proper_dynamic_value() if not NULL and @t_properties.proper_value
 * is NULL.
*/
l_dword  properties_get ( p_vector prop, l_text name );


/**
 * Releases properties get by name from vector @prop.
*/
void  properties_remove ( p_vector prop, l_text name );


/**
 * Gets the value from system properties. If @name no exists as the name
 * of one of properties inside the system properties, it returns NULL,
 * otherwise it returns @t_properties.proper_value if not NULL, or
 * @t_properties.proper_dynamic_value() if not NULL and @t_properties.proper_value
 * is NULL.
*/
l_dword  properties_system_get ( l_text name );


/**
 * Releases properties get by name from vector system properties.
*/
void  properties_system_remove ( l_text name );


/**
 * This function add a properties to system properties.
 * If the @name exists in one of system properties, this properties
 * will be changed by new values.
*/
void  properties_system_add ( l_text name, l_dword value );


/**
 * This function add a properties to system properties.
 * If the @name exists in one of system properties, this properties
 * will be changed by new values.
*/
void  properties_system_add2 ( l_text name, l_dword (*dynamic_value)() );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xproper.h */
