/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XRSCRIPT.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XRSCRIPT_H_INCLUDED__
#define __XRSCRIPT_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"


/*
  Read Windows 24bit non-compressed Bitmap file from file "filename"
  and translate it to the Matrix resource image/icon format.

  Returns size of memory needed for image resource image/icon
  Inserts new allocated memory of resource image/icon to @b.

  Usage :

  l_byte *b = NULL;

  l_long  size = script_translate_bmp24 ( &b, "localhost://dev/mx/matrix.bmp");
  l_long  size = script_translate_bmp24_2 ( &b, "localhost://dev/mx/matrix.cur", 5, 5);

  offset of @b:
  0...4       = width of the image
  4...8       = height of the image
  8..12       = size of the image, the same as width*height*3
  12..16      = xhot - important in cursor, don't use in bitmap
  16..20      = yhot - important in cursor, don't use in bitmap
  20..size+20 = image data of BLUE,GREEN,RED,BLUE,GREEN,RED,....

  Can read as :

  width  = ((l_long*)b)[0];
  height = ((l_long*)b)[1];
  size   = ((l_long*)b)[2];
  xhot   = ((l_long*)b)[3]; // in the case of bitmap 0
  yhot   = ((l_long*)b)[4]; // in the case of bitmap 0
  data   = (l_byte*)(&((l_long*)b)[3]);

  low_mem_free(b);
*/
l_long  script_translate_bmp24_2 ( l_byte **b, l_text filename, l_long xhot, l_long yhot );

l_long  script_translate_bmp24 ( l_byte **b, l_text filename );


/*
  This function translates all script functions to pointer of binary data
  Returns pointer that will be stored to binary file after REBIN_BODY

  Inserts size of the block that's returned by the function into @size
  Inserts new definition name of the block that's returned by the
  function into @ret_def

  Note :
  The memory returned by this call must be freed by the caller.
  The memory inserted by this call to @ret_def must be freed by the caller.
*/
l_ptr script_callback ( l_text def, l_text after_body, l_long *size, l_text *ret_def );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xrscript.h */

