/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XTRASH.H                                      */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XTRASH_H_INCLUDED__
#define __XTRASH_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"basics.h"
#include"drvbas.h"
#include"xprotocl.h"
#include"xlochost.h"

typedef struct t_trashbin *p_trashbin;
typedef struct t_trashbin {

   t_localhost obclass;

   l_bool     (*is_empty) ( p_trashbin o );

} t_trashbin;

extern  p_trashbin def_trashbin;
extern  p_trashbin trashbin;

#define DEF_TRASHBIN_FUNC(y) DEF_FUNC(def_trashbin,y)
#define DEF_TRASHBIN_LOCALHOST_FUNC(y) DEF_FUNC(LOCALHOST(def_trashbin),y)
#define TRASHBIN(o) ((p_trashbin)(o))

extern p_trashbin  trashbin_init ( p_trashbin o, l_text prefix );
extern p_trashbin  trashbin_free ( p_trashbin o );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xtrash.h */
