/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XHTTP.H                                       */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/


#ifndef __XHTTP_H_INCLUDED__
#define __XHTTP_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include<matrixos.h>
#include"theader.h"
#include"xsocket.h"

#define HTTPVER     "HTTP/1.[01]"
#define HTTPVER10   "HTTP/1.0"
#define HTTPVER11   "HTTP/1.1"

#define HSP_HTTP_NONE          SP_NONE
#define HSP_HTTP_AUTH_HEADER   10
#define HSP_HTTP_READ_HEADER   11
#define HSP_HTTP_TRANSFER      12

#define ERR_HTTP_OK                     ERR_SOCKET_OK
#define ERR_HTTP_CANNOT_RESOLVE        -20


typedef struct t_httpsock *p_httpsock;
typedef struct t_httpsock {

  struct t_socket    obclass;

  l_text     path;
  l_text     host;
  l_int      proxy_port;
  l_text     proxy_host;
  l_int      response;
  l_long     contentlength;

  l_dword    http_phase;

  l_long     (*get_content_length)( p_httpsock o );
  l_int      (*get_response)( p_httpsock o );
  l_text     (*get_host)( p_httpsock o );
  l_text     (*get_path)( p_httpsock o );

  l_int      (*connect_to) ( p_httpsock o, l_text addr, l_text proxy_host, l_int proxy_port );

} t_httpsock;

extern p_httpsock def_httpsock;

#define DEF_HTTPSOCK_FUNC(y) DEF_FUNC(HTTPSOCK(def_httpsock),y)
#define DEF_HTTPSOCK_SOCKET_FUNC(y) DEF_FUNC(SOCKET(def_httpsock),y)
#define DEF_HTTPSOCK_SOCKET_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_httpsock),y)

#define HTTPSOCK(o) ((p_httpsock)(o))


/**
 * Initializes new socket object.
*/
extern p_httpsock  (*httpsock_init) ( p_httpsock o );
p_httpsock  _httpsock_init ( p_httpsock o );


/**
 *
*/
p_httpsock  httpsock_create ( void );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif

