/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XPPP.H                                        */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of QubeOS                                  */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef __XPPP_H_INCLUDED__
#define __XPPP_H_INCLUDED__

#include<matrixos.h>

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

/* Can continue */
#define PPP_USE_OTHER_PART            1
#define PPP_IP_NETWORK_OK             0
/* Error codes */
#define PPP_BAD_DEVICE               -1
#define PPP_BUSY_ISP                 -2
#define PPP_TIMEOUT                  -3
#define PPP_DIALING_FAILED           -4
#define PPP_IOCTLUP_ERROR            -5
#define PPP_CARRIER_LOST             -6
#define PPP_DISCONNECT               -7
#define PPP_BAD_AUTHENTICATION       -8
#define PPP_CANT_ESTABLISH           -9
#define PPP_OTHER_PART_IN_PROCESS   -10


/**
 * Open Point-To-Point protocol and initialized the asynchronious device
 * defined in registers as @modem_name. For the connection will be dialed
 * @phone_number. @login is the username for Internet Provider Service (ISP)
 * and @passwd is the password.
 * If the connection is succesfull opened, function returns ZERO, otherwise
 * returns > ZERO if the connection was opened before or < ZERO if the
 * connection can't be established. For more return codes, please see :
 *
 * PPP_IP_NETWORK_OK     - can continue
 * PPP_USE_OTHER_PART    - can continue
 * PPP_BAD_DEVICE
 * PPP_BUSY_ISP
 * PPP_TIMEOUT
 * PPP_DIALING_FAILED
 * PPP_IOCTLUP_ERROR
 * PPP_CARRIER_LOST
 * PPP_DISCONNECT
 * PPP_BAD_AUTHENTICATION
 * PPP_CANT_ESTABLISH
 * PPP_OTHER_PART_IN_PROCESS
 *
 * @command is the identification that indicates if something not stop the
 * dialing process. If @command is ZERO, everything is OK and the connection
 * is proceed. If @command is set to NON-ZERO, dialing is stop.
*/
l_int  ppp_open( l_regdata reg, l_text modem_name, l_text phone_number, l_text login, l_text passwd, l_int *command );

/**
 * Stop the connection and hangs up modem
*/
l_bool ppp_hangup ( void );


/**
 * Tests, if PPP is opened. Returns ZERO if not, -1 if other PPP is in
 * process of establishing, returns 1 if other PPP is in process.
 * So, OK values are 0 and 1.
*/
l_int ppp_is_open ( void );


/**
 * Set some argument of PPP defined by @name to @value and returns
 * TRUE on success, otherwise returns FALSE.
*/
l_bool ppp_set ( l_text name, l_ptr value );


/**
 * Sends @data of lenght @len by PPP. Returns TRUE on success, otherwise
 * returns FALSE.
*/
l_bool ppp_send ( l_byte *data, l_ushort len );


/**
 * Returns IP address of the connection or ZERO if the connection is
 * not established.
*/
l_dword ppp_ipaddr ( void );
l_text  ppp_ipaddr_str ( void );


/**
 * Returns REMIP address of the connection or ZERO if the connection is
 * not established.
*/
l_dword ppp_remip ( void );
l_text  ppp_remip_str ( void );


/**
 * Returns NETMASK of the connection or ZERO if the connection is
 * not established.
*/
l_dword ppp_netmask ( void );
l_text  ppp_netmask_str ( void );


/**
 * Returns MRU value of the connection or ZERO if the connection is
 * not established.
*/
l_int ppp_peermruval ( void );


l_byte ppp_access ( l_byte dclass, l_ushort dtype, l_byte  wantnum,
             l_ushort pktype_len, l_byte *pktype, l_int (*receiver)(), l_ptr *rethandle );


l_byte ppp_drvrclass ( void );

l_byte ppp_release ( l_ptr phandle );

l_byte ppp_reset ( l_ptr phandle );

l_byte ppp_close ( l_ptr phandle );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of xppp.h */

