/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     XSOCKET.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/


#ifndef __XSOCKET_H_INCLUDED__
#define __XSOCKET_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include<matrixos.h>
#include"theader.h"

#define SOCKET_TRANSFER_SIZE  2048

/**
 * t_socket' phases
*/
#define SP_CONNECTED              1
#define SP_NONE                   0
#define SP_WAIT_ESTABLISHED      -1
#define SP_CLOSED                -2

/**
 * t_socket' flags
*/
#define SF_TCP_SOCKET             0
#define SF_UDP_SOCKET             1

/**
 * t_socket errors
*/
#define ERR_SOCKET_OK                          0
#define ERR_SOCKET_HOST_REFUSED_CONNECTION    -1
#define ERR_SOCKET_TIME_OUT                   -2
#define ERR_SOCKET_CANT_CREATED               -3
#define ERR_SOCKET_NO_SOCKET                  -4


typedef struct t_socket *p_socket;
typedef struct t_socket {

  struct t_object   obclass;

  l_ptr        socket;
  l_int        socket_delay;
  l_dword      address;
  l_ushort     port;
  l_int        flags;

  l_int        phase;

  l_byte      *buffer;
  l_dword      bufpos;
  l_dword      buffill;
  l_dword      bufsize;

  l_byte      *buffer_send;
  l_dword      bufpos_send;
  l_dword      buffill_send;
  l_dword      bufsize_send;

  l_int        error;

  void         (*clear_socket) ( p_socket o );
  l_ushort     (*get_port) ( p_socket o );
  l_dword      (*get_addr) ( p_socket o );
  l_int        (*get_last_error) ( p_socket o );
  l_int        (*connect) ( p_socket o, l_dword ina, l_ushort port, l_int flags );
  l_int        (*close) ( p_socket o, l_int inf );
  l_int        (*on_connect) ( p_socket o );
  l_int        (*on_close) ( p_socket o, l_int inf );
  l_int        (*on_receive) ( p_socket o );
  l_int        (*on_send) ( p_socket o, l_int len );
  l_int        (*send) ( p_socket o, l_ptr data, l_int len );
  l_int        (*receive) ( p_socket o, l_ptr data, l_int len );
  void         (*add_to_buffer) ( p_socket o, l_ptr dp, l_int len );
  l_int        (*get_from_buffer) ( p_socket o, l_ptr dp, l_int len );
  l_text       (*get_from_buffer_line) ( p_socket o );
  l_int        (*clear_in_buffer) ( p_socket o, l_int len );
  l_int        (*low_send) ( p_socket o, l_ptr data, l_int len );

  void         (*add_to_buffer_send) ( p_socket o, l_ptr dp, l_int len );
  l_int        (*clear_in_buffer_send) ( p_socket o, l_int len );
  l_int        (*get_from_buffer_send) ( p_socket o, l_ptr dp, l_int len );
} t_socket;


extern p_socket def_socket;

#define DEF_SOCKET_FUNC(y) DEF_FUNC(def_socket,y)
#define DEF_SOCKET_OBJECT_FUNC(y) DEF_FUNC(OBJECT(def_socket),y)

#define SOCKET(o) ((p_socket)(o))


/**
 * Initializes new socket object.
*/
extern p_socket  (*socket_init) ( p_socket o );
p_socket  _socket_init ( p_socket o );

/**
 * Makes new socket object and inserts it to drivers. If you would like to
 * read bytes comming inside the object, use function "on_receive" to
 * redirect it to your function for catching incoming bytes. To get information
 * when can start sending data use function "on_connect" when the first
 * data will be sending and then all data will cathed and sends by function
 * "on_receive".
*/
p_socket  socket_create ( void );


/**
 * Tests, if TCP/IP driver is succesfull opened.
*/
l_bool  tcpip_driver_is_open ( void );

/**
 * Closes TCP/IP driver
*/
void    tcpip_driver_close ( void );

/**
 * Open TCP/IP driver.
*/
l_bool  tcpip_driver_open ( l_text ipaddr, l_text netmask, l_text remip, l_text dns );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif

