/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPASY.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPASY_H_INCLUDED__
#define ___DEPASY_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"
#include"../drvbas.h"

/**
 * Asynchronious DEV devices.
*/
#define ASY_MAX      4
#define ASY_DEV1     0
#define ASY_DEV2     1
#define ASY_DEV3     2
#define ASY_DEV4     3
#define ASY_DEV5     4
#define ASY_DEV6     5
#define ASY_DEV7     6
#define ASY_DEV8     7

/* exported */
extern struct t_low_asy low_asy_devices[ASY_MAX];


#define PARAM_DTR     0
#define PARAM_RTS     1
#define PARAM_SPEED   2
#define PARAM_DOWN    3
#define PARAM_UP      4


/* Output pseudo-dma control structure */
struct t_low_asy_dma {
        l_byte *data;            /* current output pointer */
        l_ushort cnt;             /* byte count remaining */
        volatile l_byte busy;    /* transmitter active */
};

/* Read fifo control structure */
struct t_low_asy_fifo {
        l_byte *buf;             /* Ring buffer */
        l_ushort bufsize;         /* Size of ring buffer */
        l_byte *ep;              /* End of buffer */
        l_byte *wp;              /* Write pointer */
        l_byte *rp;              /* Read pointer */
        volatile l_ushort cnt;    /* count of characters in buffer */
};

/* Asynch controller control block */
typedef struct t_low_asy *p_low_asy;
struct t_low_asy {
        struct t_low_asy_fifo fifo;
        struct t_low_asy_dma dma;

        l_int    pppunit;            /* PPP device number for this tty */
        l_ushort pppsem;          /* PPP receive callback semaphore */

        l_ushort addr;            /* Base I/O address */
        l_int    vec;                /* Interrupt vector */
        l_long   speed;             /* Line speed in bits per second */

        l_byte is_16550a;        /* 16550A detected */
        l_byte msr;              /* Copy of current modem status register */
        l_byte cts;              /* obey CTS lead for xmit flow control */
        l_byte rlsd;             /* RLSD (CD) indicates line state */
        l_byte carrier;          /* Other way of indicating CD state */
        l_byte chain;            /* Do interrupt vector chaining */
        l_byte timer_in;

        l_int  (*ppp_receiver)( l_int pppunit, cl_byte *buf, l_int cnt );
};

#define BAUDCLK 115200L         /* 1.8432 Mhz / 16 */

/* National 8250 asynch UART definitions */
/* Control/status register offsets from base address */
#define THR     0               /* Transmitter holding register */
#define RBR     0               /* Receiver buffer register */
#define DLL     0               /* Divisor latch LSB */
#define DLM     1               /* Divisor latch MSB */
#define IER     1               /* Interrupt enable register */
#define IIR     2               /* Interrupt ident register */
#define FCR     2               /* FIFO control register (16550A only) */
#define LCR     3               /* Line control register */
#define MCR     4               /* Modem control register */
#define LSR     5               /* Line status register */
#define MSR     6               /* Modem status register */

/* 8250 Line Control Register */
#define LCR_5BITS       0x00    /* 5 bit words */
#define LCR_6BITS       0x01    /* 6 bit words */
#define LCR_7BITS       0x02    /* 7 bit words */
#define LCR_8BITS       0x03    /* 8 bit words */
#define LCR_BIT_MASK    0x03    /* mask of bit size */
#define LCR_NSB         0x04    /* Number of stop bits */
#define LCR_PEN         0x08    /* Parity enable */
#define LCR_EPS         0x10    /* Even parity select */
#define LCR_SP          0x20    /* Stick parity */
#define LCR_SB          0x40    /* Set break */
#define LCR_DLAB        0x80    /* Divisor Latch Access Bit */

/* 8250 Line Status Register */
#define LSR_DR          0x01    /* Data ready */
#define LSR_OE          0x02    /* Overrun error */
#define LSR_PE          0x04    /* Parity error */
#define LSR_FE          0x08    /* Framing error */
#define LSR_BI          0x10    /* Break interrupt */
#define LSR_THRE        0x20    /* Transmitter line holding register empty */
#define LSR_TSRE        0x40    /* Transmitter shift register empty */

/* 8250 Interrupt Identification Register */
#define IIR_IP          0x01    /* 0 if interrupt pending */

#define IIR_MSTAT       0x00    /* Modem status interrupt */
#define IIR_THRE        0x02    /* Transmitter holding register empty int */
#define IIR_RDA         0x04    /* Receiver data available interrupt */
#define IIR_RLS         0x06    /* Receiver Line Status interrupt */
#define IIR_ID_MASK     0x06    /* Mask for interrupt ID */

#define IIR_FIFO_TIMEOUT 0x08   /* FIFO timeout interrupt pending - 16550A */
#define IIR_FIFO_ENABLED 0xc0   /* FIFO enabled (FCR0,1 = 1) - 16550A only */


/* 8250 interrupt enable register bits */
#define IER_DAV         0x01    /* Data available interrupt */
#define IER_TxE         0x02    /* Tx buffer empty interrupt */
#define IER_RLS         0x04    /* Receive line status interrupt */
#define IER_MS          0x08    /* Modem status interrupt */

/* 8250 Modem control register */
#define MCR_DTR         0x01    /* Data Terminal Ready */
#define MCR_RTS         0x02    /* Request to Send */
#define MCR_RFR         MCR_RTS /* Ready for Receiving (same as RTS) */
#define MCR_OUT1        0x04    /* Out 1 (not used) */
#define MCR_OUT2        0x08    /* Master interrupt enable (actually OUT 2) */
#define MCR_LOOP        0x10    /* Loopback test mode */

/* 8250 Modem Status Register */
#define MSR_DCTS        0x01    /* Delta Clear-to-Send */
#define MSR_DDSR        0x02    /* Delta Data Set Ready */
#define MSR_TERI        0x04    /* Trailing edge ring indicator */
#define MSR_DRLSD       0x08    /* Delta Rx Line Signal Detect */
#define MSR_CTS         0x10    /* Clear to send */
#define MSR_DSR         0x20    /* Data set ready */
#define MSR_RI          0x40    /* Ring indicator */
#define MSR_RLSD        0x80    /* Rx line signal detect */

/* 16550A FIFO control register values */
#define FIFO_ENABLE     0x01    /* enable TX & RX fifo */
#define FIFO_CLR_RX     0x02    /* clear RX fifo */
#define FIFO_CLR_TX     0x04    /* clear TX fifo */
#define FIFO_START_DMA  0x08    /* enable TXRDY/RXRDY pin DMA handshake */
#define FIFO_SIZE_1     0x00    /* RX fifo trigger levels */
#define FIFO_SIZE_4     0x40
#define FIFO_SIZE_8     0x80
#define FIFO_SIZE_14    0xC0
#define FIFO_SIZE_MASK  0xC0

#define FIFO_TRIGGER_LEVEL      FIFO_SIZE_8
#define FIFO_SETUP      (FIFO_ENABLE|FIFO_CLR_RX|FIFO_CLR_TX|FIFO_TRIGGER_LEVEL)

#define OUTPUT_FIFO_SIZE        16


/**
 * Initialize asynch port where @info1 is base address such as 0x2F8
 * and @info2 is irq port such as 3 in DOS.
 *
 * You can get exact system independent values by functions
 *
 * l_int low_asy_get_init_info1 ( l_int dev );
 * l_int low_asy_get_init_info2 ( l_int dev );
 *
*/
extern l_int  (*low_asy_init)(l_int dev, l_int info1, l_int info2, l_ushort bufsize,
                    l_long speed, l_int cts, l_int rlsd, l_int chain);

extern l_int  (*low_asy_get_init_info1) ( l_int dev );
extern l_int  (*low_asy_get_init_info2) ( l_int dev );

extern void   (*low_asy_timer) ( l_int dev );
extern void   (*low_asy_rxschedule) ( l_int dev );
extern l_bool (*low_asy_name) ( l_text buf, l_int dev );
extern l_int  (*low_asy_int) ( l_text port );
extern l_int  (*low_asy_count_supported) ( void );
extern l_int  (*low_asy_stop) ( l_int dev );
extern l_int  (*low_asy_set_speed) ( l_int dev, l_long bps );
extern l_int  (*low_asy_set_ppp) ( l_int dev, l_int unit, l_int (*ppp_receiver)(l_int, cl_byte*, l_int) );
extern l_int  (*low_asy_get_ppp) ( l_int dev );
extern l_int  (*low_asy_read) ( l_int dev, l_byte *buf, l_ushort cnt );
extern l_int  (*low_asy_waitchar) ( l_int dev );
extern l_int  (*low_asy_rxcheck) ( l_int dev );
extern l_int  (*low_asy_write) ( l_int dev, l_byte *buf, l_ushort cnt );
extern l_int  (*low_asy_txcheck) ( l_int dev );
extern l_long (*low_asy_ioctl) ( l_int dev, l_int cmd, l_int set, l_long val );
extern l_int  (*low_asy_get_rlsd) ( l_int dev );
extern l_int  (*low_asy_wait_rlsd) ( l_int dev, l_int new_rlsd );
extern l_int  (*low_asy_fputc) ( l_int dev, l_byte chr );
extern l_int  (*low_asy_fgetc) ( l_int dev );
extern l_int  (*low_asy_ftxcheck) ( l_int dev );
extern l_int  (*low_asy_frxcheck) ( l_int dev );
extern l_int  (*low_asy_hangup) ( l_int dev, l_text* command, l_int *sleep );
extern l_int  (*low_asy_connect) ( l_int dev, l_text* command, l_int *sleep );
extern l_int  (*low_asy_command) ( l_int dev, l_text* command, l_int *sleep );
extern p_low_asy (*low_asy_get_asy_info) ( l_int dev );

extern void low_asy_lock ( void );


#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _depasy.h */

