/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPGRX.H                                     */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPGRX_H_INCLUDED__
#define ___DEPGRX_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"
#include"../drvbas.h"

#define  GRX_MODE_TEXT    -1
#define  GRX_MODE_AUTO     0

extern l_int    (*low_grx_set_mode) ( l_int mode, l_int depth, l_rect w, l_rect h );
extern void     (*low_grx_set_clip) ( p_bitmap bmp, l_rect x1, l_rect y1, l_rect x2, l_rect y2 );
extern l_int    (*low_grx_get_safe_mode_params) (  l_int *depth, l_rect *w, l_rect *h );

#define  BMP_COMPATIBLE   -1

extern p_bitmap (*low_grx_duplicate_bitmap) ( p_bitmap b );
extern p_bitmap (*low_grx_create_bitmap) ( l_int depth, l_rect w, l_rect h );
extern void     (*low_grx_destroy_bitmap) ( p_bitmap bmp );
extern l_color  (*low_grx_getpixel) ( p_bitmap bmp, l_rect x, l_rect y );
extern void     (*low_grx_putpixel) ( p_bitmap bmp, l_rect x, l_rect y, l_color color);
extern void     (*low_grx_vline) ( p_bitmap bmp, l_rect x, l_rect y1, l_rect y2, l_rect color );
extern void     (*low_grx_hline) ( p_bitmap bmp, l_rect x1, l_rect y, l_rect x2, l_color color);

extern void     (*low_grx_quickputpixel) ( p_bitmap bmp, l_rect x, l_rect y, l_color color );
extern l_color  (*low_grx_quickgetpixel) ( p_bitmap bmp, l_rect x, l_rect y );

extern void     (*low_grx_vline) ( p_bitmap bmp, l_rect x, l_rect y1, l_rect y2, l_rect color );
extern void     (*low_grx_hline) ( p_bitmap bmp, l_rect x1, l_rect y, l_rect x2, l_color color);
extern void     (*low_grx_vdotline) ( p_bitmap bmp, l_rect x, l_rect y1, l_rect y2, l_int npix, l_rect color );
extern void     (*low_grx_hdotline) ( p_bitmap bmp, l_rect x1, l_rect y, l_rect x2, l_int npix, l_color color);
extern void     (*low_grx_dotrect) ( p_bitmap bmp, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_int npix, l_color color);
extern void     (*low_grx_line) ( p_bitmap bmp, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_color color);
extern void     (*low_grx_rectfill) ( p_bitmap bmp, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_int color);
extern void     (*low_grx_draw_sprite) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y);
extern void     (*low_grx_draw_sprite_v_flip) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y);
extern void     (*low_grx_draw_sprite_h_flip) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y);
extern void     (*low_grx_draw_sprite_vh_flip) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y);
extern void     (*low_grx_draw_trans_sprite) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y);
extern void     (*low_grx_draw_lit_sprite) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y, l_color color);
extern void     (*low_grx_draw_character) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y, l_color color);
extern void     (*low_grx_clear_to_color) (p_bitmap bmp, l_color color );
extern void     (*low_grx_do_line) ( p_bitmap bmp, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_int d, void (*proc)(p_bitmap , l_rect, l_rect, l_color));
extern void     (*low_grx_triangle) ( p_bitmap bmp, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_rect x3, l_rect y3, l_color color);
extern void     (*low_grx_polygon) ( p_bitmap bmp, l_int vertices, l_rect *points, l_color color);
extern void     (*low_grx_rect) ( p_bitmap bmp, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_color color);
extern void     (*low_grx_do_circle) ( p_bitmap bmp, l_rect x, l_rect y, l_rect radius, l_int d, void (*proc)(p_bitmap , l_rect, l_rect, l_color));
extern void     (*low_grx_circle) ( p_bitmap bmp, l_rect x, l_rect y, l_rect radius, l_color color );
extern void     (*low_grx_circlefill) ( p_bitmap bmp, l_rect x, l_rect y, l_rect radius, l_color color );
extern void     (*low_grx_do_ellipse) ( p_bitmap bmp, l_rect x, l_rect y, l_rect rx, l_rect ry, l_int d, void (*proc)(p_bitmap, l_rect, l_rect, l_color) );
extern void     (*low_grx_ellipse) ( p_bitmap bmp, l_rect x, l_rect y, l_rect rx, l_rect ry, l_color color );
extern void     (*low_grx_ellipsefill) ( p_bitmap bmp, l_rect x, l_rect y, l_rect rx, l_rect ry, l_color color );
extern void     (*low_grx_do_arc) ( p_bitmap bmp, l_rect x, l_rect y, l_fixed ang1, l_fixed ang2, l_rect r, l_int d, void (*proc)(p_bitmap, l_rect, l_rect, l_color));
extern void     (*low_grx_arc) ( p_bitmap bmp, l_rect x, l_rect y, l_fixed ang1, l_fixed ang2, l_rect r, l_color color);
extern void     (*low_grx_calc_spline) ( l_rect points[8], l_int npts, l_rect *x, l_rect *y);
extern void     (*low_grx_spline) ( p_bitmap bmp, l_rect points[8], l_color color );
extern void     (*low_grx_floodfill) ( p_bitmap bmp, l_rect x, l_rect y, l_color color );
extern void     (*low_grx_blit) ( p_bitmap source, p_bitmap dest, l_rect source_x, l_rect source_y, l_rect dest_x, l_rect dest_y, l_rect width, l_rect height );
extern void     (*low_grx_masked_blit) ( p_bitmap source, p_bitmap dest, l_rect source_x, l_rect source_y, l_rect dest_x, l_rect dest_y, l_rect width, l_rect height );
extern void     (*low_grx_stretch_blit) ( p_bitmap s, p_bitmap d, l_rect s_x, l_rect s_y, l_rect s_w, l_rect s_h, l_rect d_x, l_rect d_y, l_rect d_w, l_rect d_h);
extern void     (*low_grx_stretch_sprite) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y, l_rect w, l_rect h );
extern void     (*low_grx_rotate_sprite) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y, l_fixed angle );
extern void     (*low_grx_rotate_scaled_sprite) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y, l_fixed angle, l_fixed scale );
extern void     (*low_grx_draw_gouraud_sprite) ( p_bitmap bmp, p_bitmap sprite, l_rect x, l_rect y, l_color c1, l_color c2, l_color c3, l_color c4 );
extern void     (*low_grx_clear) ( p_bitmap bmp );

#define  GRX_DRAW_MODE_SOLID             0
#define  GRX_DRAW_MODE_XOR               1
#define  GRX_DRAW_MODE_COPY_PATTERN      2
#define  GRX_DRAW_MODE_SOLID_PATTERN     3
#define  GRX_DRAW_MODE_MASKED_PATTERN    4
#define  GRX_DRAW_MODE_TRANS             5

extern void     (*low_grx_drawing_mode) ( l_int mode, p_bitmap pattern, l_rect x_anchor, l_rect y_anchor );

extern l_rect   (*low_grx_width) ( p_bitmap bmp );
extern l_rect   (*low_grx_height) ( p_bitmap bmp );
extern l_int    (*low_grx_get_clip) ( p_bitmap bmp, l_rect *x1, l_rect *y1, l_rect *x2, l_rect *y2 );
extern p_bitmap (*low_grx_get_screen) ( void );
extern l_int    (*low_grx_is_screen) ( p_bitmap bmp );
extern l_int    (*low_grx_get_color_depth) ( p_bitmap bmp );
extern l_color  (*low_grx_get_mask_color) ( p_bitmap bmp );
extern l_byte*  (*low_grx_get_linearptr) ( p_bitmap bmp );


/* 3D */

#define POLYTYPE_FLAT               0
#define POLYTYPE_GCOL               1
#define POLYTYPE_GRGB               2
#define POLYTYPE_ATEX               3
#define POLYTYPE_PTEX               4
#define POLYTYPE_ATEX_MASK          5
#define POLYTYPE_PTEX_MASK          6
#define POLYTYPE_ATEX_LIT           7
#define POLYTYPE_PTEX_LIT           8
#define POLYTYPE_ATEX_MASK_LIT      9
#define POLYTYPE_PTEX_MASK_LIT      10

extern void     (*low_grx3_polygon3d) ( p_bitmap bmp, l_int type, p_bitmap texture, l_int vc, p_v3d vtx[]);
extern void     (*low_grx3_polygon3df) ( p_bitmap bmp, l_int type, p_bitmap texture, l_int vc, p_v3df vtx[]);
extern void     (*low_grx3_triangle3d) ( p_bitmap bmp, l_int type, p_bitmap texture, p_v3d v1, p_v3d v2, p_v3d v3);
extern void     (*low_grx3_triangle3df) ( p_bitmap bmp, l_int type, p_bitmap texture, p_v3df v1, p_v3df v2, p_v3df v3);
extern void     (*low_grx3_quad3d) ( p_bitmap bmp, l_int type, p_bitmap texture, p_v3d v1, p_v3d v2, p_v3d v3, p_v3d v4);
extern void     (*low_grx3_quad3df) ( p_bitmap bmp, l_int type, p_bitmap texture, p_v3df v1, p_v3df v2, p_v3df v3, p_v3df v4);

extern l_int    (*low_grx_clip3df) ( l_int type, l_float min_z, l_float max_z, l_int vc, p_v3df vtx[], p_v3df vout[], p_v3df vtmp[], l_int out[]);


/* TEXT */

extern l_rect   (*low_grx_text_sizey) ( p_font f );
extern l_rect   (*low_grx_text_sizex) ( p_font f, l_text str, l_int len );
extern p_font   (*low_grx_text_change_size) ( p_font f, l_rect w, l_rect h );

/* Important to support CO_NOCOLOR as background color */
extern void     (*low_grx_text_draw) ( p_bitmap  bmp, p_font f, l_text s, l_int len, l_rect x, l_rect y, l_color fg, l_color bg );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _depgrx.h */

