/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPKEYB.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPKEYB_H_INCLUDED__
#define ___DEPKEYB_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"

#define KB_ESC               1     /* keyboard scan codes  */
#define KB_1                 2 
#define KB_2                 3 
#define KB_3                 4
#define KB_4                 5
#define KB_5                 6
#define KB_6                 7
#define KB_7                 8
#define KB_8                 9
#define KB_9                 10
#define KB_0                 11
#define KB_MINUS             12
#define KB_EQUALS            13
#define KB_BACKSPACE         14
#define KB_TAB               15 
#define KB_Q                 16
#define KB_W                 17
#define KB_E                 18
#define KB_R                 19
#define KB_T                 20
#define KB_Y                 21
#define KB_U                 22
#define KB_I                 23
#define KB_O                 24
#define KB_P                 25
#define KB_OPENBRACE         26
#define KB_CLOSEBRACE        27
#define KB_ENTER             28
#define KB_CONTROL           29
#define KB_LCONTROL          29
#define KB_A                 30
#define KB_S                 31
#define KB_D                 32
#define KB_F                 33
#define KB_G                 34
#define KB_H                 35
#define KB_J                 36
#define KB_K                 37
#define KB_L                 38
#define KB_COLON             39
#define KB_QUOTE             40
#define KB_TILDE             41
#define KB_LSHIFT            42
#define KB_BACKSLASH         43
#define KB_Z                 44
#define KB_X                 45
#define KB_C                 46
#define KB_V                 47
#define KB_B                 48
#define KB_N                 49
#define KB_M                 50
#define KB_COMMA             51
#define KB_STOP              52
#define KB_SLASH             53
#define KB_RSHIFT            54
#define KB_ASTERISK          55
#define KB_ALT               56
#define KB_SPACE             57
#define KB_CAPSLOCK          58
#define KB_F1                59
#define KB_F2                60
#define KB_F3                61
#define KB_F4                62
#define KB_F5                63
#define KB_F6                64
#define KB_F7                65
#define KB_F8                66
#define KB_F9                67
#define KB_F10               68
#define KB_NUMLOCK           69
#define KB_SCRLOCK           70
#define KB_HOME              71
#define KB_UP                72
#define KB_PGUP              73
#define KB_MINUS_PAD         74
#define KB_LEFT              75
#define KB_5_PAD             76
#define KB_RIGHT             77
#define KB_PLUS_PAD          78
#define KB_END               79
#define KB_DOWN              80
#define KB_PGDN              81
#define KB_INSERT            82
#define KB_DEL               83
#define KB_PRTSCR            84
#define KB_F11               87
#define KB_F12               88
#define KB_LWIN              91
#define KB_RWIN              92
#define KB_MENU              93
#define KB_PAD               100
#define KB_RCONTROL          120
#define KB_ALTGR             121
#define KB_SLASH2            122
#define KB_PAUSE             123

#define  KB_SHIFT_FLAG         0x0001
#define  KB_CTRL_FLAG          0x0002
#define  KB_ALT_FLAG           0x0004
#define  KB_LWIN_FLAG          0x0008
#define  KB_RWIN_FLAG          0x0010
#define  KB_MENU_FLAG          0x0020
#define  KB_SCROLOCK_FLAG      0x0100
#define  KB_NUMLOCK_FLAG       0x0200
#define  KB_CAPSLOCK_FLAG      0x0400
#define  KB_INALTSEQ_FLAG      0x0800
#define  KB_ACCENT1_FLAG       0x1000
#define  KB_ACCENT1_S_FLAG     0x2000
#define  KB_ACCENT2_FLAG       0x4000
#define  KB_ACCENT2_S_FLAG     0x8000

#define  SCAN_TO_KEY(c)      low_key_scantokey(c)
#define  SCAN_TO_CAPS(c)     low_key_scantocaps(c)
#define  SCAN_TO_SHIFT(c)    low_key_scantoshift(c)
#define  SCAN_TO_CONTROL(c)  low_key_scantoctrl(c)
#define  SCAN_TO_ALTGR(c)    low_key_scantoaltgr(c)
#define  SCAN_TO_ALT(c)      low_key_scantoalt(c)

#define  KEY_TO_SCAN(c)      low_key_scan(c)
#define  ALT_TO_SCAN(c)      low_key_alt(c)
#define  CTRL_TO_SCAN(c)     low_key_ctrl(c)
#define  ASCII_TO_SCAN(c)    low_key_ascii(c)

extern l_int    (*low_key_init) ( void );
extern l_int    (*low_key_done) ( void );
extern l_int    (*low_key_simulate_press) ( l_int kc );
extern l_int    (*low_key_readkey) ( void );
extern l_int    (*low_key_keypressed) ( void );
extern l_int    (*low_key_set_ctrlaltdel) ( l_bool enable );
extern l_int    (*low_key_is_ctrlaltdel) ( void );
extern l_int    (*low_key_clear_buffer) ( void );

extern l_int    (*low_key_shift) ( void );
extern l_int    (*low_key_alt) ( l_int key );
extern l_int    (*low_key_ctrl) ( l_int key );
extern l_int    (*low_key_scan) ( l_int key );
extern l_int    (*low_key_ascii) ( l_int key );

extern l_int    (*low_key_scantokey) ( l_int scan );
extern l_int    (*low_key_scantocaps) ( l_int scan );
extern l_int    (*low_key_scantoshift) ( l_int scan );
extern l_int    (*low_key_scantoctrl) ( l_int scan );
extern l_int    (*low_key_scantoaltctrl) ( l_int scan );
extern l_int    (*low_key_scantoalt) ( l_int scan );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _depkeyb.h */

