/*****************************************************************/
/*                                                               */
/*                                                               */
/*  File     :     _DEPMOUS.H                                    */
/*                                                               */
/*  Producer :     Interactive Studio                            */
/*                                                               */
/*        Programmers :  Michal Stencl                           */
/*                                                               */
/*                                                               */
/*  Copyright (c) 2000, Interactive Studio                       */
/*  All Rights Reserved                                          */
/*                                                               */
/*  Contacts :                                                   */
/*                                                               */
/*        Address :  Kozia 29, Bratislava 81103, Slovak Republic */
/*        E-mail  :  developer@InteractiveStudio.sk              */
/*        WEB     :  http://www.InteractiveStudio.sk/            */
/*                                                               */
/*                                                               */
/*  This file is part of MatrixOS                                */
/*                                                               */
/*****************************************************************/

/*
  First release : 06.09.2000 by Michal Stencl
*/

#ifndef ___DEPMOUS_H_INCLUDED__
#define ___DEPMOUS_H_INCLUDED__

#ifdef __cplusplus
extern "C" { /* begin poor C code */
#endif

#include"../basics.h"
#include"../drvbas.h"

/* mouse modes */
/* show rectangle together with mouse cursor */
#define MO_MO_RECT      0x01
/* show growing rectangle together with mouse cursor */
#define MO_MO_GROW      0x02
/* draws by own function */
#define MO_MO_OWN       0x03


/* mouse flags */
#define MO_SF_MOUSENOTHING      0x0000000
/* cursor was changed the position in (x) or (y) */
#define MO_SF_MOUSEMOVE         0x0000020
/* left mouse button was pressed */
#define MO_SF_MOUSELDOWN        0x0000040
/* left mouse button was released */
#define MO_SF_MOUSELUP          0x0000080
/* right mouse button was pressed */
#define MO_SF_MOUSERDOWN        0x0000100
/* right mouse button was released */
#define MO_SF_MOUSERUP          0x0000200
/* middle mouse button was pressed */
#define MO_SF_MOUSEMDOWN        0x0000400
/* middle mouse button was released */
#define MO_SF_MOUSEMUP          0x0000800

extern l_int    (*low_mouse_init) ( void );
extern l_int    (*low_mouse_done) ( void );
extern l_int    (*low_mouse_get_range) ( l_rect *x1, l_rect *y1, l_rect *x2, l_rect *y2 );
extern l_int    (*low_mouse_set_range) ( l_rect x1, l_rect y1, l_rect x2, l_rect y2 );
extern p_cursor (*low_mouse_get_cursor) ( void );
extern l_int    (*low_mouse_set_cursor) ( p_cursor cursor );
extern l_int    (*low_mouse_is_visible) ( void );
extern l_int    (*low_mouse_get_focus) ( l_rect *fx, l_rect *fy );
extern l_int    (*low_mouse_set_focus) ( l_rect fx, l_rect fy );
extern l_int    (*low_mouse_show) ( void );
extern l_int    (*low_mouse_hide) ( void );
extern l_int    (*low_mouse_set_mode) ( l_int mode, l_color col, l_rect x1, l_rect y1, l_rect x2, l_rect y2 );
extern l_int    (*low_mouse_set_mode_ex) ( void (*mode_draw_func)(p_bitmap bmp, l_ptr ptr, l_rect x1, l_rect y1, l_rect x2, l_rect y2, l_color color ), l_ptr ptr, l_color col, l_rect x1, l_rect y1, l_rect x2, l_rect y2 );
extern l_int    (*low_mouse_set_speed) ( l_int sx, l_int sy );
extern l_int    (*low_mouse_set_pos) ( l_rect posx, l_rect posy );
extern l_int    (*low_mouse_block) ( l_rect x1, l_rect y1, l_rect x2, l_rect y2 );
extern l_int    (*low_mouse_unblock) ( l_int bc );
extern l_int    (*low_mouse_is_block) ( void );
extern l_int    (*low_mouse_get_pos) ( l_rect *x, l_rect *y );
extern l_long   (*low_mouse_get_flags) ( void );

#ifdef __cplusplus
} /* end of poor C code */
#endif

#endif /* end of _depmous.h */

