Unit FileStr;

interface

procedure FileCopy(FromFileName,ToFileName:String);
function FileExists(Filename:String):Boolean;
function IntToStr(Value:Integer):String;
function StrToInt(Value:String):Integer;
function ChangeFileExt(const FileName, Extension: string): string;
function ExtractFilePath(const FileName: string): string;
function ExtractFileName(const FileName: string): string;
function ExtractFileExt(const FileName: string): string;

implementation

procedure FileCopy(FromFileName,ToFileName:String);
Var
  FromFile,ToFile:file;
  NumRead,NumWritten:word;
  Buf:Pointer;
{  Buf:array[1..2048] of char;}
begin
  Getmem(buf,65535);
  Assign(FromFile,FromFilename);
  Reset(FromFile,1);
  Assign(ToFile,ToFileName);
  Rewrite(ToFile,1);
  Repeat
    BlockRead(FromFile,Buf^,65535,NumRead);
    BlockWrite(ToFile,Buf^,NumRead,NumWritten);
  Until (NumRead=0) or (NumWritten<>NumRead);
  Close(FromFile);
  Close(ToFile);
  Freemem(buf,65535);
end;

function FileExists(Filename:String):Boolean;
var
  f:file of byte;
begin
  {$I-}
  Assign(F,Filename);
  Reset(F);
  If IOResult > 0 then
    FileExists:=false
  else
  begin
    FileExists:=true;
    Close(F);
  end;
  {$I+}
end;

function IntToStr(Value:Integer):String;
var
  TempStr:String;
begin
  Str(Value,TempStr);
  IntToStr:=TempStr;
end;

function StrToInt(Value:String):Integer;
var
  TempInt,Code:Integer;
begin
  Val(Value,TempInt,Code);
  StrToInt:=TempInt;
end;


function ChangeFileExt(const FileName, Extension: string): string;
var
  I: Integer;
begin
  I := Length(FileName);
  while (I > 0) and not (FileName[I] in ['.', '\', ':']) do Dec(I);
  if (I = 0) or (FileName[I] <> '.') then I := 256;
  ChangeFileExt := Copy(FileName, 1, I - 1) + Extension;
end;

function ExtractFilePath(const FileName: string): string;
var
  I: Integer;
begin
  I := Length(FileName);
  while (I > 0) and not (FileName[I] in ['\', ':']) do Dec(I);
  ExtractFilePath := Copy(FileName, 1, I);
end;

function ExtractFileName(const FileName: string): string;
var
  I: Integer;
begin
  I := Length(FileName);
  while (I > 0) and not (FileName[I] in ['\', ':']) do Dec(I);
  ExtractFileName := Copy(FileName, I + 1, 255);
end;

function ExtractFileExt(const FileName: string): string;
var
  I: Integer;
begin
  I := Length(FileName);
  while (I > 0) and not (FileName[I] in ['.', '\', ':']) do Dec(I);
  if (I > 0) and (FileName[I] = '.') then
    ExtractFileExt := Copy(FileName, I, 255) else
    ExtractFileExt := '';
end;

end.