/****************************************************************************
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskapp.c 4.24 92/04/10 16:07:15 sbc Exp Locker: sbc $
* $Log:	deskapp.c $
 * Revision 4.24  92/04/10  16:07:15  sbc
 * Rm unused members in WSAVE. Replace others with refs to equivs in WNODE
 * 
 * Revision 4.23  92/04/10  13:39:24  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 4.22  92/04/09  14:54:24  sbc
 * Merge Becky's memory management improvements re backgrounds
 * 
 * Revision 4.21  92/04/06  09:46:05  Fontes
 * Initial cut to extract/display Windows exe embedded icons.
 * 
 * Revision 4.20  92/04/03  17:14:44  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.19  92/03/26  14:45:15  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.17  92/03/20  20:18:55  Fontes
 * Do all bmp file processing in VM
 * 
 * Revision 4.16  92/03/20  15:46:32  Fontes
 * Merged from Susan, March 18
 * 
 * Revision 4.18  92/03/13  14:40:24  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * 
 * 911031  K.H		Center the icon strings.
 * (920313 sbc: not sure where to put the following now, or if it's necessary)
 * 	  G.g_idlist[i].ib_xicon = G.g_iblist[i].ib_xicon = 
 *			(G.g_idlist[i].ib_wtext - G.g_idlist[i].ib_wicon) / 2;
 *
 * Revision 4.17  92/03/12  13:55:07  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.16  92/03/05  09:30:13  sbc
 * Hook up use of New Program Item dialog and INODE structure.
 * 
 * Revision 4.15  92/02/28  14:06:19  sbc
 * Allow user to change folder icons as well as file icons.
 * 
 * Revision 4.15  92/03/04  14:16:40  Fontes
 * No xgrf_dtimage() call if background is NONE
 * 
 * Revision 4.14  92/02/27  15:31:44  rsf
 * Communication and display of chosen background image
 * 
 * Revision 4.13  92/02/27  10:32:44  sbc
 * Allow assignment of icon to ordinary FNODE.
 * 
 * Revision 4.12  92/02/25  14:37:32  sbc
 * Replace [Programs] section in INI file with [FileIcons]. Create ANODEs
 * for each such assignment specified.
 * 
 * Revision 4.11  92/02/25  09:34:53  sbc
 * Add New Icon Dialog and allow assignment of icons (only) to FNODEs/ANODEs.
 * 
 * Revision 4.10  92/02/20  15:55:52  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.9  92/02/19  16:12:02  sbc
 * move get_defdrv() and app_blddsk() to deskinit.c
 * remove NO_CLRICN_IMPL defines (assume always TRUE).
 * extern => extern, void => void, FAR => far
 * 
 * Revision 4.8  92/02/14  11:02:19  sbc
 * merged Tom Rolander's changes for Mobile Netware version of ViewMAX
 * 
 * Revision 4.7  92/02/12  15:44:31  sbc
 * rename gl_num_icons to gl_num_icos
 * Init G.g_iconlist[] so that the first NUM_REQ_ICONS are the
 * required icons, with NUM_REQ_ICONS + 1 being the app icons (GENERIC is
 * first). Put all of the data icons (ICFs) at the end of g_iconlist[] and
 * grow down so that the app icons can be contiguous. This makes the
 * display of the icon list box in Configure app much easier.
 * 
 * Revision 4.6  92/02/06  12:10:56  sbc
 * rename WNODE member w_split to w_type
 * 
 * Revision 4.5  92/01/31  16:42:32  sbc
 * save and restore FCB around call to dos_sfirst().
 * 
 * Revision 4.4  92/01/30  14:46:12  sbc
 * have error message correct if an ICO file is missing.
 * 
 * Revision 4.3  92/01/28  15:00:35  rsf
 * *** empty log message ***
 * 
 * Revision 4.3  92/01/21  13:36:06  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.2  92/01/06  12:52:39  anderson
 * Color icon work from Becky.
 * 
 * Revision 4.1  91/11/07  16:26:44  anderson
 * Save and restore window sizes to .INI file (heading WindowX, subheading Size)
 * in thousandths of the screen width and height, rather than in multiples of
 * character width and height.  This allows almost precise duplication of the
 * window sizes saved, even if the screen driver is changed!
 * 
 * Revision 3.1  91/08/19  16:37:18  system
 * ViewMAX 2 sources
 * 
**************************************************************************/

#include <fcntl.h>
#include <dir.h>
/*#include <dos.h> */

#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
#include "deskmnvm.h"														/* USE_MOBILE_NETWARE  tar  02/13/92 */
#endif /* USE_MOBILE_NETWARE */																		/* USE_MOBILE_NETWARE  tar  02/13/92 */

#include "shell.h"
#include "inidefs.h"

#define MIN_WINT 4
#define MIN_HINT 2

extern char	start_path[ 65 ];	/* Path we ran from  */
extern BYTE	gl_lngstr[];
extern WORD	gl_wchar;
extern WORD	gl_hchar;
extern WORD	gl_wschar;
extern WORD	gl_hschar;
extern WORD	gl_width;
extern WORD	gl_height;
extern WORD	gl_hbox;
extern WORD	DOS_ERR;
extern UWORD	global[];

extern GRECT	gl_savewin[NUM_WNODES];
extern WORD	gl_savetx[NUM_WNODES];

extern ICONBLK	far	*gl_icons;

extern PREFS	prefs;
extern GLOBES	G;

GLOBAL WORD	gl_pstart;

GLOBAL WORD gl_num_icos;			/* number of application ICOs */
GLOBAL WORD gl_num_icfs;			/* number of ICFs */

extern WORD	gl_stdrv;

MLOCAL BYTE	gl_buffer[SIZE_BUFF];
MLOCAL char 	crlf[] = "\r\n" ;

extern WORD	cs_currentcolor ;
extern WORD	cs_maxcolors ; 

MLOCAL INODE	g_ilist[ NUM_INODES ];
INODE		*g_iavail ;
INODE		*g_ihead ;

/****************************************************************/
char * string_alloc( char far * string )
{
WORD	len ;
char *	ptr ;

    len = fstrlen( string ) ;
    if ( SIZE_BUFF - (G.g_pbuff - gl_buffer) < len + 1 )
	return( (char *)NULL ) ;

    ptr = G.g_pbuff ;
    fstrcpy( (char far *)ptr, string ) ;
    G.g_pbuff += 1 + strlen( ptr ) ;
    
    return ptr ;
    
} /* string_alloc() */

/****************************************************************
 * Convert a window X, Y, width or height to a number of 
 * thousandths of the screen width or height (given by w_h),
 * rounded UP to the nearest 1/1000 of percent.  The number will
 * be stored in the .INI file in this form.
 ****************************************************************/
MLOCAL WORD	ToPercent(WORD vector, WORD w_h)
{
    LONG	m;
    WORD	d;
    
    m = (LONG) vector * 1000;
    d = (WORD) (m / w_h);
    if ((m % w_h) > (w_h / 2))		/* round up */
	d++;

    return(d);
    
} /* end ToPercent() */

/****************************************************************
 * Convert a number of thousandths of the screen width or height
 * (given by w_h), to a window X, Y, width or height, rounded UP
 * to the nearest whole number.
 ****************************************************************/
MLOCAL WORD	FromPercent(WORD percent, WORD w_h)
{
    LONG	m;
    WORD	d;
    
    m = (LONG) percent * w_h;
    d = (WORD) (m / 1000);
    if ((m % 1000) > 500)		/* round up */
	d++;
    
    return(d);
    
} /* end FromPercent() */

/*----------------------------------------------------------------------------
*	Allocate an application object.
*/
ANODE * app_alloc( BOOLEAN tohead )
{
ANODE		*pa ;
ANODE		*tmp ;

    if ( G.g_aavail == (ANODE *)NULL )		/* no more available */
	return( (ANODE *)NULL ) ;

    pa = G.g_aavail;				/* take next avail ANODE */
    G.g_aavail = G.g_aavail->a_next;		/* advance to next avail */
    
    if ( tohead || !G.g_ahead )			/* append to head of list */
    {
	pa->a_next = G.g_ahead;			/* attach to list */
	G.g_ahead = pa;				/* fix up ptr to head */
    }	
    else					/* append to end of list */
    {
	tmp = G.g_ahead;
	while( tmp->a_next != (ANODE *)NULL )	/* find last ANODE in list */
	    tmp = tmp->a_next;
	tmp->a_next = pa;			/* attach to list */
	pa->a_next = (ANODE *)NULL;		/* fixup ptr to next */
    }

    return( pa );
    
} /* app_alloc() */

/*----------------------------------------------------------------------------
*	Free an application object.
*/
void app_free( ANODE * pa )
{
ANODE		*tmp;

    if (G.g_ahead == pa)			/* if removing head, */
	G.g_ahead = pa->a_next;			/* fix up head ptr */
    else
    {
	tmp = G.g_ahead;			/* find preceding ANODE */
	while ( tmp != (ANODE *)NULL && tmp->a_next != pa )
	    tmp = tmp->a_next;
	if ( tmp != (ANODE *)NULL )	
	    tmp->a_next = pa->a_next;		/* re-route .a_next around pa */
    }
    
    pa->a_next = G.g_aavail;			/* attach freed anode to top */
    G.g_aavail = pa;				/* of avail list */
    
} /* app_free() */

/*----------------------------------------------------------------------------
*	Allocate a program item object.
*/
INODE * inode_alloc( BOOLEAN tohead )
{
INODE		*pi ;
INODE		*tmp ;

    if ( g_iavail == (INODE *)NULL )		/* no more available */
	return( (INODE *)NULL ) ;

    pi = g_iavail;				/* take next avail INODE */
    g_iavail = g_iavail->i_next;		/* advance to next avail */
    
    if ( tohead || !g_ihead )			/* append to head of list */
    {
	pi->i_next = g_ihead;			/* attach to list */
	g_ihead = pi;				/* fix up ptr to head */
    }	
    else					/* append to end of list */
    {
	tmp = g_ihead;
	while( tmp->i_next != (INODE *)NULL )	/* find last INODE in list */
	    tmp = tmp->i_next;
	tmp->i_next = pi;			/* attach to list */
	pi->i_next = (INODE *)NULL;		/* fixup ptr to next */
    }

    return( pi );
    
} /* inode_alloc() */

/*----------------------------------------------------------------------------
*	Free a program item object.
*/
void inode_free( INODE * pi )
{
INODE		*tmp;

    if (g_ihead == pi)				/* if removing head, */
	g_ihead = pi->i_next;			/* fix up head ptr */
    else
    {
	tmp = g_ihead;			/* find preceding INODE */
	while ( tmp != (INODE *)NULL && tmp->i_next != pi )
	    tmp = tmp->i_next;
	if ( tmp != (INODE *)NULL )	
	    tmp->i_next = pi->i_next;		/* re-route .i_next around pi */
    }
    
    pi->i_next = g_iavail;			/* attach freed INODE to top */
    g_iavail = pi;				/* of avail list */
    
} /* inode_free() */

/*----------------------------------------------------------------------------
*	Init app list with defaults.
(M:GENERIC ) ~ *.*
(D:FOLDER ) ~ *.*
*/
MLOCAL void initAppList( void )
{
WORD	ii ;
ANODE *	pa ;

/* init links in app list */
    for( ii = 0; ii < NUM_ANODES - 1; ii++ )
	G.g_alist[ii].a_next = &G.g_alist[ii + 1];
    G.g_alist[ NUM_ANODES-1 ].a_next = (ANODE *) NULL;

/* init links in program item list */
    for( ii = 0; ii < NUM_INODES - 1; ii++ )
	g_ilist[ii].i_next = &g_ilist[ii + 1];
    g_ilist[ NUM_INODES-1 ].i_next = (INODE *) NULL;

/* init head ptr and avail ptr */    
    G.g_ahead = (ANODE *) NULL;		
    G.g_aavail = G.g_alist;
    g_ihead = (INODE *) NULL;		
    g_iavail = g_ilist;

/* init default types */
    pa = app_alloc( TRUE ) ;			/* generic doc file */
    pa->a_flags = AF_ISDEF ;
    pa->a_type  = AT_ISFILE ;
    pa->a_match = "*.*" ;
    pa->a_icon = ID_GENERIC ;
    
    pa = app_alloc( TRUE ) ;			/* generic folder */
    pa->a_flags = AF_ISDEF ;
    pa->a_type  = AT_ISFOLD ;
    pa->a_match = "*.*" ;
    pa->a_icon = IG_FOLDER ;
    
    pa = app_alloc( TRUE ) ;			/* generic exe files */
    pa->a_flags = AF_ISPARM | AF_ISDEF ;
    pa->a_type  = AT_ISFILE ;
    pa->a_match = "*.EXE,*.BAT,*.COM" ;
    pa->a_icon = IA_GENERIC ;
    
} /* initAppList() */

/*----------------------------------------------------------------------------
*	Scan off spaces until a string is encountered.  An @ denotes
*	a null string.  Copy the string into a string buffer until
*	a @ is encountered.  This denotes the end of the string.  Advance
*	pcurr past the last byte of the string.
*/

BYTE * scan_str( BYTE * pcurr, BYTE ** ppstr)
{
short	flds_scanned ;

    *ppstr = G.g_pbuff;
    flds_scanned = sscanf( pcurr, "%s", *ppstr ) ;
    if ( flds_scanned < 1 )
	**ppstr = '\0' ;
    else
    {
		pcurr = strstr( pcurr, *ppstr ) ;
		pcurr += strlen( *ppstr ) ;
    }
    G.g_pbuff += 1 + strlen( G.g_pbuff ) ;
    
    return( pcurr ) ;
}
#if SBC_920225
/*----------------------------------------------------------------------------
*	Parse a single line from the DESKTOP.INF file.
*/
MLOCAL void app_parse( BYTE * pcurr )
{
ANODE *	pa ;
BYTE	icon_name[ MAXFILE ] ;
WORD	ii;
	
    pcurr = strpbrk( pcurr, "GpPmMD" ) ;	/* advance to app kind	*/
    if ( pcurr == NULL ) 
	return ;
    
    if ( *pcurr == 'G' ||		/* don't support old GEM apps	*/
	 *pcurr == 'D' )		/* or directories in this way	*/
        return ;
    
    pa = app_alloc( TRUE ) ;
    pa->a_type = AT_ISFILE ;
    pa->a_aicon = IA_GENERIC;
    pa->a_dicon = ID_GENERIC;
    switch( *pcurr )
    {
	case 'M':
	case 'm':			/* full memory, no params	*/
	    pa->a_flags = NONE ;
	    break;
	case 'P':
        case 'p':			/* full memory, takes params	*/
	    pa->a_flags = AF_ISPARM ;
	    break;
    }
	
    pcurr = 1+strchr( pcurr, ':' ) ;	/* go one past first colon */

    sscanf( pcurr, "%s", icon_name ) ;

    for (ii=0; ii < IA_GENERIC+gl_num_icos; ii++)
    {
	if ( strcmp(G.g_iconlist[ii].fname, icon_name) == 0) 
	{
	    pa->a_aicon = ii;
	    pa->a_dicon = G.g_iconlist[ii].file_icon;
	}
    } 

    pcurr = 1+strchr( pcurr, ')' ) ;	/* go one past close paren */

    pcurr = scan_str( pcurr, &pa->a_pappl ) ;
    pcurr = scan_str( pcurr, &pa->a_pdata ) ;
    if ( pa->a_pappl[0] == '~' ) pa->a_pappl[0] = '\0' ;
    if ( pa->a_pdata[0] == '~' ) pa->a_pdata[0] = '\0' ;
    
} /* app_parse() */
#endif /* SBC_920225 */

/*----------------------------------------------------------------------------
*	Each item in the [FileIcons] section in ViewMAX.INI looks like
*	0:FILENAME.EXT=ICONNAME.ICX
*/
MLOCAL void ficon_parse( BYTE * ptrFname )
{
ANODE *	pa ;
WORD	ii, start, end;
BYTE *	ptrIname ;
BYTE *	ptrExt ;
WORD	type ;
	
    type = ptrFname[0] - '0' ;
    ptrFname += 2 ;		/* advance past type */
    
    ptrIname = strchr( ptrFname, '=' ) ;
    *ptrIname = '\0' ;
    ++ptrIname ;
    ptrExt = strchr( ptrIname, '.' ) ;
    *ptrExt = '\0' ;
    
    if ( strcmp( ptrExt+1, "ICO" ) == 0 ) 	/* is ICO */
    {
	start = IA_GENERIC ;
	end = IA_GENERIC + gl_num_icos ;
    }
    else if (strcmp( ptrExt+1, "EXE" ) == 0 && type == AT_ISWIND )
    {						/* is Windows EXE */
        ii = IA_GENERIC + gl_num_icos;
	*ptrExt = '.';
	/* Note that a path is expected and required in this case. */
	if ( load_ico_from_exe(ptrIname, &G.g_iconlist[ii]) )
	{
	    *ptrExt = '\0';
					    /* dump path portion */
	    ptrIname = strrchr(ptrIname, '\\')+1;
	    strcpy( G.g_iconlist[ii].fname, ptrIname );
	    G.g_iconlist[ii].is_app = TRUE;
	    gl_num_icos++;
	    start = ii;
	    end = ii+1;
	}
    }
    else 					/* is ICF */
    {
	start = NUM_IBLKS - gl_num_icfs ;
	end = NUM_IBLKS ;
    }
    
    for (ii=start; ii < end; ii++)
    {
	if ( strcmp(G.g_iconlist[ii].fname, ptrIname ) == 0) 
	{
	    pa = app_alloc( TRUE ) ;
	    pa->a_type = type ;
	    pa->a_flags = NONE ;
	    pa->a_icon = ii;
	    pa->a_match = string_alloc( (char far *)ptrFname ) ;
	    break;
	}
    } 

} /* ficon_parse() */

/*--------------------------------------------------------------------------*/
	void
app_tran(bi_num)
	WORD		bi_num;
{
	TREE		lpbi;
	BITBLK		lb;

	rsrc_gaddr( R_BITBLK, bi_num, &lpbi );

	fmemcpy( (void far *)&lb, (void far *)lpbi, sizeof(BITBLK));
	gsx_trans(lb.bi_pdata, lb.bi_wb, lb.bi_pdata, lb.bi_wb, lb.bi_hl);
}

/*----------------------------------------------------------------------*/
/* the weird flag for VIEWHELP.RSC is because I didn't put that string	*/
/* in VIEWMAX.RSC.							*/
WORD app_getfh( WORD openit, WORD string_num, WORD attr)
{
WORD	handle	=	0 ;
BOOLEAN	found	=	FALSE ;

    if ( string_num == -1 )
	strcpy( gl_lngstr, "VIEWHELP.RSC" ) ;
    else
	ini_str( string_num ) ;
    
    if ( openit & TMP_FILE )
	strcpy( strrchr( gl_lngstr, '.' ), ".$$$" ) ;

    /* look for DRDOSCFG env variable */
    if ( string_num == INIFNVM || string_num == INIFNTM ) {
	strcpy( G.g_srcpth, gl_lngstr ) ;
	found = shel_find_ini( (char far *)G.g_srcpth ) ;
    }
    else {
	sprintf( G.g_srcpth, "%s%s", start_path, gl_lngstr ) ;
	found = shel_find( (long)(char far *)G.g_srcpth ) ;
    }
    if ( found ) {
	if ( openit & DELETE_FILE )
	    handle = dos_delete( (long)(char far *)G.g_srcpth );
	else
	    handle = dos_open( (long)(char far *)G.g_srcpth, attr );
    } 
    else if ( openit & CREATE_FILE ) {
	    handle = dos_create( (long)(char far *)G.g_srcpth, 0 );
	    found = handle ;
    }
    
    return( ( DOS_ERR || !found ) ? 0 : handle );
    
} /* app_getfh() */

/*----------------------------------------------------------------------*/
/* loop for floppy case- user needs to insert disk			*/
WORD app_getfh_loop( WORD openit, WORD string_num, WORD attr, WORD err_id )
{    
WORD	handle = 0 ;

    while (!handle) {

	handle = app_getfh( openit, string_num, attr ) ;
	if ( !handle ) {
	    if ( 2 == in_mem_alert_s( 0x0201, ERNOINF, ini_str( err_id ) ) )
		return 0 ;
	    }
    }
    return handle ;
    
} /* app_getfh_loop() */

#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
#define NUM_REQ_ICONS	10													/* USE_MOBILE_NETWARE  tar  02/13/92 */
#else /* USE_MOBILE_NETWARE */ 																		/* USE_MOBILE_NETWARE  tar  02/13/92 */
#define NUM_REQ_ICONS	6
#endif /* USE_MOBILE_NETWARE */
typedef struct tag_required_icons 
{
    char	i_name[ LEN_ZFNAME ] ;
    WORD	index ;
} REQ_ICON ;
MLOCAL REQ_ICON req_icons[ NUM_REQ_ICONS ] = {
    { "FLOPPY.ICO",  IG_FLOPPY  },    { "HARDDRV.ICO", IG_HARD },
    { "FOLDER.ICO",  IG_FOLDER  },    { "NET.ICO",     IG_NET  },
    { "GENERIC.ICO", IA_GENERIC },    { "GENERIC.ICF", ID_GENERIC }
#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
   ,{ "MNCNCT.ICO",  IG_MOBILE1	}											/* USE_MOBILE_NETWARE  tar  02/13/92 */
   ,{ "MNDCNCT.ICO", IG_MOBILE2	}											/* USE_MOBILE_NETWARE  tar  02/13/92 */
   ,{ "FOLDERMC.ICO",IG_MOBILE3	}											/* USE_MOBILE_NETWARE  tar  02/13/92 */
   ,{ "FOLDERMD.ICO",IG_MOBILE4	}											/* USE_MOBILE_NETWARE  tar  02/13/92 */
#endif /* USE_MOBILE_NETWARE */																		/* USE_MOBILE_NETWARE  tar  02/13/92 */
} ;
/************************************************************************
* r e q _ i n d e x  							
*
*	This routine returns the index number associated with the
*	icon if this icon is a required one. Otherwise, returns -1.
*	If found, set index to -1 as a flag. Then any remaining indexes
*	will be unfound ico files.
*************************************************************************/
MLOCAL WORD req_index( char * i_name )
{
WORD	ii ;
WORD	ret ;
    
    for ( ii = 0; ii < NUM_REQ_ICONS; ii++ ) {
	if ( strcmp( req_icons[ii].i_name, i_name ) == 0 ) {
	    ret = req_icons[ii].index ;
	    req_icons[ii].index = -1 ;
	    return( ret ) ;
	}
    }
    
    return -1 ;	
	
} /* req_index() */

/************************************************************************
* a p p _ r d i c o n							
*
*	This routine finds and opens *.ICO, reading the appropriate
*	resolution icon therefrom.  If an ICO file does not contain
*	an icon of appropriate resolution for the current screen, its
*	icon will not be used.
*************************************************************************/
MLOCAL	WORD app_rdicon( void )
{
FCB	fcb;				/* structure used by dos_sfirst */
FCB far *pOldFCB;			/* be sure to restore orig FCB	*/
WORD	fh;				/* Handle for .ICO file		*/
WORD	icon_index;			/* index into g_iconlist[]	*/
WORD	f_icon;				/* index for file icon		*/
BOOLEAN	try_icf;			/* Whether to look for .ICF file*/
WORD	ii ;
WORD	ICO_cnt	= 0 ;			/* # of app ICOs found so far	*/
WORD	ICF_cnt	= 0 ;			/* # of file ICFs found so far	*/

	pOldFCB = dos_gdta() ;
	dos_sdta( (FCB far *)&fcb );
	dos_sdrv( gl_stdrv );
	dos_chdir( (ULONG)(char far *)start_path );
	
	if ( !dos_sfirst( (char far *)"*.ICO", 0 ) ) {
	    strcpy( G.g_srcpth, req_icons[0].i_name ) ; /* for error message */
	    dos_sdta( pOldFCB );
	    return NO_ICON_FILE ;
	    }
	
	while (!DOS_ERR && NUM_IBLKS > (NUM_REQ_ICONS + ICO_cnt + ICF_cnt ) )
	{
		try_icf = FALSE;
		fh = dos_open( (long)(char far *)fcb.fcb_name, READONLY );
		if (DOS_ERR)
			continue;

		icon_index = req_index( fcb.fcb_name ) ;
		switch ( icon_index ) {
		    
		    case -1 :	/* Assume generic doc type in case none. */
				++ICO_cnt ;
				G.g_iconlist[ICO_cnt+IA_GENERIC].file_icon 
								= ID_GENERIC;
				
		    case IA_GENERIC:	
				try_icf = TRUE ;
				break ;
				
		    default :	G.g_iconlist[icon_index].file_icon = icon_index;
				break ;
		}
		if (icon_index == -1) 
		    icon_index = IA_GENERIC + ICO_cnt ;
		/* Load in the "known" or application icon */
		if ( !load_ico_file( fh, &G.g_iconlist[icon_index]))
		{
			/* Reset index, load failed somehow.
			 */
			icon_index--;
			dos_snext();
			continue;
		}
		memcpy( G.g_iconlist[icon_index].fname, fcb.fcb_name, 9 ) ;
		*strchr( G.g_iconlist[icon_index].fname, '.' ) = '\0' ;

		G.g_iconlist[icon_index].is_app = TRUE;
		dos_close(fh);

		/* See if we can find a document type icon corresponding to
		*  this app icon.
		*/
		if (try_icf)
		{
		        f_icon = (icon_index == IA_GENERIC) ? 
					ID_GENERIC : ID_GENERIC-ICF_cnt-1 ;
			sprintf( G.g_srcpth, "%s%s",
				 G.g_iconlist[icon_index].fname, ".ICF") ;
			fh = dos_open( (ULONG)(char far *)G.g_srcpth, READONLY);
			if (!DOS_ERR)
			{
				if (load_ico_file(fh, &G.g_iconlist[f_icon]))
				{
					strcpy(G.g_iconlist[f_icon].fname,
					    G.g_iconlist[icon_index].fname);
					G.g_iconlist[icon_index].file_icon =
					    f_icon;
				        G.g_iconlist[f_icon].is_app =FALSE;
					if (f_icon == ID_GENERIC) 
					    req_index( G.g_srcpth ) ;
					else
					    ++ICF_cnt ;

				}
				dos_close(fh);
			}
		}
		dos_snext();
	}
	
	for ( ii = 0; ii < NUM_REQ_ICONS; ii++ ) {
	    if ( req_icons[ii].index != -1 ) {
		strcpy( G.g_srcpth, req_icons[ii].i_name ) ;
		dos_sdta( pOldFCB );
		return NO_ICON_FILE ;
	    }
	}

	gl_num_icos = ICO_cnt + 1 ;	/* add 1 for GENERIC.ICO */
	gl_num_icfs = ICF_cnt + 1 ;	/* add 1 for GENERIC.ICF */
	
	dos_sdta( pOldFCB );
	return TRUE;
} /* app_rdicon */

/*----------------------------------------------------------------------------
    Set up disk drive ANODE.
*/
MLOCAL void makeDiskAnode( WORD drive_type, BYTE drive_id )
{
ANODE *	pa ;
char	tmp[2] ;

    pa = app_alloc( TRUE );
    pa->a_type = AT_ISDISK;
    pa->a_flags = AF_ISDESK;

    sprintf( tmp, "%c", drive_id ) ;
    pa->a_match = string_alloc( (char far *)tmp ) ;

    switch( drive_type ) {
	case 0 :
	    pa->a_icon = IG_FLOPPY;
	    break ;
	case 1 :
	    pa->a_icon = IG_HARD;
	    break ;
	default :
	    pa->a_icon = IG_NET;
	    break ;
#ifdef USE_MOBILE_NETWARE							/* USE_MOBILE_NETWARE  tar  02/13/92 */
	-1 :
	    G.g_pbuff = pa->a_match ;
	    pa->a_match = string_alloc( (char far *)"NETWARE" ) ;		/* USE_MOBILE_NETWARE  tar  02/13/92 */
	    mobileNetwareIcon = (int far *) &pa->a_icon;			/* USE_MOBILE_NETWARE  tar  02/13/92 */
	    pa->a_icon = ( mobileNetwarePointer->currentlySyncd == 1 )  ?	/* USE_MOBILE_NETWARE  tar  02/13/92 */
			MOBILE_NETWARE_CONNECTED : MOBILE_NETWARE_DISCONNECTED; /* USE_MOBILE_NETWARE  tar  02/13/92 */
	    break ;
#endif /* USE_MOBILE_NETWARE */	    
	   } /* switch */

} /* makeDiskAnode() */

/*----------------------------------------------------------------------------
    Set up disk drives.
*/
MLOCAL void init_disk_drives( void )
{
WORD		ii, ndisks, dtype ;

    ndisks = setdisk( gl_stdrv ) ;		/* get # of logical drives */

    for( ii = 0; ii < ndisks; ii++ ) {		/* Auto detect disk drives */
	
	dtype = dos_dtype( ii );
	if ( dtype == 0x0F )
	    continue ;

	makeDiskAnode( dtype, ii+'A' ) ;
	
    } /* for ndisks */

#ifdef USE_MOBILE_NETWARE							/* USE_MOBILE_NETWARE  tar  02/13/92 */
    MobileNetware();								/* USE_MOBILE_NETWARE  tar  02/13/92 */
    if ( mobileNetwareLoaded )							/* USE_MOBILE_NETWARE  tar  02/13/92 */
	makeDiskAnode( -1, ' ' ) ;							/* USE_MOBILE_NETWARE  tar  02/13/92 */
#endif /* USE_MOBILE_NETWARE */										/* USE_MOBILE_NETWARE  tar  02/13/92 */

} /* init_disk_drives() */

/*----------------------------------------------------------------------------
*
*/
MLOCAL void WriteOneWord( WORD fHndl, WORD sHndl, WORD string_num, WORD value)
{
char	tmp[ INI_STRING_LEN ] ;

    sprintf( tmp, "%d", value ) ;
    ini_write_item( fHndl, rsc_get_string( sHndl, string_num ), tmp ) ;

} /* WriteOneWord() */

/*----------------------------------------------------------------------------
*
*/
MLOCAL void WriteBkgrd( WORD fHndl, WORD sHndl)
{
char	tmp[ INI_STRING_LEN ] ;

    if (prefs.bkgd_type)
	    sprintf( tmp, "%d,%s", prefs.bkgd_type, prefs.bkgd_name ) ;
    else
	    sprintf( tmp, "%d", prefs.bkgd_type ) ;

    ini_write_item( fHndl, rsc_get_string( sHndl, SBKGRND ), tmp ) ;

} /* WriteBkgrd() */

/*----------------------------------------------------------------------------
*
*/
MLOCAL void WriteScrSave( WORD fHndl, WORD sHndl)
{
char	tmp[ INI_STRING_LEN ] ;

    sprintf( tmp, "%d,%s", prefs.scrnsvr_time, prefs.scrnsvr_name ) ;
    ini_write_item( fHndl, rsc_get_string( sHndl, SSCRNSAV ), tmp ) ;

} /* WriteScrSave() */

/*----------------------------------------------------------------------------
  Starting at offset in fHndl, search for and read value at str_num label.
*/
MLOCAL void ReadOneWord( WORD fHndl, long offset, WORD sHndl, WORD str_num, 
							    WORD * value )
{
char	tmp[ MAX_LINE_LEN ] ;

    offset = ini_item_offset( fHndl, offset, rsc_get_string( sHndl, str_num));
    if ( offset != -1L ) {
	dos_read( fHndl, MAX_LINE_LEN, (long)(void far *)tmp ) ;
	sscanf( tmp, "%d", value ) ;
    }
} /* ReadOneWord() */


/***********************************************************************
    The Background image is recorded as integer[,filename].
    If integer is 0, no bitmap image is desired.  
    1 -> centered (the default), 2 -> tiled, 3 -> scaled.
***********************************************************************/

MLOCAL void ReadBkgrd( WORD fHndl, long offset, WORD sHndl )
{
	char	tmp[ MAX_LINE_LEN ] ;	
	
	if (ini_item_offset( fHndl, offset, 
		rsc_get_string( sHndl, SBKGRND)) != -1L)
	{
		dos_read( fHndl, MAX_LINE_LEN, (long)(void far *)tmp );
		sscanf( tmp, "%d", &prefs.bkgd_type );
		if (!prefs.bkgd_type)
			/* No file */
			prefs.bkgd_name[0] = '\0';
		else
		{
			sscanf(strchr(tmp, ',')+1, "%s", prefs.bkgd_name);
		}
	}
}


/***********************************************************************
    The Screen Saver image is recorded as integer,filename.
    If integer is 0, no automatic screen saving will be performed.
    A non-zero integer represents the number of minutes of inactivity
    required to trigger screen saving.
***********************************************************************/

MLOCAL void ReadScrSave( WORD fHndl, long offset, WORD sHndl )
{
	char	tmp[ MAX_LINE_LEN ] ;	
	
	if (ini_item_offset( fHndl, offset, 
		rsc_get_string( sHndl, SSCRNSAV)) != -1L)
	{
		dos_read( fHndl, MAX_LINE_LEN, (long)(void far *)tmp );
		sscanf( tmp, "%d", &prefs.scrnsvr_time );
		sscanf(strchr(tmp, ',')+1, "%s", prefs.scrnsvr_name);
	}
}


/*----------------------------------------------------------------------------
 NOTE:	The prefs must be read in the order they are declared in the 
	CSAVE structure, because they are bytes and we scan them as
	integers, which overwrites part of the next field, which is also
	a byte.
*/
MLOCAL void ReadPrefs( WORD fHndl, WORD sHndl )
{
long	section_offset ;
WORD	sound = -1 ;

    dos_lseek( fHndl, SEEK_SET, 0L ) ;
    section_offset = ini_section_offset( fHndl, 
					rsc_get_string( sHndl, SPREFS ) ) ;
    if ( section_offset == -1L )
	return ;

    ReadOneWord( fHndl, section_offset, sHndl, SCOPIES,  
						(WORD *)&prefs.confirm_copies ) ;
    ReadOneWord( fHndl, section_offset, sHndl, SDELETES, 
						(WORD *)&prefs.confirm_delete ) ;
    ReadOneWord( fHndl, section_offset, sHndl, SOVERWR,  
						(WORD *)&prefs.confirm_ovrwrite ) ;
    ReadOneWord( fHndl, section_offset, sHndl, SCLKSPD,  
						(WORD *)&prefs.dclk_speed ) ;
    ReadOneWord( fHndl, section_offset, sHndl, SMENUKND, 
						(WORD *)&prefs.menu_type ) ;
    ReadOneWord( fHndl, section_offset, sHndl, SAUTOSAV, 
						(WORD *)&prefs.auto_save ) ;
    ReadOneWord( fHndl, section_offset, sHndl, STMXCTRL, 
						(WORD *)&prefs.tmax_ctrl ) ;
    ReadOneWord( fHndl, section_offset, sHndl, SSOUND, (WORD *)&sound ) ;
    if ( sound != -1 )
	v_sound( FALSE, !sound, 0 ) ;
    ReadBkgrd( fHndl, section_offset, sHndl );
    ReadScrSave( fHndl, section_offset, sHndl );
    
} /* ReadPrefs() */

/*----------------------------------------------------------------------------
 NOTE:	obid must be read after hsl/vsl/t_hsl/t_vsl since these
	are defined as bytes in the WSAVE structure, and we scan them as
	integers, which overwrites part of the next field, which is also
	a byte. For the same reason, they must be read in order.
*/
MLOCAL void ReadWPrefs( WORD fHndl, WORD sHndl )
{
WORD		winnum			= 0 ;
long		section_offset		= 0L ;
long		item_offset ;
char		tmp[ MAX_LINE_LEN ] ;
WORD		x, y, w, h, tx ;
WNODE far *	pw ;

    while ( winnum < NUM_WNODES ) {
	
	dos_lseek( fHndl, SEEK_SET, 0L ) ;
	sprintf( tmp, "%s%d", rsc_get_string( sHndl, SWINDOW ), winnum+1 ) ;
	section_offset = ini_section_offset( fHndl, tmp ) ;
	if ( section_offset == -1L )
	    return ;
	
	pw = (WNODE far *)&G.g_wlist[winnum] ;
	
	item_offset = ini_item_offset( fHndl, section_offset, 
					rsc_get_string( sHndl, SSLIDERS ) ) ;
	if ( item_offset != -1L ) {
	    dos_read( fHndl, MAX_LINE_LEN, (long)(void far *)tmp ) ;
	    sscanf( tmp, "%d,%d,%d", 
		&prefs.win[winnum].ws_cvrow,
		&prefs.win[winnum].ws_t_cvind, &prefs.win[winnum].ws_t_cvrow ) ;
	}
	item_offset = ini_item_offset( fHndl, section_offset, 
				    rsc_get_string( sHndl, SSIZE ) ) ;
	if ( item_offset != -1L ) 
	{
	    dos_read( fHndl, MAX_LINE_LEN, (long)(void far *)tmp ) ;
	    sscanf( tmp, "%d,%d,%d,%d,%d", &x, &y, &w, &h, &tx ) ;
	    gl_savewin[winnum].g_x = FromPercent(x, gl_width);
	    gl_savewin[winnum].g_y = FromPercent(y, gl_height);
	    gl_savewin[winnum].g_w = FromPercent(w, gl_width);
	    gl_savewin[winnum].g_h = FromPercent(h, gl_height);
	    gl_savetx[winnum] = FromPercent(tx, gl_width);
	}

	ReadOneWord( fHndl, section_offset, sHndl, STREE, &tx );
	pw->w_type = tx ;
	ReadOneWord( fHndl, section_offset, sHndl, SVIEW, &tx );
	pw->w_view = tx ;
	ReadOneWord( fHndl, section_offset, sHndl, SSORT, &tx );
	pw->w_sort = tx ;

	item_offset = ini_item_offset( fHndl, section_offset, 
					    rsc_get_string( sHndl, SPATH ) ) ;
	if ( item_offset != -1L ) {
	    dos_read( fHndl, MAX_LINE_LEN, (long)(void far *)tmp ) ;
	    sscanf( tmp, "%s", prefs.win[winnum].ws_pth ) ;
	    if ( prefs.win[winnum].ws_pth[0] == '~' )
		prefs.win[winnum].ws_pth[0] = '\0' ;	/* (hca) */
	}
	item_offset = ini_item_offset( fHndl, section_offset, 
					rsc_get_string( sHndl, SWILDCRD ) ) ;
	if ( item_offset != -1L ) {
	    dos_read( fHndl, MAX_LINE_LEN, (long)(void far *)tmp ) ;
	    sscanf( tmp, "%s", G.g_1text ) ;
	    fstrcpy( pw->w_wild, (char far *)G.g_1text ) ;
	}
	
	winnum++ ;
    }
    
} /* ReadWPrefs() */

/*----------------------------------------------------------------------------
*/
MLOCAL void ReadFileIcons( WORD fHndl, WORD sHndl )
{
long	offset ;
long	next_offset ;
char	tmp[ MAX_LINE_LEN ] ;
char *	ptr ;
WORD	len ;

    dos_lseek( fHndl, SEEK_SET, 0L ) ;
    offset = ini_section_offset( fHndl, rsc_get_string( sHndl, SFILEICN ) ) ;
    if ( offset == -1L )
	return ;

    next_offset = find_offset( fHndl, "[" ) ;
    if ( next_offset == -1L )
	next_offset = 32767L ;		/* force eof condition, below */
    else
	next_offset += offset ;
    
    while ( offset < next_offset ) {
	
	dos_lseek( fHndl, SEEK_SET, offset ) ;		/* read this line */
	len = dos_read( fHndl, MAX_LINE_LEN-1, (long)(void far *)tmp ) ;
	if ( len == 0 )
	    return ;
	tmp[ len ] = '\0' ;		/* mark the end of the buffer read */
	ptr = strstr( tmp, crlf ) ;	/* mark the end of the line */
	if ( ptr != NULL ) 
	    *ptr = '\0' ;		
	ptr = strchr( tmp, '#' ) ;	/* disregard anything right of a # */
	if ( ptr != NULL ) 
	    *ptr = '\0' ;
	if ( strlen( tmp ) )
	    ficon_parse( tmp );
	
	dos_lseek( fHndl, SEEK_SET, offset ) ;	 /* back to previous line */
	offset += 1 + find_offset( fHndl, "\n" ); /* advance to next line */
    }
    
} /* ReadFileIcons() */

/*----------------------------------------------------------------------------
*/
MLOCAL void ReadCSets( WORD fHndl, WORD sHndl )
{
long	section_offset ;

    dos_lseek( fHndl, SEEK_SET, 0L ) ;
    section_offset = ini_section_offset( fHndl, 
					rsc_get_string( sHndl, SCOLORS ) ) ;
    if ( section_offset == -1L )
	return ;

    ReadOneWord( fHndl, section_offset, sHndl, SMXCOLRS, &cs_maxcolors ) ;
    ReadOneWord( fHndl, section_offset, sHndl, SCURCOLR, &cs_currentcolor ) ;

} /* ReadCSets() */

/*----------------------------------------------------------------------------
*	Initialize the application list by reading in the DESKTOP.INF
*	file, either from memory or from the disk if the shel_get
*	indicates no message is there.
	RETURNS: 0 = Failed to read DESKLO,DESKHI, VIEWHELP.RSC or INI file
		 -1= Not enough memory to read ICNs
		 1 = success reading INI or $$$ */
WORD app_start( void )
{
WORD		fHndl, xcnt, ycnt, ret;
WORD		sHndl ;			/* strings file handle */
FDB FAR		*bmp;

    G.g_pbuff = gl_buffer;

    initAppList() ;
    init_disk_drives() ;

    /* open VIEWHELP.RSC (contains free strings used in INI) */
    sHndl = app_getfh( OPEN_FILE, -1, READONLY );
    if ( !sHndl ) 
	return( NO_RSC_FILE ) ;
    
    /* See what icons are available */
    ret = app_rdicon() ;
    if ( ret != TRUE )
	return( NO_ICON_FILE ) ;

    fHndl = app_getfh( OPEN_FILE | TMP_FILE, INIFNVM, READONLY);
    if (!fHndl){
	fHndl = app_getfh( OPEN_FILE, INIFNVM, READONLY );
	if (!fHndl)
	    return( NO_INI_FILE );
       }
       
    ReadPrefs( fHndl, sHndl ) ;
    ReadWPrefs( fHndl, sHndl ) ;

    ReadFileIcons( fHndl, sHndl ) ;

    ReadCSets( fHndl, sHndl ) ;

    dos_close( fHndl );
    
/* close VIEWHELP.RSC (contains strings used in INI) */    
    dos_close( sHndl ) ;

    if (*prefs.bkgd_name)
    {
	bmp = load_bmp_file((BYTE FAR *)prefs.bkgd_name, FALSE);
	if (bmp)
	{
		bmp->fd_r1 = prefs.bkgd_type;
		xgrf_dtimage(bmp);
	}
	G.g_bitmap = bmp;
    }
    else G.g_bitmap = (FDB far*)0L;
    
    cs_init_colors() ;
    
    G.g_wicon = 12 * gl_wschar;
    G.g_hicon = G.g_iconlist[0].image->fd_h + gl_hschar + 3;
    G.g_icw = (gl_height <= 300) ? 0 : 8;
    G.g_icw += G.g_wicon;
    xcnt = (gl_width/G.g_icw);
    G.g_icw += (gl_width % G.g_icw) / xcnt;
    G.g_ich = G.g_hicon + MIN_HINT;
    ycnt = ((gl_height-gl_hbox) / G.g_ich);
    G.g_ich += ((gl_height-gl_hbox) % G.g_ich) / ycnt;

    /* Delete temporary file if invoked using $$$ file */
    app_getfh( DELETE_FILE | TMP_FILE, INIFNVM, 0 );
	
    return( TRUE );
    
} /* app_start() */

/*----------------------------------------------------------------------------
*	Save [Prefs] section of VIEWMAX.INI file.
*/
MLOCAL void SavePrefs( WORD fHndl, WORD sHndl )
{
    ini_write_section( fHndl, rsc_get_string( sHndl, SPREFS ) ) ;

    WriteOneWord( fHndl, sHndl, SDELETES, prefs.confirm_delete ) ;
    WriteOneWord( fHndl, sHndl, SCOPIES,  prefs.confirm_copies ) ;
    WriteOneWord( fHndl, sHndl, SCLKSPD,  prefs.dclk_speed ) ;
    WriteOneWord( fHndl, sHndl, SOVERWR,  prefs.confirm_ovrwrite ) ;
    WriteOneWord( fHndl, sHndl, SMENUKND, prefs.menu_type ) ;
    WriteOneWord( fHndl, sHndl, SAUTOSAV, prefs.auto_save ) ;
    WriteOneWord( fHndl, sHndl, STMXCTRL, prefs.tmax_ctrl ) ;
    WriteOneWord( fHndl, sHndl, SSOUND,   !v_sound( FALSE, 0xFFFF, 0) ) ;
    WriteBkgrd( fHndl, sHndl );
    WriteScrSave( fHndl, sHndl );
    
    dos_write( fHndl, strlen( crlf ), (long)(void far *)crlf ) ;
	
} /* SavePrefs() */

/*----------------------------------------------------------------------------
*	Save [Colors] and [Drivers] section of VIEWMAX.INI file.
*/
MLOCAL void CopySection( char * section, WORD fHndl, WORD origPtr )
{
long	section_offset, next_offset ;

    /* position origPtr at line following section */
    ini_section_offset( origPtr, section );
    
    /* add section to new INI file */
    ini_write_section( fHndl, section ) ;

    /* copy rest of color prefs from original file to new fHndl */
    CopyFile( fHndl, origPtr ) ;

    /* move forward again in file until line after section */
    section_offset = ini_section_offset( fHndl, section );
    
    /* move forward in file until EOF or next "[" char */
    next_offset = find_offset( fHndl, "[" ) ;
    
    /* make EOF follow section */
    if ( next_offset != -1L )
	chsize( fHndl, section_offset + next_offset ) ;
    
    dos_lseek( fHndl, SEEK_END, 0L ) ;
       
} /* CopySection() */

/*----------------------------------------------------------------------------
*	Save [WindowX] section of VIEWMAX.INI file.
*/
MLOCAL void SaveWPrefs( WORD fHndl, short winnum, WORD sHndl )
{
char		tmp[ INI_STRING_LEN ] ;
WNODE far *	pw ;

    pw = (WNODE far *)&G.g_wlist[winnum] ;
    
    sprintf( tmp, "%s%d", rsc_get_string( sHndl, SWINDOW ), winnum+1 ) ;
    ini_write_section( fHndl, tmp ) ;

    sprintf( tmp, "%d,%d,%d", 
	prefs.win[ winnum ].ws_cvrow,
	prefs.win[ winnum ].ws_t_cvind, prefs.win[ winnum ].ws_t_cvrow ) ;
    ini_write_item( fHndl, rsc_get_string( sHndl, SSLIDERS ), tmp ) ;

    sprintf( tmp, "%d,%d,%d,%d,%d",
	ToPercent(prefs.win[winnum].ws_box.x, gl_width),
	ToPercent(prefs.win[winnum].ws_box.y, gl_height),
	ToPercent(prefs.win[winnum].ws_box.w, gl_width),
	ToPercent(prefs.win[winnum].ws_box.h, gl_height),
	ToPercent(prefs.win[winnum].ws_t_x, gl_width) ) ;
    ini_write_item( fHndl, rsc_get_string( sHndl, SSIZE ), tmp ) ;
    
    WriteOneWord( fHndl, sHndl, STREE, pw->w_type ) ;
    WriteOneWord( fHndl, sHndl, SVIEW, pw->w_view ) ;
    WriteOneWord( fHndl, sHndl, SSORT, pw->w_sort ) ;

    sprintf( tmp, "%s", (prefs.win[ winnum ].ws_pth[0] == '@') ? 
			"~" : prefs.win[ winnum ].ws_pth ) ;
    ini_write_item( fHndl, rsc_get_string( sHndl, SPATH ), tmp ) ;

    fstrcpy( (char far *)tmp, (pw->w_wild[0] == '\0') ? "*.*" : pw->w_wild ) ;
    ini_write_item( fHndl, rsc_get_string( sHndl, SWILDCRD ), tmp ) ;
	
    dos_write( fHndl, strlen( crlf ), (long)(void far *)crlf ) ;
	
} /* SaveWPrefs() */

/*----------------------------------------------------------------------------
*	Save app in [Programs] section of VIEWMAX.INI file.
*/
MLOCAL void SaveFileIcons( WORD fHndl, ANODE * pa )
{
char	tmp[ MAX_LINE_LEN ] = {0} ;

    sprintf( tmp, "%d:%s=%s.%s", pa->a_type, pa->a_match, 
	G.g_iconlist[pa->a_icon].fname,
		    (pa->a_icon > IA_GENERIC+gl_num_icos) ? "ICF" : "ICO") ;
    
    strcat( tmp, crlf ) ;
    dos_write( fHndl, strlen( tmp ), (long)(void far *)tmp ) ;
 	
} /* SaveFileIcons() */

/*----------------------------------------------------------------------------
*	Save the current state of all the icons to a file called 
*	VIEWMAX.INI
*/
void app_save( void )
{
short		ii ;
ANODE *		pa;
char		tmp[3];
WORD		origHndl ;
WORD		sHndl ;			/* VIEWHELP.RSC */
WORD		tHndl ;			/* temp file handle */
char		tName[ LEN_ZPATH ];	/* temp file name */
char 		origName[ LEN_ZPATH ] ;

    /* open VIEWHELP.RSC (contains free strings used in INI) */
    sHndl = app_getfh_loop( OPEN_FILE, -1, READONLY, SPREFILE ) ;
    if ( ! sHndl ) return ;
    
    strcpy( tName, ini_str(INIFNVM) );	

    /* because we were able to open VIEWHELP.RSC, assume that correct
	diskette is in */
    origHndl = app_getfh( OPEN_FILE, INIFNVM, READONLY );
    if ( !origHndl ) {	
	/* See if we can find the file */
	strcpy( G.g_srcpth, tName );
	if ( shel_find( (long)(char far *)G.g_srcpth ) ) {
	    /* Found -> access violation due to some other task */
	    alert_s( 1, ERSHARVI, tName );
	}
	dos_close( sHndl ) ;
	return;
    }
    strcpy( origName, G.g_srcpth ) ;

    /* create new INI file with unique name */
    strcpy( tName, origName ) ;
    *( 1 + strrchr( tName, '\\' ) ) = '\0' ;
    tHndl = creattemp( tName, 0 ) ;		/* read and write */
    
    SavePrefs( tHndl, sHndl ) ;			/* save misc prefs */

    for( ii=0; ii < NUM_WNODES; ii++ )		/* save window prefs */
	SaveWPrefs( tHndl, ii, sHndl ) ;
    
    ini_write_section( tHndl, rsc_get_string( sHndl, SFILEICN ) ) ;

    for ( pa=G.g_ahead; pa != (ANODE*)NULL; pa=pa->a_next ) {
	
	if ( pa->a_type == AT_ISDISK || pa->a_flags & AF_ISDEF ) 
	    continue;
	SaveFileIcons( tHndl, pa ) ;		/* save file/icon assignments */
	}
	
    dos_write( tHndl, strlen( crlf ), (long)(void far *)crlf ) ;
	
    /* copy original color prefs and driver info */	
    CopySection( rsc_get_string( sHndl, SCOLORS ), tHndl, origHndl ) ;
    CopySection( rsc_get_string( sHndl, SDRIVERS ), tHndl, origHndl ) ;

/* clean up */    
    dos_close( origHndl ) ;
    dos_close( tHndl ) ;
    
    if ( G.g_exec  )
	strcpy( strrchr( origName, '.' ), ".$$$" ) ;
    
    dos_delete( (long)(char far *)origName ) ; /* delete any existing tmp */
    dos_rename( (long)(char far *)tName, (long)(char far *)origName ) ;

/* use routines to go in and change just one section/item set in INI	*/ 
/* have to use funny places to store strings since ini_str() and
   rsc_get_string() both want to use gl_lngstr[].			*/
    sprintf( tmp, "%d", cs_currentcolor ) ;	/* save current color	*/
    strcpy( origName, rsc_get_string( sHndl, SCOLORS ) ) ;
    strcpy( tName,    rsc_get_string( sHndl, SCURCOLR ) ) ;
    ini_write( INIFNVM, (BYTE far *)origName, (BYTE far *)tName, (BYTE far *)tmp ) ;

/* close VIEWHELP.RSC (contains strings used in INI) */    
    dos_close( sHndl ) ;

/* record user's setting for TM LIM size */
   if (SaveTMLIMSize() != INI_SUCCESS)	/* desktmax.c (rsf)*/
   {
	   strcpy( tName, ini_str(INIFNTM));
	   alert_s( 1, ERSHARVI, tName );
   }

} /* end app_save() */

/*----------------------------------------------------------------------------
*	Find the ANODE that is appropriate for this object.
*/
ANODE * find_anode( FNODE far * pf )
{
BYTE		pname[LEN_ZFNAME];
ANODE *		pa ;
INODE *		pi ;
WORD		atype ;

    fstrcpy((BYTE far *)pname, pf->f_name);	/* get a local copy	*/
    
/* first search for executable program items */
    if ( pf->f_attr & F_PROGITEM ) {		
	for (pi = g_ihead; pi != (INODE*)NULL; pi = pi->i_next)	{
	    if ( strcmp(pi->i_label, pname) == 0 )
		return( (ANODE*)pi );
	} /* for */
    }
    
    else {
	atype = ( pf->f_attr & F_SUBDIR ) ? AT_ISFOLD : AT_ISFILE ;
	
/* next search for documents belonging to some program item */
	if ( atype == AT_ISFILE ) {
	    for (pi = g_ihead; pi != (INODE*)NULL; pi = pi->i_next) {
		if ( wildcmp( pi->i_doctypes, pname) )
		    return( (ANODE*)pi );
	    } /* for */
	} /* if AT_ISFILE */
	
/* lastly search for unattached files or folders */	
	for (pa = G.g_ahead; pa != (ANODE*)NULL; pa = pa->a_next) 
	{
	    if ( pa->a_type == atype || pa->a_type == AT_ISWIND ) 
	    {
		if ( wildcmp(pa->a_match, pname) )
		    return( pa );
	    } /* if */
	} /* for */
	
    } /* else */
    
    return( (ANODE *)NULL );
	
} /* find_anode() */


/*
 *	EOF:	deskapp.c
 */
