/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskcet.c 4.5 92/04/03 17:10:25 sbc Exp $
* $Log:	deskcet.c $
 * Revision 4.5  92/04/03  17:10:25  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.4  92/03/26  14:43:55  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.3  92/03/13  14:34:44  sbc
 * define TREEICONS moved to machine.h
 * 
 * Revision 4.2  92/03/12  13:58:10  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.1  92/02/14  12:32:57  anderson
 * Added compile time change to tree tag hotspot location for small icons.
 * 
 * Revision 3.1  91/08/19  16:39:31  system
 * ViewMAX 2 sources
 * 
 * Revision 3.10  91/08/05  17:40:49  fontes
 * Fix bug from merge interfering with +/- operations
 * 
 * Revision 3.9  91/08/02  17:07:40  sbc
 * *** empty log message ***
 * 
 * Revision 3.8  91/08/02  15:38:35  sbc
 * misc changes required to move FNODEs into far memory.
 * 
 * Revision 3.7  91/06/12  10:30:54  anderson
 * Bug fix: don't ever draw a tag on a tree object that has no children.
 * 
 * Revision 3.6  91/06/04  16:27:55  fontes
 * Horizontal scrolling for tree windows
 * 
 * Revision 3.5  91/06/04  13:03:05  sbc
 * misc housekeeping and other ravings...
 * 
 * Revision 3.4  91/05/30  15:31:38  fontes
 * Use gl_wchar instead of re-inquiring about text attrs
 * 
 * Revision 3.3  91/05/22  21:19:21  fontes
 * Corrected implementation oversight wrt KB-SC's. Also made - and single-click on - consistent
 * 
 * Revision 3.1  91/05/20  16:41:29  fontes
 * C-E trees, tag management completed
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
910604	RSF		Take h-scroll into account for tag location.
910530	RSF		Use gl_char instead of re-inquiring for font attrs.
910521	RSF		Completed C-E tree display work.
910520	RSF		Begin collapsible-expandable tree work.
9105??	RSF		Completed C-E tree work.
*/

/****************************************************************************
* File:		deskcet.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/

#include "shell.h"
#include "funcdef.h"

extern WORD	gl_wchar;	/* Pixel width of character cell */

/***********************************************************************
*	This routine locates the FNODE associated with a particular
*	object in a window.
************************************************************************/

MLOCAL FNODE far *fnode_from_obj( WNODE far * pw, WORD obj )
{
FNODE far *	pf;
	
    for (pf = pw->w_path->p_flist; pf && pf->f_obid != obj; pf = pf->f_next)
	;
		
    return(pf);
}

/***********************************************************************
*	Handles redrawing necessary for collapse/expand of display.
***********************************************************************/
MLOCAL void redraw_ce_tree(WORD wh, FNODE far * f)
{
WNODE far *	pw;
GRECT		r;

	wind_get( wh, WF_WXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);	
	pw = win_find( wh);

	win_bldview( pw, r.g_x, r.g_y, r.g_w, r.g_h);
	fun_msg( WM_REDRAW, wh, r.g_x, r.g_y, r.g_w, r.g_h);	
	cursor_set( f, &r);
}

/*************************************************************************
*	This routine determines whether a mouse click occured over the
*	tag portion of a tree entry or elsewhere.
**************************************************************************/
GLOBAL FNODE far *cet_clicked_tag(
		WORD	wh,		/* Current window		 */
		WORD	obj,		/* Clicked object		 */
		TREE    tree,		/* Tree for window objects	 */
		WORD	root,		/* Root object of window	 */
		WORD    mx)		/* X-coord of click or KS	 */

{
GRECT		t;
FNODE far *	pf;
WNODE far *	pw;
BYTE		cnt, indent;
WORD		tag_edge;
	
	pw = win_find(wh);
	pf = fnode_from_obj(pw, obj);
	if (pf->f_treetag == NOKIDS)
		return((FNODE far *)0);

					/* get object's extent	*/
	fmemcpy( (void far *)&t, (void far *)&((tree+obj)->ob_box), sizeof( GRECT ) );
	t.g_x += (tree+root)->ob_box.x;
	t.g_y += (tree+root)->ob_box.y;
					/* get char cell info	*/
#if TREEICONS	
	for( cnt = 0, indent=0 ; pf->f_tree[cnt] && cnt<MAX_LEVEL ; 
		cnt++, indent+=3 );
#else /* TREEICONS */
	for( cnt = 0, indent=0 ; pf->f_tree[cnt] && cnt<MAX_LEVEL ; 
		cnt++, indent+=5 );
	if (cnt)
		indent-=2;
#endif /* TREEICONS */
	tag_edge = t.g_x + ((indent - pw->w_cvind) * gl_wchar);
	if ( (tag_edge <= mx) &&
		(mx <= tag_edge+(3*gl_wchar)) )	/*[x] -> 3 */
	{
		return(pf);
	}
	else
		return (FNODE far *)0;

}

/***********************************************************************
*	This routine collapses/expands a directory display.
***********************************************************************/

GLOBAL void ce_tree(	WORD which,	/* Whether to collapse or expand */
			WORD wh,	/* Current window		 */
			TREE tree,	/* Tree for window objects	 */
			WORD root,	/* Root object of window	 */
			WORD mx,	/* X-coord of click or KS	 */
			WORD my,	/* Y-coord of click or KS	 */
			WORD dclick)	/* True if should mimic dbl click*/
{
WNODE far *	pw;
WORD		obj;
FNODE far *	pf;
	
	pw = win_find(wh);
	
	obj = gr_obfind(tree, root, mx, my);
	
	pf = fnode_from_obj(pw, obj);

#if 0	/* (hca: bug fix: DON'T draw tag an object with NOKIDS) */
	if (dclick && pf->f_treetag!=which)
	{
		/* Allow Alt+/Alt- regardless of present treetag */
		pf->f_treetag = which;
	}
#endif /* 0 */

	if (pf->f_treetag == NOKIDS)
		return;
	
	if (dclick && pf->f_treetag!=which)
	{
		/* Allow Alt+/Alt- regardless of present treetag */
		pf->f_treetag = which;
	}
	if (pf->f_treetag != which)
	{
		/* Special case '+' on [-] */
		if (which == SHOWKIDS)
		{
			dclick = TRUE;
			pf->f_treetag = which;
		}
		else	return;
	}
	cet_act_tag(wh, pf, dclick);

} /* ce_tree() */

/*************************************************************************
*	This routine changes the treetags of all directories that are 
*	children of the given parent. 
*************************************************************************/
MLOCAL void cet_change_all( FNODE far * parent )
{
WORD		depth;
FNODE far *	child;
	
	depth = fstrlen( parent->f_tree );

	for ( child = parent->f_next; 
		child && depth < fstrlen(child->f_tree);
		child = child->f_next)
	{
		if (child->f_treetag != NOKIDS)
		{
			child->f_treetag = parent->f_treetag;
		}
	}
}

/*************************************************************************
*	This routine completes the actions required by a treetag
*	change.
**************************************************************************/
GLOBAL void cet_act_tag(
		WORD wh,		/* Handle of current window	*/
		FNODE far * parent,	/* Dir whose tag was changed.	*/
		WORD dclick)		/* True of double-clicked	*/
{
WORD		depth;
BOOLEAN		all_hid		= TRUE;
BOOLEAN		grand_children	= FALSE;
FNODE far *	child;
    
	if (parent->f_treetag == SHOWKIDS)
	{	/* if presently hidden, unhide */
		parent->f_treetag = HIDEKIDS;
		if (dclick)
		{
		    /* Expand all children */
		    cet_change_all(parent);
		}
	}
	else
	{
		/* presently showing, hide all	*/
		/* children.			*/
		parent->f_treetag = SHOWKIDS;

		depth = fstrlen(parent->f_tree);
		for (child = parent->f_next; 
			child && depth < fstrlen(child->f_tree);
			child = child->f_next)
		{
			if (fstrlen(child->f_tree)-1 > depth)
			{
				grand_children = TRUE;
				/* only examine immediate children */
				continue;
			}
			else if (child->f_treetag == HIDEKIDS)
			{
				/* All not immed. kids not hidden. */
				all_hid = FALSE;
			}
		}
		if ( all_hid )		/* Already down to 1st level so */
			dclick = TRUE;	/*    now we'll close remainder */
		
		cet_change_all(parent);
		if (!dclick && grand_children)
		{
			/* Leave immediate children visible */
			parent->f_treetag = HIDEKIDS;
		}
	 
	}
	redraw_ce_tree(wh, parent);

}/* cet_act_tag() */

/* end of deskcet.c */
