#define USE_ASM	1
/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*   Copyright (c) 1992  Digital Research Inc.				    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskcicn.c 4.4 92/04/06 09:43:08 Fontes Stable $
* $Log:	deskcicn.c $
 * Revision 4.4  92/04/06  09:43:08  Fontes
 * Initial cut to extract/display Windows exe embedded icons. Asm optimizations for bitmaps
 * 
 * Revision 4.3  92/03/26  14:45:09  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.2  92/01/28  14:57:56  rsf
 * *** empty log message ***
 * 
 * Revision 4.2  92/01/21  13:34:41  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.0  92/01/03  13:48:46  Fontes
 * Color Icon implementation
 * 
*/

/****************************************************************************
* File:		deskcicn.c
*
* Description:	
*
* Build Info:	ndmake -f aes.mak
*
*****************************************************************************/


#include "shell.h"

extern	WORD	DOS_ERR;
extern GLOBES	G;
extern WORD	gl_hschar;
extern WORD	gl_height;
extern WS	gl_ws;


#define	STD_CICON_SIZE	512	/* 512: enough for 16 colors, 32x32 */
#define	BITSperBYTE	8
#define BITSperWORD	16


/* The following table represents the mapping between GEM's pixel values and
 * the default colors of a Windows icon.
 */	   
MLOCAL	BYTE		clr_trans[16] = {15, 9, 10, 11, 12, 13, 14, 8,
					  7, 1,  2,  3,  4,  5,  6, 0};
MLOCAL	BYTE		mono_trans[2] = {1, 0};
MLOCAL	BYTE		mask_trans[2] = {0, 1};



/***********************************************************************
 *  Fill in fields of an ICONBLK.
 **********************************************************************/
GLOBAL void	init_icon(ICONBLK FAR *icon, WORD index)
{
	icon->ib_pdata = (LONG)G.g_iconlist[index].image;
	icon->ib_pmask = (LONG)G.g_iconlist[index].mask;
	icon->ib_xchar = 0; /*??*/
	icon->ib_ychar = 0; /*??*/
	icon->ib_wicon = G.g_iconlist[index].image->fd_w;
	icon->ib_hicon = G.g_iconlist[index].image->fd_h;
	icon->ib_xicon = ((G.g_wicon - icon->ib_wicon) / 2);
	icon->ib_yicon = 1;	
	icon->ib_xtext = 0; /*??*/
	icon->ib_ytext = G.g_iconlist[index].image->fd_h+2; /*??*/
	icon->ib_wtext = G.g_wicon;
	icon->ib_htext = gl_hschar;
	icon->ib_char = 0x1000;
}


/***********************************************************************
*	This routine converts a Microsoft Word 3.0 Bitmap to a GEM
*	MFDB.  The bitmap data is read from the file one pixel row at
*	a time.  Although this is not the most efficient way to read
*	the file, it saves on code size and memory use for a larger buffer.
*	This routine is expected to be called during init while reading
*	icons and for background or screensaver image reading - not so
*	time-critical.
***********************************************************************/

void	convert_bmp_fdb(WORD fh, WORD bit_count, WORD src_width, WORD height,
		WORD FAR *planes, LONG pl_size, BOOLEAN read_mask)
{
	WORD	pixels_per_byte;	/* # pixels rep'd by each byte	*/
	WORD	words_per_row;		/* # words to rep one row pxls	*/
	WORD	dest_width;		/* Width in the FDB to be	*/
	WORD	i, shift;
	UWORD	row_size;		/* Size of a row in BMP in bytes*/
	WORD	row_count;		/* Index into rows in memory blk*/
	UWORD	rows_per_block;		/* # of rows held in memory blk */
	WORD	dest_row_offset;	/* Used in format conversion	*/
	WORD	dest_word_offset;	/* Used in format convertion	*/
	WORD	pi;			/* Index into pixels[] array	*/
	WORD	wc;			/* Word index into dest plane	*/
	WORD	col;			/* Pixel column			*/
	WORD	index;			/* Byte index into src BMP	*/
	WORD	bc;			/* Index for bits in separation */
 	WORD	dest_word;		/* Constructed word in dest plane*/
#if USE_ASM
#else
	WORD	bit;			/* Extracted bit		*/
#endif
	LONG	pl_len;			/* Length of plane in words	*/
	unsigned BYTE	init_mask;	/* Mask based on # color planes	*/
	unsigned BYTE	mask;		/* Mask to obtain each pixel's data */
	BYTE FAR	*src_row;	/* Pointer into BMP		*/
	BYTE FAR	*row_block;	/* Memory block for BMP reading */
					/* One word's worth of planar pixels*/
	unsigned BYTE	pixels[BITSperWORD];	
	BYTE	*trans_tbl;		/* Table to effect pixel translation*/

/*T*/ WORD		hr1, min1, sec1, hsec1;
/*T*/ WORD		hr2, min2, sec2, hsec2;
/*T*/ WORD		h;
/*T*/ BYTE		str[30];

	
	/* Handle 16-bit alignment requirements */
	dest_width = src_width + (src_width % BITSperWORD);
	src_width += ((src_width*bit_count) % BITSperWORD);
	
	pixels_per_byte = BITSperBYTE/bit_count;
	pl_len = (pl_size/bit_count)/2;	/* sizeof each plane in words	*/
	
	words_per_row = dest_width/BITSperWORD;		/* Destination	*/
	row_size = (src_width*bit_count)/BITSperBYTE;	/* Source	*/
	
	switch (bit_count)
	{
		/* mono */
	case	1:
		init_mask = 0x80;
		if (read_mask)
			trans_tbl = mask_trans;
		else	trans_tbl = mono_trans;
		break;
		/* 16 color */
	case	4:
	default:	
		init_mask = 0xF0;
		trans_tbl = clr_trans;
	}

				/* Allocate as much as possible */
	rows_per_block = (WORD)(dos_avail() / row_size);
	if (rows_per_block > height)
		rows_per_block = height;
	src_row = row_block = (char far *)dos_alloc(row_size*rows_per_block);
	row_count = rows_per_block;

/*T*/	if (height > 200)
/*T*/	h = dos_open((LONG)(char far *)"D:\\CVTTIME", READWRITE);

/*T*/	dos_gettime(&hr1, &min1, &sec1, &hsec1);

	for (dest_row_offset = height - 1; dest_row_offset>=0;
		dest_row_offset--)
	{
		dest_word_offset = dest_row_offset * words_per_row;
	
		if (row_count == rows_per_block)
		{
			if (!dos_read(fh, row_size*rows_per_block,
				ADDR(row_block)))
			{
				dos_free((LONG)src_row);
				return;
			}
			row_count = 0;
			src_row = row_block;
		}

		/* Since bmp's start from bottom left and MFDB's start
		   from top left, must re-arrange as well as split 
		   planes
		*/

		if (bit_count == 1)
		{
			/* Avoid a bunch of extra work if only one plane */
		    fmemcpy((BYTE FAR *)&planes[dest_word_offset], src_row, 
			    row_size);
		    for (i = 0; i < words_per_row; i++)
#if USE_ASM
		    {
			/* NOTE: I used DX here because compiler used ax, bx
			   for its address calculations. If masks suddenly
			   fail, look here first. RSF.
			*/
			_DX = planes[dest_word_offset+i];
asm			mov	cl, 8
asm			rol	dx, cl
			planes[dest_word_offset+i] = _DX;
			if (!read_mask)
			{
				planes[dest_word_offset+i] ^= 0xFFFF;
			}


	            }
#else
			    (unsigned)planes[dest_word_offset+i] = _rotl(
				    (unsigned)planes[dest_word_offset+i], 8);
#endif
		}
		else
		{
		    pi = 0;
		    wc = 0;
			
		    for (col = 0; col < src_width; col++)
		    {
		        /* Work on filling a destination word's 
			   worth of pixels.
                         */
			if (pi < BITSperWORD)
			{
			    index = (col * bit_count) >> 3; /* (div by 8) */
			    shift = bit_count * (col % pixels_per_byte);
			    mask = init_mask >> shift;
			    pixels[pi] = src_row[index] & mask;
			    pixels[pi] >>= (BITSperBYTE-shift)-bit_count;
#if USE_ASM
			    _AL = pixels[pi];
asm 	mov bx, trans_tbl
asm	xlat
			    pixels[pi] = _AL;
#else
			    pixels[pi] = trans_tbl[pixels[pi]];
#endif
			    pi++;
			}
			if (pi == BITSperWORD || col == src_width-1 )
			{
			    /* Separate each pixel's data among
				 the planes of the MFDB
			    */
			    mask = 1;
			    for (bc=0; bc < bit_count; bc++)
			    {
#if USE_ASM

asm	push	si
asm	xor	si,si	/* bc */
/* start for i loop */
asm	lea	bx, pixels
asm	xor	dx,dx	/* dest_word */
i_loop:
asm	xor	ah, ah
asm	sal	dx, 1
asm	mov	al, [bx]
asm	and	ax, mask
asm	mov	cx, bc
asm	sar	ax, cl
asm	or	dx, ax
asm	inc	bx
asm	inc	si
asm	cmp	si, 16
asm	jnz	i_loop
asm	mov	dest_word, dx
/* end loop */
asm	pop	si

#else
				dest_word = 0;
				for (i=0; i < BITSperWORD; i++)
				{
				    dest_word <<= 1;
				    bit = pixels[i] & mask;
				    if (bc)
					bit >>= bc;
				    dest_word |= bit;
				}
#endif
				planes[((WORD)pl_len*bc) 
				    + dest_word_offset + wc] = dest_word;
				mask <<=1;
			    }
			    wc++;
			    pi=0;
			} /* end for (bc... */
	            } /* end for (col... */
	        } /* end else */
		src_row += row_size;
		row_count++;
	}
/*T*/	dos_gettime(&hr2, &min2, &sec2, &hsec2);	
	dos_free((LONG)src_row);
/*T*/	if (height > 200)
/*T*/	{
/*T*/	sprintf(str, "Stop>  %2d:%2d:%2d\.%2d\n", hr2, min2, sec2, hsec2);
/*T*/	dos_write(h, strlen(str), ADDR(str));
/*T*/	sprintf(str, "Start> %2d:%2d:%2d\.%2d\n", hr1, min1, sec1, hsec1);
/*T*/	dos_write(h, strlen(str), ADDR(str));
/*T*/	dos_close(h);
/*T*/	}

}

/***********************************************************************
*	This routine determines whether the size icon described by
*	the header passed in is appropriate for our screen's
*	resolution.
***********************************************************************/
MLOCAL BOOLEAN resolution_ok(WORD height)
{
	if (gl_height <= 300)
	{
		if (height == 16L)
			return TRUE;
		else	return FALSE;
	}
	else	if (height == 32L)
			return TRUE;
		else	return FALSE;
}

/***********************************************************************
*	This routine determines whether the colors of the icon described
*	by the header are compatible with our screen's capabilities.
************************************************************************/
MLOCAL BOOLEAN colors_ok(WORD color_count)
{
	return(gl_ws.ws_ncolors == color_count);
}

/***********************************************************************
* Read in the icon's bitmap and convert to an MFDB 
************************************************************************/
BOOLEAN process_icon(WORD fh, BMP_INFO *binfo, CICON *cicon)
{
	WORD		pixel_count;	/* Number of pixels in icon	*/
	WORD		width, height, i;
	BYTE FAR	*ptr;		/* pointer into planes		*/
	
	width = (WORD)binfo->width;
	height = (WORD)binfo->height/2;
	pixel_count = width * height;
	
	/* Get the image portion of the icon */
	cicon->image = (FDB FAR *)dos_alloc(sizeof(FDB));
	if ((cicon->image->fd_addr = dos_alloc(
		pixel_count*binfo->bit_count/BITSperBYTE)) == 0L)
	{
		alert_s( 0x0101, ERNOMEM, "Icon image" );
		dos_free((LONG)cicon->image);
		return (FALSE);
	}
	cicon->image->fd_w=width;
	cicon->image->fd_h=height;
	cicon->image->fd_wdwidth = width/BITSperWORD;
	cicon->image->fd_stand = 1;
	cicon->image->fd_nplanes = binfo->bit_count;
	
	convert_bmp_fdb(fh, binfo->bit_count, width, 
		height, (WORD FAR *)cicon->image->fd_addr, 
		pixel_count*binfo->bit_count/BITSperBYTE, FALSE);

	/* Now get the mask portion of the icon */
	cicon->mask = (FDB FAR *)dos_alloc(sizeof(FDB));
	if ((cicon->mask->fd_addr = dos_alloc(
		pixel_count*binfo->bit_count/BITSperBYTE)) == 0L)
	{
		alert_s( 0x0101, ERNOMEM, "Icon mask" );
		dos_free((LONG)cicon->image);
		return (FALSE);
	}
	cicon->mask->fd_w=width;
	cicon->mask->fd_h=height;
	cicon->mask->fd_wdwidth = width/BITSperWORD;
	cicon->mask->fd_stand = 1;
	cicon->mask->fd_nplanes = binfo->bit_count;

	convert_bmp_fdb(fh, 1, width, height, 
		(WORD FAR *)cicon->mask->fd_addr, pixel_count/BITSperBYTE, TRUE);
	
	/* Now duplicate the mask plane to the other 3 planes */
	ptr = (BYTE FAR*)cicon->mask->fd_addr;
	for (i=1; i<binfo->bit_count; i++)
		fmemcpy(&ptr[i*pixel_count/BITSperBYTE], ptr,
			pixel_count/BITSperBYTE);
	
	return TRUE;
}


#define NS_HDR_LEN	0x40	/* Header length in bytes		*/
#define	RS_TBL_LEN	0x18	/* Resource Table entry length in bytes */
#define RELOC_OFFSET	0x0C	/* Word offset equiv 0x18 bytes		*/
#define NS_HDR_OFFSET	0x1E	/* Word offset equiv 0x3C bytes		*/
#define RS_TBL_OFFSET	0x12	/* Word offset equiv 0x24 bytes		*/
#define RS_ENTRY_LEN	0x14	/* Size of first entry of type		*/
#define RS_SUBITEM_LEN	0x0C	/* Size of additional items of type	*/

/***********************************************************************
*	This routine opens a Windows executable file, then locates the
*	icon embedded within it so it can be rendered on the desktop.
************************************************************************/
BOOLEAN load_ico_from_exe(BYTE *fname, CICON *cicon)
{
	WORD	i;
	WORD	fh;
	WORD	ns_header_offset;	/* Offset from file beg. to new-*/
					/* style header			*/
	WORD	entry_count;		/* # resources of a type	*/
	WORD	shift_count;		/* Bits to shift icon offset	*/
	LONG	res_fp;			/* Tracks file pos. w/in res tbl*/
	
	WORD	exe_header[NS_HDR_LEN/2];
	UWORD	resource_table[RS_TBL_LEN/2];
	
	BMP_INFO binfo;
	
	fh = dos_open((LONG)(char far *)fname, READONLY);
	if (!fh || DOS_ERR)
		return FALSE;
	

	/* Pick up old-style header */
	if (dos_read(fh, NS_HDR_LEN, ADDR(exe_header)) != NS_HDR_LEN)
	{
		dos_close(fh);
		return FALSE;
	}
	
	/* Look for presence of new-style header */
	if ( exe_header[RELOC_OFFSET] < 0x40 )
	{
		dos_close(fh);
		return FALSE;
	}
	
	ns_header_offset = exe_header[NS_HDR_OFFSET];
	
	/* Seek to new-style header */
	dos_lseek(fh, SEEK_SET, (LONG)ns_header_offset);
	
	/* Pick up new-style header */
	if (dos_read(fh, NS_HDR_LEN, ADDR(exe_header)) != NS_HDR_LEN)
	{
		dos_close(fh);
		return FALSE;
	}
	
	/* Seek to resource table */
	res_fp = dos_lseek(fh, SEEK_SET, 
		(LONG)(exe_header[RS_TBL_OFFSET]+ns_header_offset));
	
	/* Now grub around for the Icon */
	dos_read(fh, sizeof(shift_count), ADDR(&shift_count));
	res_fp += sizeof(shift_count);
	dos_read(fh, RS_ENTRY_LEN, ADDR(resource_table));
	res_fp += RS_ENTRY_LEN;
	while (!DOS_ERR && resource_table[0] != 0x8003 
		&& resource_table[0] != 0)
	{
		entry_count = resource_table[1];
		for (i = entry_count; i > 1; i--)
		{
			dos_read(fh, RS_SUBITEM_LEN, ADDR(resource_table));
			res_fp += RS_SUBITEM_LEN;
		}
		dos_read(fh, RS_ENTRY_LEN, ADDR(resource_table));
		res_fp += RS_ENTRY_LEN;
	}
	
	if (DOS_ERR || resource_table[0] == 0)
	{
		dos_close(fh);
		return FALSE;
	}
	
	/* We now hold in resource_table the initial entry for the icon */
	/* Move to the first icon's resource data			*/
	dos_lseek(fh, SEEK_SET, (LONG)(resource_table[4] << shift_count));
	
	dos_read(fh, sizeof(BMP_INFO), ADDR(&binfo));

	while ( !(resolution_ok((WORD)(binfo.height/2))
		&& colors_ok(1 << binfo.bit_count)) && !DOS_ERR )
	{
		if (entry_count-- == 0)
			break;
		dos_lseek(fh, SEEK_SET, res_fp);
		dos_read(fh, RS_SUBITEM_LEN, ADDR(resource_table));
		res_fp += RS_SUBITEM_LEN;
		dos_lseek(fh, SEEK_SET, (LONG)(resource_table[0] << shift_count));
		dos_read(fh, sizeof(BMP_INFO), ADDR(&binfo));
	}
	
	if (entry_count == 0 || DOS_ERR)
	{
		dos_close(fh);
		return FALSE;
	}
						/* Skip RGB-QUADS   */
	dos_lseek(fh, SEEK_CUR, 4 * (1<< binfo.bit_count));
	
	/* The file pointer should now be positioned at the beginning	*/
	/* of the icon's bitmap area.					*/

	return process_icon(fh, &binfo, cicon);
}

/***********************************************************************
*	This routine reads the contents of a Windows 3.0 ICO file and
*	converts it to a GEM MFDB for translation and copying
************************************************************************/

BOOLEAN	load_ico_file(WORD fh, CICON *cicon)
{
	WORD		bytes_read;	/* Return of dos_read()		*/
	WORD		i;
	BOOLEAN		found_entry = FALSE; /* If a Res/Color Match	*/
	ICO_HEADER	ihdr;		/* Header of BMP file		*/
	RES_DESC	idesc;		/* Resource directory entry	*/
	BMP_INFO	binfo;		/* BMP Info Header		*/
	
	
	bytes_read = dos_read(fh, sizeof(ICO_HEADER), ADDR(&ihdr));

	/* Check read success and file type */
	if (bytes_read != sizeof(ICO_HEADER) || ihdr.type != 1)
	{
		dos_close(fh);
		return FALSE;
	}
	

	for (i=0; i<ihdr.count && !found_entry; i++)
	{
		bytes_read = dos_read(fh, sizeof(RES_DESC), ADDR(&idesc));
		if (bytes_read != sizeof(RES_DESC))
		{
			dos_close(fh);
			return FALSE;
		}
		/* See if this descriptor matches our resolution and
		 * color capatility
		 */
		if (resolution_ok(idesc.height) 
		    && colors_ok(idesc.color_count))
			found_entry = TRUE;
	}
	if (!found_entry)
	{
		dos_close(fh);
		return FALSE;
	}
	
	/* Skip to appropriate icon bitmap */
	dos_lseek(fh, SEEK_SET, idesc.dib_offset);
	
	bytes_read = dos_read(fh, sizeof(BMP_INFO), ADDR(&binfo));
	if (bytes_read != sizeof(BMP_INFO))
	{
		dos_close(fh);
		return FALSE;
	}
	
	dos_lseek(fh, SEEK_SET, idesc.dib_offset + sizeof(BMP_INFO) + 
		(4 * idesc.color_count));	/* Skip RGB-QUADS   */
	
	return process_icon(fh, &binfo, cicon);
}
