/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskclrs.c 4.3 92/03/12 13:58:02 rsf Exp $
* $Log:	deskclrs.c $
 * Revision 4.3  92/03/12  13:58:02  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.2  92/02/19  15:55:31  sbc
 * Replace refs to G.a_trees[] with calls to rsrc_gaddr().
 * 
 * Revision 4.1  91/11/07  15:49:37  anderson
 * Just removed unused calls to dos_alloc() for clarity.
 * 
 * Revision 3.1  91/08/19  16:39:16  system
 * ViewMAX 2 sources
 * 
 * Revision 3.13  91/08/14  12:15:48  sbc
 * to fix SPR 806473: instead of gambling on dynamic dos_allocs for
 * Color Schemes dialog listbox, have it use local data. Requires 576 bytes.
 * 
 * Revision 3.12  91/07/26  13:27:23  sbc
 * replace call to ini_open_files() with app_get_fh() or app_getfh_loop().
 * 
 * Revision 3.11  91/07/19  15:41:18  fontes
 *  set_3d_color calls
 * 
 * Revision 3.10  91/07/19  15:06:39  sbc
 * move strings associated with INI parsing to RSC. Remove code by assuming
 * that INI exists.
 * 
 * Revision 3.9  91/06/26  15:12:02  fontes
 * [Color] => [Colors]
 * 
 * Revision 3.8  91/06/18  11:07:29  sbc
 * rm unneeded test for current_color == -1 from cs_init_colors().
 * 
 * Revision 3.7  91/06/14  16:20:47  sbc
 * change so that desktop != dialog background
 * 
 * Revision 3.6  91/06/13  09:21:31  sbc
 * fix so dialog don't crash!
 * 
 * Revision 3.5  91/06/11  14:15:24  sbc
 * change calls to form_do() to be calls to xform_do()
 * 
 * Revision 3.4  91/06/10  16:27:42  sbc
 * changes for new INI file format. Be sure to get new version of
 * VIEWMAX.INI on net in \drdesk.
 * 
 * Revision 3.3  91/06/04  13:03:34  sbc
 * misc housekeeping and other ravings...
 * 
 * Revision 3.2  91/05/31  11:18:40  sbc
 * misc changes associated with rewrites in deskapp.c and inifiles.c
 * 
 * Revision 3.1  91/05/16  14:43:37  fontes
 * Separate branch for Beta bug fixes, separate from split-mode windows
 * 
 * Revision 2.8  91/05/07  12:43:25  whf
 * ColorPrefs dlg bugs: RETURN key and slctn off list
 * 
 * Revision 2.7  91/05/06  09:24:36  whf
 * Now handles missing INI file
 * 
 * Revision 2.6  91/04/30  09:24:02  whf
 * changed separator character from '+' to '@' 
 *   to be consistent with 'Sample VIEWMAX.INI' doc sent by HA when in EDC
 * 
 * Revision 2.5  91/04/29  13:17:51  whf
 * Read color prefs from .INI file
 * section names stored in RSC file
 * 
 * Revision 2.4  91/04/27  10:48:25  fontes
 * Fix name conflict w/"real" ini stuff, move color cat defs to obdefs.h
 * 
 * Revision 2.3  91/04/26  14:41:08  whf
 * handles Color Preferences (hard coded for now)
 * 
 * Revision 2.2  91/04/11  15:25:12  whf
 * display Color Preferences dialog; added plans for finishing module
 * 
 * Revision 2.1  91/04/11  13:49:32  whf
 * Created module
 * 
*****************************************************************************
Date	Who	SPR#	Comments
-------	-------	----	-----------------------------------------------------
910506	WHF		Added better error handling
910427	RSF		Remove name conflict w/"real" .ini stuff.
910410	WHF		Created file
******************************************************************************/

/****************************************************************************
* File:		deskclrs.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*	Provides the routines necessary to set AES colors.
*  
*****************************************************************************/

#include "shell.h"
#include "danutil.h"
#include "exproto.h"
#include "inidefs.h"	/* ini_read() and ini_write() */

extern GLOBES	G;
extern WORD	gl_nplanes;
extern WORD	DOS_ERR ;

/* WHF: move these into EXPROTO.H: */
void	xgrf_color( WORD, WORD, WORD, WORD, WORD );

MLOCAL char cs_fields[CC_MAX][INI_SECTION_LEN] = {0} ;

#define CS_SEPARATOR	'@'
#define	CS_BUFSIZ	512
WORD	cs_currentcolor = -1 ;
WORD	cs_maxcolors = 2;

#define MAX_CS_MAXCOLORS	10
							    /* size in bytes */
MLOCAL char color_list[ sizeof( LIST ) ] ;			    /* 16    */	
MLOCAL char color_item[ MAX_CS_MAXCOLORS ][ sizeof( LISTITEM ) ] ;  /* 10*16 */
MLOCAL char color_name[ MAX_CS_MAXCOLORS ][ INI_SECTION_LEN ] ;     /* 10*40 */

/*----------------------------------------------------------------------*/
MLOCAL void cs__flds_apply( char * buff )
{
WORD	ii = 0;
char *	ptr ;
BYTE	item[ INI_SECTION_LEN ] ;
WORD	fore, back, interior, style ;

    while( 1 ) {
	
	strrev( buff ) ;		/* reverse buffer */
	ptr = strrchr( buff, '=' ) ;	/* find last (first) '=' */
	if ( ptr == NULL )
	    return ;
	*ptr = NULL ;			/* strip this off */
	sscanf( ptr+1, "%s", item ) ;	/* read item name */
	strrev( item ) ;		/* make item forwards */
	strrev( buff ) ;		/* make buff forwards again */
	
	/* find item in cs_fields[] */
	for ( ii = 0; ii < CC_MAX; ii++ )
	    if ( !strcmp( item, cs_fields[ii] ) )	/* found it */
		break ;
	if ( ii == CC_MAX )
	    continue ;			/* field not found */

	sscanf( buff, "%d,%d,%d,%d", &fore, &back, &interior, &style ) ;
	
	xgrf_color( ii, fore, back, interior, style ) ;
    }
    
} /* cs__flds_apply() */

/*----------------------------------------------------------------------
 Init cs_fields[] using strings in viewhelp.rsc 
*/
MLOCAL void cs_init_fields( WORD sHndl )
{
    strcpy( cs_fields[ 8], rsc_get_string( sHndl, SCLRTOP  ) ) ;
    strcpy( cs_fields[ 9], rsc_get_string( sHndl, SCLRSLID ) ) ;
    strcpy( cs_fields[10], rsc_get_string( sHndl, SCLRBKGD ) ) ;
    strcpy( cs_fields[11], rsc_get_string( sHndl, SCLRBUTN ) ) ;
    strcpy( cs_fields[12], rsc_get_string( sHndl, SCLRINFO ) ) ;
    strcpy( cs_fields[13], rsc_get_string( sHndl, SCLRALRT ) ) ;
    strcpy( cs_fields[14], rsc_get_string( sHndl, SCLRUTOP ) ) ;

} /* cs_init_fields() */

/*----------------------------------------------------------------------*/
/*
*  cs__read() - read correct ColorSet into buff.
*/
/* subroutine that reads in the colorset */
MLOCAL void cs__read( WORD idx, char * buff )	
{
char	item[ INI_SECTION_LEN ] ;
long	section_offset ;
long	color_set_offset ;
WORD	fHndl ;
WORD	sHndl ;
WORD	len ;
char *	ptr ;

    /* open VIEWHELP.RSC (contains free strings used in INI) */
    sHndl = app_getfh_loop( OPEN_FILE, -1, READONLY, SPREFILE );
    if ( ! sHndl ) return ;
    
    cs_init_fields( sHndl ) ;
    
    /* open INI file to parse for [Colors] section */
    /* don't need to loop as above since assume diskette is still in */
    fHndl = app_getfh( OPEN_FILE, INIFNVM, READONLY ) ;
    if ( !fHndl ) {
	dos_close( sHndl ) ;
	return ;
    }
    
    section_offset = ini_section_offset( fHndl, 
					rsc_get_string( sHndl, SCOLORS ) );
    if ( section_offset != -1L ) {
	sprintf( item, "%s%d", rsc_get_string( sHndl, SCOLRSET ), idx ) ;
	color_set_offset = ini_item_offset( fHndl, section_offset, item );
    
	/* read this color set description */
	dos_lseek( fHndl, SEEK_SET, color_set_offset ) ;
	len = dos_read( fHndl, CS_BUFSIZ-1, (long)(char far *)buff ) ;
	buff[ len ] = NULL ;		/* mark the end */
	
	ptr = strchr( buff, '\042' ) ;	/* search for first double quote */
	ptr = strchr( ptr+1, '\042' ) ;	/* search for second double quote */
	ptr = strstr( ptr,		/* search for next color set */
			rsc_get_string( sHndl, SCOLRSET ) ) ;
	if ( ptr != NULL )		/* found another ColorSet section */
	    *ptr = NULL ;
	else {				/* look for any other section */
	    ptr = strchr( ptr, '[' ) ;
	    if ( ptr != NULL )		/* and null it out */
		*ptr = NULL ;
	}	
    }
    
    dos_close( fHndl ) ;
    dos_close( sHndl ) ;
        
} /* cs__read() */

/*----------------------------------------------------------------------*/
/* apply default color sets for mono and color displays first, in case	*/
/* choosen set is incomplete.						*/
MLOCAL void cs_docolors( WORD idx )
{
char	buff[CS_BUFSIZ] ;

#if SAVE_CODE_SPACE
    if ( gl_nplanes <= 1 ) {	/* mono display */
	xgrf_color(  8, 1, 0, 2, 5 ) ;		/* SCLRTOP */
	xgrf_color(  9, 1, 0, 2, 2 ) ;		/* SCLRSLID */
	xgrf_color( 10, 4, 0, 2, 4 ) ;		/* SCLRBKGD */
	xgrf_color( 11, 0, 0, 1, 0 ) ;		/* SCLRBUTN */
	xgrf_color( 12, 0, 0, 1, 0 ) ;		/* SCLRINFO */
	xgrf_color( 14, 1, 0, 1, 0 ) ;		/* SCLRUTOP */
    }
    else {			/* color display */
	xgrf_color(  8, 4, 0, 2, 5 ) ;		/* SCLRTOP */
	xgrf_color(  9, 4, 0, 2, 2 ) ;		/* SCLRSLID */
	xgrf_color( 10, 4, 0, 2, 4 ) ;		/* SCLRBKGD */
	xgrf_color( 11, 8, 0, 1, 0 ) ;		/* SCLRBUTN */
	xgrf_color( 12, 8, 0, 2, 4 ) ;		/* SCLRINFO */
	xgrf_color( 14, 5, 0, 2, 2 ) ;		/* SCLRUTOP */
    }
#endif    
    /* range err: force 0 */    
    if ( idx >= cs_maxcolors || idx < 0 ) idx = 0 ;
    
    cs__read( idx, buff ) ;
    
    cs__flds_apply( buff );
    
} /* cs_docolors() */

/*----------------------------------------------------------------------*/
/*
*  cs_init_colors() - inits AES to saved color set preference from INI file.
*/
void cs_init_colors( void )
{
    if ( cs_maxcolors > MAX_CS_MAXCOLORS )
	cs_maxcolors = MAX_CS_MAXCOLORS ;
    
    cs_docolors( cs_currentcolor );
    
    /* Force redraw of entire screen */
    form_dial( FMD_FINISH, 0, 0, 0, 0, 
			    G.g_xdesk, G.g_ydesk, G.g_wdesk, G.g_hdesk );
} /* cs_init_colors() */

/*----------------------------------------------------------------------*/
/*
*  cs__bldclist() - called by dialog to let user choose from a list of
*	available color sets.
*/
MLOCAL void cs__bldclist( FLIST *clrlist, WORD new_color )
{
char	buff[CS_BUFSIZ] ;
char *	colorName ;
WORD	ii;
FLISTITEM *itm;

    /* init list to NULL */
    for( ii=0; ii<cs_maxcolors; ++ii ) {
	
	cs__read( ii, buff ) ;

	/* get name within double quotes, lead with a space */
	colorName = strchr( buff, '"' ) ;
	*colorName = ' ' ;
	*strchr( colorName, '"' ) = NULL ;
	
	/* grab colorset name and insert in list */
	itm = (FLISTITEM *)color_item[ii] ;
	itm->it_ptr = (FBYTE *)color_name[ii] ;

	fstrcpy( (char far *)itm->it_ptr, (char far *)colorName );
	
	itm->flags = SELECTABLE;
	if( ii == new_color )
	    itm->state = SELECTED;
	else itm->state = 0;
	add_to_list( clrlist, clrlist->end, itm );
    }
    
} /* cs_bldclist() */

/*----------------------------------------------------------------------*/
/* Return index in list of current (selected) item */
	MLOCAL WORD
cs__fnditem( void )
{
TREE		tree;
FLISTBOX	*lb;

	rsrc_gaddr( R_TREE, DCOLORPR, &tree ) ;
	lb = (FLISTBOX *)get_data_ptr( tree, CPLIST );
	return( ls_count( lb->items->start, lb->items->cur, TRUE, TRUE ) - 1);
}

/*----------------------------------------------------------------------*/
MLOCAL void cs__setup( WORD new_color )
{
TREE		tree;
FLISTBOX	*lb;

    rsrc_gaddr( R_TREE, DCOLORPR, &tree ) ;
    lb = (FLISTBOX *)get_data_ptr( tree, CPLIST );

    if (NULL == lb->items)
    {
	lb->items = (FLIST *)color_list ;

	ls_init(lb->items);
	cs__bldclist( lb->items, new_color );

	/* Set up ColorPrefs Dialog so that it's objects will have
	*	same colors as desktop objects, to allow a preview
	*	when we redraw the dialog.
	*	Do this once only */		

	set_3d_color( (FDOBJECT*)(tree+CPCLOSE), CC_BUTTON);
	set_3d_color( (FDOBJECT*)(tree+CPDESKTP), CC_DESKTOP);

	(tree+CPNAME)->ob_flags		|= USECOLORCAT ;
	(tree+CPINFO)->ob_flags		|= USECOLORCAT ;
		
	/* set colors */		
	((TEDINFO far *)((tree+CPNAME)->ob_spec))->te_color 
					|= CC_NAME   & 0x000f ;
	((TEDINFO far *)((tree+CPINFO)->ob_spec))->te_color 
					|= CC_INFO   & 0x000f ;
    }
	
    lb_init( tree, CPLIST, FALSE );
    lb->items->cur = get_item( lb->items->start, new_color, TRUE, TRUE );
    
} /* cs__setup() */

/*----------------------------------------------------------------------*/
/* color_prefs(): handles Color Preferences dialog */
void color_prefs( void )
{
TREE	tree;
WORD	start_fld;
WORD	obj, extype;
WORD	xd, yd, wd, hd;
WORD	new_color = cs_currentcolor;
BOOLEAN	done = FALSE;

	cs__setup( new_color );
	rsrc_gaddr( R_TREE, DCOLORPR, &tree ) ;
	form_center(tree, &xd, &yd, &wd, &hd);
	form_dial(FMD_START, 0, 0, 0, 0, xd, yd, wd, hd);
	if( (start_fld = cs__fnditem()) > CPFLAST-CPFIRST )
	     start_fld = CPFLAST;
	else start_fld += CPFIRST;

	while( !done )
	{
	  draw_dial( tree );
#if HELP_ALERTS
	do {
	    obj = xform_do( tree, start_fld ) ;
	    if ( obj == -1 )
		do_help_alert( HCOLORPR ) ;
	} while ( obj == -1 ) ;
#else	
	  obj = xform_do( tree, start_fld);
#endif
	if( SELECTED & (tree+CPOKAY)->ob_state )
	  {
		cs_currentcolor = new_color = cs__fnditem();
		(tree+CPOKAY)->ob_state &= ~SELECTED ;
		(tree+CPCLOSE)->ob_state &= ~SELECTED ;
		done = TRUE;
		break;
	  } else if( SELECTED & (tree+CPCANCEL)->ob_state )
	  {
		(tree+CPCANCEL)->ob_state &= ~SELECTED ;
		done = TRUE;
		break;
	  } else
	  {
		extype = exobj_num( tree, obj);
		switch (extype)
		{
		  case LB_A_SLOT:
#if 000
			start_fld = CPOKAY;
			break;
#endif
		  case SLD_UP:
		  case SLD_DOWN:
			start_fld = obj;
			break;
		} /* end switch(extype) */
	  } /* end if/else/if/else */
	  new_color = cs__fnditem();
	  cs_docolors( new_color );
	} /* end while ! done */

	cs_init_colors() ;

} /* color_prefs() */

/*
*	end deskclrs.c
*/
