/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskdir.c 3.7 92/04/10 13:39:51 sbc Exp $
* $Log:	deskdir.c $
 * Revision 3.7  92/04/10  13:39:51  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 3.6  92/04/03  17:14:31  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 3.5  92/03/13  14:40:38  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 3.4  92/03/12  13:56:09  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 3.3  92/02/19  15:55:12  sbc
 * Replace refs to G.a_trees[] with calls to rsrc_gaddr().
 * 
 * Revision 3.2  92/01/31  16:42:53  sbc
 * save and restore FCB around call to dos_sfirst() .
 * 
 * Revision 3.1  91/08/19  16:37:42  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
-------	-------	----	-------------------------------------------------------
911016  K.H		Changed like_parent and ret_path to use international
			prev_path_ch and next_path_ch functions.
910327	RSF		Allow external access to draw_dial.
******************************************************************************/

#include "shell.h"
#include "list.h"
#include "exobdefs.h"
#include "exproto.h"
#include "viewapps.h"

#define	S_FILL_STYLE		23		/* used in blank_it()	*/
#define	S_FILL_INDEX		24
#define	S_FILL_COLOR		25
#define	SET_WRITING_MODE	32
#define MAX_TWIDTH 45				/* used in blank_it()	*/

extern WORD	DOS_AX;
extern WORD	DOS_ERR;
extern WORD	gl_wchar;
extern WORD	gl_hchar;
extern BOOLEAN	passw_dial_shown;

extern PREFS	prefs;
extern GLOBES	G;

MLOCAL BYTE	ml_files[4], ml_dirs[4];
MLOCAL WORD	ml_dlfi, ml_dlfo ;
MLOCAL WORD	ml_dlpr, ml_havebox;
MLOCAL BYTE	ml_fsrc[13], ml_fdst[13], ml_fstr[13], ml_ftmp[13];

/****************************************************************
 *  DRAW a DIALog box centered on the screen.
 ****************************************************************/
void draw_dial(TREE tree)
{
	WORD		xd, yd, wd, hd;

	form_center(tree, &xd, &yd, &wd, &hd);
	objc_draw(tree, ROOT, MAX_DEPTH, xd, yd, wd, hd);

} /* draw_dial */

/****************************************************************
 *
 ****************************************************************/
void show_hide(WORD fmd, TREE tree)
{
	WORD		xd, yd, wd, hd;

	form_center(tree, &xd, &yd, &wd, &hd);
	form_dial(fmd, 0, 0, 0, 0, xd, yd, wd, hd);
	if (fmd == FMD_START)
	  objc_draw(tree, ROOT, MAX_DEPTH, xd, yd, wd, hd);
}

/****************************************************************
 *
 ****************************************************************/
MLOCAL void do_namecon( void )
{
TREE	tree ;

	rsrc_gaddr( R_TREE, ADCPALER, &tree ) ;
/* BugFix	*/
	graf_mouse(ARROW, 0x0L);
	if (ml_havebox)
	  draw_dial( tree );
	else
	{
	  show_hide(FMD_START, tree );
	  ml_havebox = TRUE;
	}

#if HELP_ALERTS	
	while ( -1 == xform_do( tree, CACOPYNA ) )
	    do_help_alert( HFIEXIST ) ;
#else /* HELPALERTS */
	form_do( tree, CACOPYNA);
#endif /* HELPALERTS */
	if (ml_dlpr) {
	    rsrc_gaddr( R_TREE, ADCOPYDI, &tree ) ;
	    draw_dial( tree );
	}
	graf_mouse(HOURGLASS, 0x0L);

} /* do_namecon */

/****************************************************************
 *  Draw a single field of a dialog box.
 ****************************************************************/
void draw_fld(TREE tree, WORD obj)
{
	GRECT		t;

	if (passw_dial_shown)		/* RSF */
	{
		draw_dial( tree );
		passw_dial_shown = FALSE;
	}
	else
	{
		fmemcpy( (void far *)&t, 
			(void far *)&(tree+obj)->ob_box, 
			sizeof( GRECT ) );
		objc_offset(tree, obj, &t.g_x, &t.g_y);
		objc_draw(tree, obj, MAX_DEPTH, t.g_x, t.g_y, t.g_w, t.g_h);
	}

} /* draw_fld */

/****************************************************************
 *  Add a new directory name to the end of an existing path.
 *  This includes appending a \*.*.
 ****************************************************************/
MLOCAL	void add_path(BYTE * path, BYTE far * new_name)
{
    fstrcpy( (char far *)strchr( path, '*' ), new_name );
    strcat( path, "\\*.*" );	

} /* add_path */

/****************************************************************
 *  Remove the last directory in the path and replace it with
 *  *.*.
 ****************************************************************/
MLOCAL void sub_path( BYTE * path )
{
						/* scan to last slash	 */
						/* and lose rest of line.*/
    *strrchr( path, '\\' ) = '\0';
						/* now skip to previous	*/
						/*   directory in path	*/
    strcpy( strrchr( path, '\\' ), "\\*.*" ) ;
	
} /* sub_path */

/****************************************************************
 *  Add a file name to the end of an existing path.
 ****************************************************************/
void add_fname( BYTE * path, BYTE * new_name)
{
    strcpy( strchr( path, '*' ), new_name ) ;
    
} /* add_fname */

/****************************************************************
 *  Swap in a file name to the end of an existing path+filename.
 *  Returns TRUE iff new_name is different from filename.
 ****************************************************************/
BOOLEAN swp_fname(BYTE *path, BYTE *new_name)
{
BOOLEAN	diff_path ;
char *	ptr ;

	ptr = strrchr( path, '\\' ) ;
	diff_path = ( 0 != strcmp( ptr+1, new_name ) ) ;
	strcpy( ptr+1, new_name ) ;
	
	return diff_path;

} /* swp_fname */

/****************************************************************
 *  Check if path is associated with an open window.
 ****************************************************************/
MLOCAL	WORD fold_wind(BYTE *path)
{
    WORD	i;

    for (i = 0; i < (NUM_WNODES*2); i++)
    {
	if (G.g_wlist[i].w_open && 
	    !fstrcmp(G.g_wlist[i].w_path->p_spec, path))
	    return(TRUE);
    }
    return(FALSE);
    
} /* end fold_wind() */

/****************************************************************
 *  Routine to check that the name we will be adding is like the 
 *  last folder name in the path.
 ****************************************************************/
MLOCAL void like_parent(BYTE *path, BYTE far * new_name)
{
BYTE *	pstart ;
BYTE *	lastfold ;
BYTE *	lastslsh ;
BYTE	tmp[ LEN_ZFNAME ] ;
						/* remember start of path*/
	pstart = path;
						/* scan to lastslsh	*/
	lastslsh = path = strrchr( path, '\\' ) ;

						/* back up to next to 	*/
						/*   last slash if it 	*/
						/*   exists		*/
	path--;
	path = (BYTE *)prev_path_ch((UBYTE *)pstart, (UBYTE *)path);
						/* remember start of 	*/
						/*   last folder name	*/
	if (*path == '\\')
	  lastfold = path + 1;
	else
	  lastfold = 0;

	if (lastfold)
	{
	  *lastslsh = NULL;
	  if( !fstrcmp( (char far *)lastfold, new_name ) )
	    return;
	  *lastslsh = '\\';
	}
	fstrcpy( (char far *)tmp, new_name ) ;
	add_fname( pstart, tmp );

} /* like_parent */

/****************************************************************
 *  See if these two paths represent the same folder.  The first
 *  path ends in \*.*, the second path ends with just the folder.
 *  Disregard the drive portion though.			RSF: 8/91
 ****************************************************************/
MLOCAL	WORD same_fold(BYTE *psrc, BYTE *pdst)
{
	WORD		ret;
	BYTE		*lastslsh;
	BYTE		*s, *d;		/* RSF:: 8/91 new*/
					/* Don't look at drive */
	s = strchr( psrc, '\\' );	/* RSF:: 8/91 NEW */
	d = strchr( pdst, '\\' );	/* RSF:: 8/91 NEW */
	
						/* scan to lastslsh	*/
	lastslsh = strrchr( s, '\\' ) ;	/* RSF:: 8/91 */

						/* null it		*/
	*lastslsh = NULL;
						/* see if they match	*/
	ret = !strcmp(s, d);	/* RSF:: 8/91 change */
						/* restore it		*/
	*lastslsh = '\\';
						/* return if same	*/
	return( ret );
}

/****************************************************************
 *  Remove the file name from the end of a path and append on
 *  an \*.*
 ****************************************************************/
void del_fname( BYTE far * pstr)
{
    fstrcpy( fstrrchr( pstr, '\\' ), "\\*.*" ) ;

} /* sub_path */

/****************************************************************
 *  Parse to find the filename part of a path and return a copy
 *  of it in a form ready to be placed in a dialog box.
 ****************************************************************/
MLOCAL	void get_fname(BYTE *pstr, BYTE *newstr)
{
    strcpy( ml_ftmp, 1 + strrchr( pstr, '\\' ) ) ;

    fmt_str( ml_ftmp, newstr ) ;

} /* get_fname */

/****************************************************************
 *
 ****************************************************************/
WORD d_errmsg(void)
{
	if (DOS_ERR)
	{
	  form_error(DOS_AX);
	  return(FALSE);
	}
	return(TRUE);
}

/****************************************************************
 *  Directory routine to DO File DELeting.
 ****************************************************************/
MLOCAL	WORD d_dofdel(BYTE *ppath)
{ 
	dos_delete( (LONG)(char far *)ppath ) ;
	return( d_errmsg() );

} /* d_dofdel */

/****************************************************************
 *  Directory routine to DO File COPYing.
 ****************************************************************/
MLOCAL	WORD d_dofcopy(psrc_file, pdst_file, time, date, attr)
BYTE	*psrc_file, *pdst_file;
WORD	time, date, attr;
{
	TREE		tree;
	WORD		srcfh, dstfh;
	UWORD		amntrd, amntwr;
	WORD		copy, cont, more, samedir, ob;

	copy = TRUE;
						/* open the source file	*/
	srcfh = dos_open( (LONG)(char far *)psrc_file, 0);
	more = d_errmsg();
	if (!more)
	  return(more);
	 					/* open the dest file	*/
	cont = TRUE;
	rsrc_gaddr( R_TREE, ADCPALER, &tree ) ;
	while (cont)
	{
	  copy = FALSE;
	  more = TRUE;
	  dstfh = dos_open( (LONG)(char far *)pdst_file, 0);
					     	/* handle dos error	*/
	  if (DOS_ERR)
	  {
	    if (DOS_AX == E_FILENOTFND)
	      copy = TRUE;
	    else
	      more = d_errmsg();
	    cont = FALSE;
	  }
	  else
	  {
						/* dest file already	*/
						/*   exists		*/ 
	    dos_close(dstfh);
						/* get the filenames 	*/
						/*   from the pathnames	*/
	    get_fname(psrc_file, ml_fsrc);
						/* if same dir, then	*/
						/*   don't prefill the	*/
						/*   new name string	*/
	    samedir = !strcmp(psrc_file, pdst_file);
	    if (samedir)
	      ml_fdst[0] = NULL;
	    else
	      get_fname(pdst_file, ml_fdst);
						/* put in filenames	*/
						/*   in dialog		*/
	    tedinfo_set( tree, CACURRNA, (BYTE far *)ml_fsrc);
	    tedinfo_set( tree, CACOPYNA, (BYTE far *)ml_fdst);
						/* show dialog		*/
	    if ( prefs.confirm_ovrwrite || samedir )
	    {
	      do_namecon();
						/* if okay then if its	*/
						/*   the same name then	*/
						/*   overwrite else get	*/
						/*   new name and go	*/
						/*   around to check it	*/


	      ob = radio_get( tree, CASTOP, 3 ) + CASTOP;
	      (tree+ob)->ob_state = NORMAL ;
	      if (ob == CASTOP)
	        copy = more = FALSE;
	      else if (ob == CACNCL)
	        copy = FALSE;
	      else
	        copy = TRUE;
	    }
	    else
	      copy = TRUE;
/* */
	    if (copy)
	    {
	      cont = FALSE;
	      tedinfo_get( tree, CACOPYNA, (BYTE far *)ml_fdst);
	      unfmt_str( ml_fdst, ml_fstr);
	      if ( ml_fstr[0] == NULL )
	      {
		copy = FALSE;
	        dos_close(srcfh);
	      }
	      else
	      {
		if( swp_fname(pdst_file, ml_fstr) )
		  cont = TRUE;			/* 910509 WHF		*/
						/* if swapped name is	*/
						/*   different, check	*/
						/*   again for conflict */
	      }
	    }
	    else
	    {
	      dos_close(srcfh);
	      cont = copy = FALSE;
	    }
	  } /* else */
	} /* while cont */

	if ( copy && more )
	  dstfh = dos_create( (LONG)(char far *)pdst_file, attr);

	amntrd = copy;
	while( amntrd && more )
	{
	  more = d_errmsg();
	  if (more)
	  {
	    amntrd = dos_read(srcfh, G.g_xlen, (LONG)G.g_xbuf );
	    more = d_errmsg();
	    if (more)
	    {
	      if (amntrd)
	      {
	        amntwr = dos_write(dstfh, amntrd, (LONG)G.g_xbuf );
		more = d_errmsg();
	        if (more)
	        {
	          if (amntrd != amntwr)
	          {
						/* disk full		*/
		    graf_mouse(ARROW, 0x0L);
		    alert( 1, ERDISKFU );
		    graf_mouse(HOURGLASS, 0x0L);
	            more = FALSE;
		    dos_close(srcfh);
		    dos_close(dstfh);
		    dos_delete( (LONG)(char far *)pdst_file );
		  } /* if */
	        } /* if more */
	      } /* if amntrd */
	    } /* if more */
	  } /* if more */
	} /* while */
	if (copy && more)
	{
	  dos_setdt(dstfh, time, date);
	  more = d_errmsg();
	  dos_close(srcfh);
	  dos_close(dstfh);
	}
/*	graf_mouse(ARROW, 0x0L);*/
	return(more);
} /* d_dofcopy */

/****************************************************************
 *  Directory routine to DO an operation on an entire sub-directory.
 ****************************************************************/
WORD d_doop(	WORD op, 
		TREE tree, 
		WORD obj, 
		BYTE * psrc_path, 
		BYTE * pdst_path, 
		WORD * pfcnt,
		WORD * pdcnt, 
		WORD flag )
{			       
WORD		cont, skip, more, level, attr, sfirst_done;
FCB far *	pOldFCB ;
	
	attr = 0x16;	/* Look for hidden/system & directories */
						/* start recursion at	*/
						/*   level 0		*/
	level = 0;
	
	pOldFCB = dos_gdta() ;			/* set up initial DTA	*/
	dos_sdta( (FCB far *)&G.g_fcbstk[level] );

	dos_sfirst( (char far *)psrc_path, attr );

	cont = more = TRUE;
	while (cont && more)
	{
	  skip = sfirst_done = FALSE;
	  if (DOS_ERR)
	  {
				  		/* no more files error	*/
	    if ( (DOS_AX == E_NOFILES) || (DOS_AX == E_FILENOTFND) )
	    {
	      switch(op)
	      {
	        case OP_COUNT:
			G.g_ndirs++;
			break;
	        case OP_DELETE:
			if (fold_wind(psrc_path))
			{
			  DOS_ERR = TRUE;	/* trying to delete	*/
			  DOS_AX = 16;		/* active directory	*/
			}
			else
			{
			  *( strchr( psrc_path, '*' ) - 1 ) = '\0' ;
			  dos_rmdir( (LONG)(char far *)psrc_path );
			}
			more = d_errmsg();
			strcat( psrc_path, "\\*.*" );
			break;
	        case OP_COPY:
			break;
	      }
	      if (tree)
	      {
		*pdcnt -= 1 ;
		sprintf( ml_dirs, "%d", *pdcnt );
	        tedinfo_set(tree, ml_dlfo, (BYTE far *)ml_dirs);
		draw_fld(tree, ml_dlfo);	/* RSF */
	      }
	      skip = TRUE;
	      level--;
	      if (level < 0)
	        cont = FALSE;
	      else
	      {
	        sub_path(psrc_path);
		if (op == OP_COPY)
		  sub_path(pdst_path);
	        dos_sdta( (FCB far *)&G.g_fcbstk[level] ) ;
	      }
	    } /* if no more files */
	    else
	      more = d_errmsg();
	  }
	  if ( !skip && more )
	  {
	    if ( G.g_fcbstk[level].fcb_attr & F_SUBDIR )
	    {				  	/* step down 1 level	*/
	      if ( (G.g_fcbstk[level].fcb_name[0] != '.') &&
		   (level < (MAX_LEVEL-1)) )
	      {
	      					/* change path name	*/
		add_path( psrc_path, 
			    (char far *)G.g_fcbstk[level].fcb_name);
		if (op == OP_COPY)
		{
		  add_fname( pdst_path, G.g_fcbstk[level].fcb_name );
		  dos_mkdir( (LONG)(char far *)pdst_path );
	          if ( (DOS_ERR) && (DOS_AX != E_NOACCESS) )
		    more = d_errmsg();
		  strcat( pdst_path, "\\*.*" );
		}
		level++;
		dos_sdta( (FCB far *)&G.g_fcbstk[level] );
		if (more){
		  dos_sfirst( (char far *)psrc_path, attr );
		  sfirst_done=TRUE;	/* Suppress the following snext */
		}
	      } /* if not a dir */
	    } /* if */
	    else				 
	    {
	      if (op)
		add_fname( psrc_path, G.g_fcbstk[level].fcb_name );
	      switch(op)
	      {
		case OP_COUNT:
			G.g_nfiles++;
			G.g_size += G.g_fcbstk[level].fcb_size;
			break;
		case OP_DELETE:
			more = d_dofdel(psrc_path);
			break;
		case OP_COPY:
			add_fname( pdst_path, G.g_fcbstk[level].fcb_name );
			more = d_dofcopy(psrc_path, pdst_path,
				G.g_fcbstk[level].fcb_time, 
				G.g_fcbstk[level].fcb_date, 
				G.g_fcbstk[level].fcb_attr);
			del_fname( (char far *)pdst_path );
			break;
	      }
	      if (op)
	        del_fname( (char far *)psrc_path );
	      if (tree)
	      {
	        *pfcnt -= 1;
		sprintf( ml_files, "%d", *pfcnt );
	        tedinfo_set(tree, ml_dlfi, (BYTE far *)ml_files);
		draw_fld(tree, ml_dlfi);	/* RSF */
	      }
	    }
	  }
	  if (cont && !sfirst_done )
	    dos_snext();
	}
	if (op == OP_DELETE && !flag)
	  blank_it(obj);
      
      dos_sdta( pOldFCB ) ;
      return(more);
      
} /* d_doop */

/****************************************************************
 *  Return pointer to next folder in path.  Start at the current
 *  position of the ptr.  Assume path will eventually end with \*.*
 ****************************************************************/
MLOCAL	BYTE *ret_path(REG BYTE *pcurr)
{
					/* find next level		*/
	pcurr = (BYTE *)next_path_ch((UBYTE *)pcurr) + 1;
					/* find end of curr level	*/
	*(next_path_ch((UBYTE *)pcurr)) = NULL;
	return(pcurr);
} /* ret_path */

/****************************************************************
 *  Check to see if source is a parent of the destination.
 *  Return TRUE if all ok else FALSE.  Must assume that src and 
 *  dst paths both end with "\*.*".
 ****************************************************************/
WORD par_chk( BYTE far * psrc_path, FNODE far * pflist, BYTE * pdst_path )
{
REG BYTE	*tsrc, *tdst;
WORD		same;
/* REG FNODE	*pf; */
FNODE far *	pf ;

	if (psrc_path[0] != pdst_path[0])		/* check drives	*/
	  return(TRUE);

	tsrc = G.g_srcpth;
	tdst = G.g_dstpth;
	same = TRUE;
	do
	{
							/* new copies	*/
	  fstrcpy( (char far *)G.g_srcpth, psrc_path );
	  strcpy( G.g_dstpth, pdst_path );
							/* get next paths*/
	  tsrc = ret_path(tsrc);
	  tdst = ret_path(tdst);
	  if ( strcmp(tsrc, "*.*") )
	  {
	    if ( strcmp(tdst, "*.*") )
	      same = strcmp(tdst, tsrc);
	    else
	      same = FALSE;
	  }
	  else
	  {
						/* check to same level	*/
	    if ( !strcmp(tdst, "*.*") )
	      same = FALSE;
	    else
	    {
						/* walk file list	*/
	      for(pf=pflist; pf != (FNODE far *)0; pf=pf->f_next)
	      {
						/* exit if same subdir	*/
	        if ( (pf->f_obid != NIL) &&
		     (G.g_screen[pf->f_obid].ob_state & SELECTED) &&
		     (pf->f_attr & F_SUBDIR) &&
	             !(pf->f_attr & F_FAKEFOLD) &&
		     (!fstrcmp(pf->f_name, (char far *)tdst)) )
	        {
						/* INVALID	*/
		  alert( 1, ERBADCOP );
	 	  return(FALSE);
	        }
	      }
	      same = FALSE;			/* ALL OK		*/
	    }
	  }
	} while(same);
	return(TRUE);
} /* par_chk */

/****************************************************************
 *  DIRectory routine that does an OPeration on all the selected
 *  files and folders in the source path.  The selected files and
 *  folders are marked in the source file list.
 ****************************************************************/
WORD dir_op( WORD op, BYTE far * psrc_path, FNODE far * pflist, BYTE * pdst_path,
		WORD * pfcnt, WORD * pdcnt, LONG * psize, 
		    WORD dulx, WORD duly, WORD from_disk, WORD src_ob )
{
TREE		tree			= (TREE)NULL ;
TREE		namecon_tree ;
FNODE far *	pf ;
FNODE far *	realnext		= (FNODE far *)NULL ;
WORD		cont			= TRUE ;
BYTE *		pglsrc			= G.g_srcpth;
BYTE *		pgldst			= G.g_dstpth;
WORD		okobj, canobj;
BYTE		tmp[ LEN_ZFNAME ] ;
LONG		lavail;
#if HELP_ALERTS
WORD		help_alert ;
#endif /* HELPALERTS */

	rsrc_gaddr( R_TREE, ADCPALER, &namecon_tree ) ;
	graf_mouse(HOURGLASS, 0x0L);
	ml_havebox = FALSE;
	switch(op)
	{
	  case OP_COUNT:
		G.g_nfiles = 0x0L;
		G.g_ndirs = 0x0L;
		G.g_size = 0x0L;
		break;
	  case OP_DELETE:
	  	ml_dlpr = prefs.confirm_delete ;
		if (ml_dlpr)
		{
		  rsrc_gaddr( R_TREE, ADDELEDI, &tree ) ;
#if HELP_ALERTS
		  help_alert = HDELETE ;
#endif /* HELPALERTS */		
		  ml_dlfi = DDFILES;
		  ml_dlfo = DDFOLDS;
		  okobj = DDOK;
		  canobj = DDCNCL;
		}
	 	break;
	  case OP_COPY:
		lavail = dos_avail();
		G.g_xlen = (lavail > 0x0000fff0L) ? 0xfff0 : LOWORD(lavail);
		G.g_xlen -= 0x0200;
		G.g_xbuf = (BYTE far *)dos_alloc( MAKELONG( 0, G.g_xlen) );

		ml_dlpr = prefs.confirm_copies;
		if (ml_dlpr)
		{
		  rsrc_gaddr( R_TREE, ADCOPYDI, &tree ) ;
#if HELP_ALERTS
		  help_alert = HCOPYFOL ;
#endif /* HELPALERTS */		
	 	  ml_dlfi = CDFILES;
		  ml_dlfo = CDFOLDS;
		  okobj = CDOK;
		  canobj = CDCNCL;
		}
	 	break;
	} /* switch */

	if ( tree != (TREE)NULL )
	{
	  sprintf( ml_files, "%d", *pfcnt);
	  tedinfo_set( tree, ml_dlfi, (BYTE far *)ml_files);
	  sprintf( ml_dirs, "%d", *pdcnt ) ;
	  tedinfo_set( tree, ml_dlfo, (BYTE far *)ml_dirs);
	  ml_havebox = TRUE;
	  show_hide(FMD_START, tree);
	  graf_mouse(ARROW, 0x0L);
#if HELP_ALERTS
	  while ( -1 == xform_do( tree, okobj ) )
	    do_help_alert( help_alert ) ;
#else /* HELPALERTS */
	  form_do( tree, okobj ) ;
#endif /* HELPALERTS */
	  graf_mouse(HOURGLASS, 0x0L);
 	  cont = inf_what( tree, okobj, canobj);
	}

	for (pf = pflist; cont && pf != (FNODE far *)0; 
				    pf = realnext != (FNODE far *)0 ?
						realnext : pf->f_next)
	{
	  if ( (pf->f_obid != NIL) &&
	       (G.g_screen[pf->f_obid].ob_state & SELECTED) &&
	       !(pf->f_attr & F_FAKEFOLD) )
	  {
	    fstrcpy( (char far *)pglsrc, psrc_path );
	    if ( op == OP_COPY )
	    {
	      strcpy( pgldst, pdst_path );
	      if ( !ml_dlpr )		/* show the moving icon! */
	        move_icon( from_disk ? src_ob : pf->f_obid, dulx, duly);

	    } /* if OP_COPY */
	    if (pf->f_attr & F_SUBDIR)
	    {			   
	      add_path(pglsrc, pf->f_name);
	      if (op == OP_COPY)
	      {
		like_parent(pgldst, pf->f_name);
		dos_mkdir( (LONG)(char far *)pgldst );
		while (DOS_ERR && cont)
		{
						/* see if dest folder	*/
						/*   already exists	*/ 
	    	  if (DOS_AX == E_NOACCESS)
		  {
		    if ( same_fold(pglsrc, pgldst) )
		    {
						/* get the folder name 	*/
						/*   from the pathnames	*/
		      fstrcpy( (char far *)tmp, pf->f_name ) ;	
		      fmt_str( tmp, ml_fsrc);
		      ml_fdst[0] = NULL;
						/* put in folder name	*/
						/*   in dialog		*/
		      tedinfo_set( namecon_tree, CACURRNA, (BYTE far *)ml_fsrc);
		      tedinfo_set( namecon_tree, CACOPYNA, (BYTE far *)ml_fdst);
						/* show dialog		*/
		      do_namecon();
						/* if okay then make	*/
						/*   dir or try again	*/
						/*   until we succeed or*/
						/*   cancel is hit	*/
		      cont = inf_what( namecon_tree, CAOK, CACNCL);

		      if (cont)
		      { 
			tedinfo_get( namecon_tree, CACOPYNA, (BYTE far *)ml_fdst );
			unfmt_str( ml_fdst, ml_fstr);
			del_fname( (char far *)pgldst );
			if (ml_fstr[0] != NULL)
			{
			  add_fname( pgldst, ml_fstr );
			  dos_mkdir( (LONG)(char far *)pgldst );
		 	} /* if */
			else
			  cont = FALSE;
		      } /* if cont */
		    } /* if */
		    else
		      DOS_ERR = FALSE;
		  } /* if NOACCESS */
		  else
		    cont = FALSE;
		} /* while */
		strcat( pgldst, "\\*.*" );
	      } /* if: copy operation */
	      if (cont)
	      {
		/* pf can change in d_doop() so make sure we keep going with */
		/* the REAL next fnode..... */
		realnext = pf->f_next;
		cont = d_doop(op, tree, pf->f_obid, pglsrc, pgldst,
			      pfcnt, pdcnt, ml_dlpr);
	      }
	    } /* if SUBDIR */
	    else
	    {
	      if (op) {
		fstrcpy( (char far *)tmp, pf->f_name ) ;
		add_fname( pglsrc, tmp );
	    }
	      switch(op)
	      {
		    case OP_COUNT:
			realnext = (FNODE far *)0 ;
			G.g_nfiles++;
			G.g_size += pf->f_size;
			break;
		    case OP_DELETE:
			realnext = pf->f_next;
			cont = d_dofdel(pglsrc);
			if (!ml_dlpr)
			  blank_it(pf->f_obid);
			break;
		    case OP_COPY:
			realnext = pf->f_next;
			add_fname( pgldst, tmp );
			cont = d_dofcopy(pglsrc, pgldst, pf->f_time,
					 pf->f_date, pf->f_attr);
			del_fname( (char far *)pgldst );
			break;
	      }
	      if (op)
		del_fname( psrc_path );
	      if ( tree != (TREE)NULL )
	      {
		*pfcnt -= 1;
		sprintf( ml_files, "%d", *pfcnt);
		tedinfo_set( tree, ml_dlfi, (BYTE far *)ml_files);
		draw_fld( tree, ml_dlfi);	/* RSF */
	      } /* if: tree */
	    } /* else: not SUBDIR */
	  } /* if: found selected item */
	  else realnext = (FNODE far *)0 ;
	} /* for: each fnode in the given path spec */

	switch(op)
	{
	  case OP_COUNT:
		*pfcnt = (WORD)G.g_nfiles;
		*pdcnt = (WORD)G.g_ndirs;
		*psize = G.g_size;
	 	break;
	  case OP_DELETE:
	 	break;
	  case OP_COPY:
		dos_free( (LONG)G.g_xbuf );
	 	break;
	} /* switch */
	if (ml_havebox)
	  show_hide(FMD_FINISH, namecon_tree );
	graf_mouse(HOURGLASS, 0x0L);
	return(TRUE);
} /* dir_op */

/****************************************************************
 *
 ****************************************************************/
MLOCAL	void blank_it( WORD obid )
{
/* blit white over just-deleted icon					*/
	WORD		blt_x, blt_y, blt_w, blt_h, pxy[4];
	GRECT		clipr;
	ICONBLK far *	piblk;
	FDB		dst;
	WNODE far *	pw ;

	graf_mouse(M_OFF, 0x0L);
	wind_get(G.g_wlastsel, WF_WXYWH, &clipr.g_x, &clipr.g_y,
		 &clipr.g_w, &clipr.g_h);
	gsx_sclip(&clipr);
	objc_offset( (DOBJECT far *)G.g_screen, obid, &blt_x, &blt_y);
	pw = win_find( G.g_cwin ) ;
	if ( !(pw->w_type & TREEWIN) && (pw->w_view == V_ICON) )
	{
	  piblk = get_spec(G.g_screen, obid);
	  blt_x += piblk->ib_xtext;
	  blt_y += piblk->ib_yicon;
	  blt_w = piblk->ib_wtext;
	  blt_h = piblk->ib_hicon + piblk->ib_htext;
	} /* if V_ICON */
	else					/* view is V_TEXT	*/
	{
	  blt_w = gl_wchar * MAX_TWIDTH;
	  blt_h = gl_hchar + 1;
	} /* else */
	gsx_1code(SET_WRITING_MODE, MD_REPLACE);
	gsx_1code(S_FILL_STYLE, FIS_SOLID);
	gsx_1code(S_FILL_INDEX, IP_SOLID);
	gsx_1code(S_FILL_COLOR, WHITE);
	gsx_fix(&dst, 0x0L, 0, 0);
	pxy[0] = blt_x;
	pxy[1] = blt_y;
	pxy[2] = blt_x + blt_w - 1;
	pxy[3] = blt_y + blt_h - 1;
	vr_recfl( pxy, (WORD *)&dst );
	gsx_1code(S_FILL_COLOR, BLACK);
	gsx_1code(SET_WRITING_MODE, MD_XOR);
	gsx_attr(FALSE, MD_XOR, BLACK);
	graf_mouse(M_ON, 0x0L);
} /* blank_it */

/****************************************************************
 *
 ****************************************************************/
MLOCAL	void move_icon(WORD obj, WORD dulx, WORD duly)
{
/* animate an icon moving from its place on the desktop to dulx,duly	*/
	WORD		sulx, suly, w, h;
	WNODE far *	pw ;

	objc_offset( (DOBJECT far *)G.g_screen, obj, &sulx, &suly);
	pw = win_find( G.g_cwin ) ;
	if ( !(pw->w_type & TREEWIN) && (pw->w_view == V_ICON) )
	{
	  w = G.g_wicon;
	  h = G.g_hicon;
	} /* if V_ICON */
	else					/* view must be V_TEXT	*/
	{
	  w = gl_wchar * MAX_TWIDTH;
	  h = gl_hchar;
	} /* else */
	graf_mbox(w, h, sulx, suly, dulx, duly);
} /* move_icon */


/*
 *	EOF:	deskdir.c
 */
