/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskfun.c 4.9 92/04/06 09:45:46 Fontes Stable $
* $Log:	deskfun.c $
 * Revision 4.9  92/04/06  09:45:46  Fontes
 * Initial cut to extract/display Windows exe embedded icons.
 * 
 * Revision 4.8  92/04/03  17:10:50  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.7  92/03/26  14:44:10  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.6  92/03/13  14:40:57  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.5  92/03/12  13:55:50  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.4  92/02/27  09:40:49  sbc
 * Allow assignment of icon to ordinary FNODE.
 * 
 * Revision 4.3  92/02/19  15:55:06  sbc
 * Replace refs to G.a_trees[] with calls to rsrc_gaddr().
 * 
 * Revision 4.2  92/02/05  18:01:54  anderson
 * Removed unnecessary and expensive calls to do_chkall().  Replaced one with
 * simpler fun_rebld().
 * 
 * Revision 4.1  91/12/20  13:48:55  anderson
 * ViewMAX 3 baseline.  Lots of window redraw cleanup.  Subroutinized the
 * guts of fun_rebld() so that the View:Refresh function could rebuild just a
 * single window.  Also, fun_drag() only needs to update windows of the same
 * drive as the copy's destination, not the copy's source.
 * 
 * Revision 3.1  91/08/19  16:37:35  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
911016  K.H		Add supporting double byte character set. (#if DBCS)
*****************************************************************************/

#include "shell.h"
#include "exproto.h"
#include "viewapps.h"

GLOBAL WORD	whnorebld ;		/* don't do anything that will cause */

extern WORD	DOS_ERR;
extern WORD	gl_apid;

extern GLOBES	G;

extern char	start_path[ 65 ];	/* Path we ran from  */
extern BYTE	gl_lngstr[];
extern BYTE	SeenEROBJMIS ;

/*----------------------------------------------------------------------*/
/* reads alerts and free strings from RSC file. Assumes RSC file has	*/
/* been opened.								*/
BYTE * rsc_get_string( WORD fHndl, WORD string_num )
{
    RSHDR	rsc_hdr;
    WORD	len ;    
    long	offset ;
    BYTE *	string		= gl_lngstr ;

    string[0] = '\0' ;
	
    /* read the file header */
    dos_lseek( fHndl, SEEK_SET, 0L ) ;
    len = dos_read( fHndl, sizeof( RSHDR ), (long)(void far *)&rsc_hdr ) ;
    
    if ( len == sizeof( RSHDR ) )
    {
	/* check the number of strings */
	if ( rsc_hdr.rsh_nstring > string_num )
	{
	    /* go to table of string offsets */
	    offset = rsc_hdr.rsh_frstr + (string_num * sizeof( long )) ;
	    dos_lseek( fHndl, SEEK_SET, offset ) ;

	    /* get string offset */	
	    dos_read( fHndl, sizeof(long), (long)(long far *)&offset ) ;
	    dos_lseek( fHndl, SEEK_SET, offset ) ;
	    
	    /* read string */
	    dos_read( fHndl, 256, (long)(char far *)string ) ;
	}
    }
    
    return string ;
	
} /* rsc_get_string() */

/*----------------------------------------------------------------------*/
#define FOUND		1		/* found the alert		*/
#define NOT_FOUND	0		/* didn't find the alert	*/
#define CHANGED_DISKS	-1		/* floppy-based: found it,	*/
					/* but had to change disks	*/
/*----------------------------------------------------------------------*/
/* Reads alert strings from RSC file.					*/
/* For floppy case where VIEWHELP.RSC is on a diskette not currently in	*/
/* the A drive, this will loop, requesting the user to insert the	*/
/* "ViewMAX" diskette.  Ensuing code makes some big assumptions, and	*/
/* essentially this is NOT fool-proof.  Problems will occur if the	*/
/* user has chosen [Cancel] but has also removed the original disk and	*/
/* the requested functions needs something on the disk. Also if the	*/
/* user chooses [Cancel] they don't see the error message!		*/
MLOCAL WORD get_alert_string( char * rname, WORD rscID,
					WORD alert_num, BYTE * alert_str )
{
WORD	fHndl			= 0 ;
BOOLEAN	changed_disks		= FALSE ;
char	fname[ LEN_ZPATH ] ;

    sprintf( fname, "%s%s", start_path, rname ) ;
    
    /* open the alert text file */
    while ( ! fHndl ) {
	fHndl = dos_open( (long)(char far *)fname, 0 ) ;
	if ( DOS_ERR ) {
	    fHndl = 0 ;
	    if ( start_path[0] != 'A' )	/* loop for floppy case only */
		return NOT_FOUND ;	
	    /*	v_sound( TRUE, 440, 2 ); */
	    changed_disks = TRUE ;
	    if ( 2 == in_mem_alert_s( 0x0201, ERNOINF, ini_str( rscID ) ) )
		return NOT_FOUND ;	/* user choose to cancel */
	}
    }

    strcpy( alert_str, rsc_get_string( fHndl, alert_num ) ) ;
    
    dos_close( fHndl ) ;

    if ( alert_str[0] == '\0' ) {	/* not found: invalid alert_num */
/*	v_sound( TRUE, 440, 2 ); */
	return NOT_FOUND ;
       }
    
    return( changed_disks ? CHANGED_DISKS : FOUND ) ;
    
} /* get_alert_string() */

/*----------------------------------------------------------------------------
*	Routine to transfer a string that requires integrated variables
*	that are merged in.  The resultant alert is then displayed;
*/
WORD alert( WORD defbut, WORD alert_num )
{
WORD	ret, foundString ;
char	tmp[256] ;

    if ( alert_num == EROBJMIS ) {
	if ( SeenEROBJMIS != FALSE )
	    return 0 ;		/* already have seen this alert */
	else 
	    SeenEROBJMIS = G.g_cwin ;
    }
    foundString = get_alert_string( "VIEWHELP.RSC", SERRFILE, alert_num, tmp);
    if ( ! foundString )
	return FALSE ;
    
    ret = form_alert( defbut, (long)(char far *)tmp ) ;
    
    if ( foundString == CHANGED_DISKS ) {
	alert( 0x0101, ERPRDISK ) ;
    }

    return ret ;
    
} /* alert() */

/*----------------------------------------------------------------------------
*	Routine to transfer a string that requires integrated variables
*	that are merged in.  The resultant alert is then displayed;
*/
WORD alert_s( WORD defbut, WORD alert_num, BYTE * s )
{
WORD	ret, foundString ;
char	tmp[256] ;

    foundString = get_alert_string( "VIEWHELP.RSC", SERRFILE, alert_num, tmp);
    if ( ! foundString )
	return FALSE ;
    
    sprintf( G.g_2text, tmp, s ) ;
    ret = form_alert( defbut, (long)(char far *)G.g_2text ) ;
    
    if ( foundString == CHANGED_DISKS ) {
	alert( 0x0101, ERPRDISK ) ;
    }

    return ret ;
    
} /* alert_s() */

/*----------------------------------------------------------------------------
*	Routine to transfer a string that requires integrated variables
*	that are merged in.  The resultant alert is then displayed;
*/
WORD alert_sd( WORD defbut, WORD alert_num, BYTE * s, WORD d )
{
WORD	ret, foundString ;
char	tmp[256] ;

    foundString = get_alert_string( "VIEWHELP.RSC", SERRFILE, 
						alert_num, G.g_2text ) ;
    if ( ! foundString )
	return FALSE ;
    
    sprintf( tmp, G.g_2text, s, d ) ;
    ret = form_alert( defbut, (long)(char far *)tmp ) ;
    
    if ( foundString == CHANGED_DISKS ) {
	alert( 0x0101, ERPRDISK ) ;
    }

    return ret ;
    
} /* alert_sd() */

/*----------------------------------------------------------------------------
*	Same as alert_s(), but uses an alert in VIEWMAX.RSC, not VIEWHELP.RSC
*/
WORD in_mem_alert_s( WORD defbut, WORD alert_num, BYTE * s )
{
char	tmp[40] ;

    strcpy( tmp, s ) ;	/* copy s into tmp since it's probably gl_lngstr[] 
			and ini_str() will overwrite gl_lngstr[] */
    sprintf( G.g_2text, ini_str( alert_num ), tmp ) ;
    return( form_alert( defbut, (long)(char far *)G.g_2text ) );
    
} /* in_mem_alert_s() */

#if HELP_ALERTS
/*----------------------------------------------------------------------*/
void do_help_alert( short alert_num )
{
WORD	foundString ;
char	tmp[256] ;

    foundString = get_alert_string( "VIEWHELP.RSC", SHLPFILE, alert_num, tmp);
    if ( ! foundString )
	return ;
    
    form_alert( 1, (long)(char far *)tmp ) ;
    
    if ( foundString == CHANGED_DISKS ) {
	alert( 0x0101, ERPRDISK ) ;
    }

} /* do_help_alert() */
#endif /* HELP_ALERTS */

/****************************************************************
 * (hca: bug fix) 
 * MUST keep DESKTOP messages internal to DESKTOP -- no AES call.
 * Going through the AES screws up redrawing of desktop windows
 * in do_type()'s subroutines (i.e. Show Contents)
 ****************************************************************/
void fun_msg(WORD type, WORD w3, WORD w4, WORD w5, WORD w6, WORD w7)
{
	disable_cursor();	/* disable keyboard cursor */
	G.g_rmsg[0] = type;
	G.g_rmsg[1] = gl_apid;
	G.g_rmsg[2] = 0;
	G.g_rmsg[3] = w3;
	G.g_rmsg[4] = w4;
	G.g_rmsg[5] = w5;
	G.g_rmsg[6] = w6;
	G.g_rmsg[7] = w7;
	if ( win_find( w3 ) )
	    hndl_msg();
	else
	    handle_message( G.g_rmsg, w3 ) ;
	enable_cursor();	/* Enable keyboard cursor */
} /* fun_msg() */

#if 0
/****************************************************************
 * (hca: keep this version around in case some redraw message
 * really does need to go through the AES first) 
 ****************************************************************/
void fun_aesmsg(WORD type, WORD w3, WORD w4, WORD w5, WORD w6, WORD w7)
{

	disable_cursor();	/* disable keyboard cursor */
	G.g_rmsg[0] = type;
	G.g_rmsg[1] = gl_apid;
	G.g_rmsg[2] = 0;
	G.g_rmsg[3] = w3;
	G.g_rmsg[4] = w4;
	G.g_rmsg[5] = w5;
	G.g_rmsg[6] = w6;
	G.g_rmsg[7] = w7;
	if( type != WM_REDRAW )
		hndl_msg();
	else	appl_write( gl_apid, 16, (LONG)((BYTE far *)(&(G.g_rmsg))) );
	enable_cursor();	/* Enable keyboard cursor */
} /* fun_aesmsg() */
#endif /* 0 */

/****************************************************************
 *  Rebuild the contents of a single window.
 ****************************************************************/
void rebld_one_win( WNODE far * pw )
{
    WORD	x, y, w, h;
    
    pn_active( pw );
    desk_verify( pw->w_id, TRUE);
    
    win_sname( pw );
    wind_set2( pw->w_id, WF_INFO, (LONG)pw->w_info, 0, 0);
    wind_set2( pw->w_id, WF_NAME, (LONG)pw->w_title, 0, 0);
    
    wind_get(pw->w_id, WF_WXYWH, &x, &y, &w, &h);
    fun_msg(WM_REDRAW, pw->w_id, x, y, w, h);
    
} /* end rebld_one_win() */
    
/****************************************************************
 *  Rebuild any window that's OPEN, is showing the SAME DRIVE as
 *  the given window, and is NOT a TREEWIN that's about to be
 *  auto-hidden.
 ****************************************************************/
void fun_rebld(WNODE far * pwin)
{
	WORD	winsave, i;
	BYTE	drive;

	graf_mouse(HOURGLASS, 0x0L);
						/* set up path to check	*/
						/*   against all windows*/
	drive = pwin->w_path->p_spec[0];
						/* check all wnodes	*/
	winsave = G.g_cwin;

	for (i = (NUM_WNODES*2); i; i--)
	{
	    pwin = win_ith(i);
	    G.g_cwin = pwin->w_id;

	    if ( (pwin->w_id)		   &&
		 (pwin->w_open)		   &&	/* don't do unopen TREEWIN */
	         (pwin->w_id != whnorebld) &&
	         (drive == pwin->w_path->p_spec[0]) )
	        rebld_one_win(pwin);

	}

	desk_verify(winsave, FALSE);
	graf_mouse(ARROW, 0x0L);
	
} /* fun_rebld */

/****************************************************************
 *  Create a new directory in the specified path and update all
 *  affected windows.
 ****************************************************************/
WORD fun_mkdir( WNODE far * pw_node )
{
	PNODE far *	pp_node;
	TREE		tree;
	WORD		more, cont, i;
	BYTE		fnew_name[12], unew_name[13], *ptmp;

	rsrc_gaddr( R_TREE, ADMKDBOX, &tree ) ;
	pp_node = pw_node->w_path;
	ptmp = G.g_srcpth;
	fstrcpy( (char far *)ptmp, pp_node->p_spec );
#if DBCS
	for(i=0; *ptmp; ptmp++)
	{
	  if (dbcs_lead(*ptmp) && *(ptmp+1))
	    ptmp++;
	  else if (*ptmp == '\\')
	    i++;
	}
#else /* DBCS */
	i = 0;
	while (*ptmp++)
	{
	  if (*ptmp == '\\')
	    i++;
	}
#endif /* DBCS */
	if (i > MAX_LEVEL)
	{
	  alert(0x0101, ERFO8DEE );
	  return(FALSE);
	}
	cont = TRUE;
	while (cont)
	{
	  fnew_name[0] = NULL;
	  tedinfo_set( tree, MKNAME, (char far *)fnew_name );
	  show_hide(FMD_START, tree);
#if HELP_ALERTS
	while ( -1 == xform_do( tree, MKNAME ) )
	    do_help_alert( HNEWFOLD ) ;
#else /* HELP_ALERTS */
	  form_do(tree, MKNAME);
#endif /* HELP_ALERTS */
	  cont = FALSE;
	  if (inf_what(tree, MKOK, MKCNCL))
	  {
	    tedinfo_get( tree, MKNAME, (char far *)fnew_name );
	    unfmt_str(fnew_name, unew_name);
	    if ( unew_name[0] != NULL )
	    {
	      add_fname( G.g_srcpth, unew_name );
	      dos_mkdir( (LONG)(char far *)G.g_srcpth );
	      if (DOS_ERR)
	      {
	 	cont = ( alert( 0x0102, ERFOEXIS ) == 1 ) ;
		del_fname( (char far *)G.g_srcpth);
	      }
	      else
	      {
	        more = d_errmsg();
	        if (more)
		{
	          fun_rebld(pw_node);
		}
	      } /* else */
	    } /* if */
	  } /* if OK */
	} /* while */
	show_hide(FMD_FINISH, tree);
	return(TRUE);
	
} /* fun_mkdir */

/*----------------------------------------------------------------------------
*/
MLOCAL	WORD
fun_op(op, pspath, pdest, dulx, duly, from_disk, src_ob)
	WORD		op;
	PNODE far *	pspath;
	BYTE		*pdest;
	WORD		dulx, duly, from_disk, src_ob;
{
	WORD		fcnt, dcnt;
	LONG		size;
						/* do the operation	*/
	if (op != -1)
	{
	  if (op == OP_COPY)
	  {
	    if ( !par_chk( pspath->p_spec, pspath->p_flist, G.g_tmppth) )
	      return(FALSE);
	  }
						/* get count of source	*/
						/*   files		*/
	  dir_op( OP_COUNT, pspath->p_spec, pspath->p_flist, pdest,
	  	 &fcnt, &dcnt, &size, dulx, duly, from_disk, src_ob);
						/* do the operation	*/
	  if ( fcnt || dcnt )
	  {
	    dir_op( op, pspath->p_spec, pspath->p_flist, pdest,
	    	   &fcnt, &dcnt, &size, dulx, duly, from_disk, src_ob);
	    return(TRUE);
	  } /* if */
	} /* if */
	graf_mouse(ARROW, 0x0L);
	return(FALSE);
} /* fun_op */

/*----------------------------------------------------------------------------
*	Routine to call when a list of files has been dragged on
*	top of a particular destination inside of a window.
*/
MLOCAL WORD fun_wdst(	PNODE far *	pspath,	/* source path		*/
			BYTE far *	pdspec,	/* destination file spec*/
		        WORD		datype,	/* destination icon	*/
			FNODE far *	pdf,	/* destination file/fold*/
			WORD		dulx,	/* destination x	*/
			WORD		duly,	/* destination y	*/
			WORD		from_disk, /* TRUE if src is disk */
			WORD		src_ob	 ) /* source object	*/
{
WORD		op;
BYTE		drv_ltr;
BYTE *		ptmp;
ICONBLK far *	spib;
WNODE far *	pw ;
						/* set up destination	*/
						/*   path name		*/
	pw = win_find( G.g_cwin ) ;
	if ( pw->w_type & TREEWIN || pw->w_view == V_TEXT )
	{
		ptmp = G.g_tmppth ;		/* set in dr_fnode()	*/
		while( *ptmp < 'A' - 1 )	/* find drive letter	*/
			ptmp++;
		drv_ltr = *ptmp; 
	}
		
	fstrcpy( (char far *)G.g_tmppth, pdspec );
	*strchr( G.g_tmppth, '*' ) = NULL ;	/* remove extension	*/
						
	op = -1;				/* check destination	*/
	switch( datype ) {
	case AT_ISFOLD:				/* if destination is	*/
						/*   folder then append	*/
						/*   folder to window	*/
						/*   path, if it is a	*/
						/*   fake then treat it	*/
						/*   like open space	*/
		if ( !(pdf->f_attr & F_FAKEFOLD) )
		{
		    fstrcat( (char far *)G.g_tmppth, pdf->f_name ) ;
		    strcat( G.g_tmppth, "\\" ) ;
		}
		strcat( G.g_tmppth, "*.*" );
		
		op = OP_COPY;
		break;
		
	case AT_ISDISK:				/* if destination is	*/
						/*   disk then use	*/
						/*   icon char. to build*/
						/*   dest path		*/
	        if ( pw->w_type & TREEWIN || pw->w_view == V_TEXT )
		{
		    G.g_tmppth[0] = drv_ltr;
		}
		else
		{
		    spib = get_spec(G.g_screen, pdf->f_obid);
		    G.g_tmppth[0] = (0x00FF & spib->ib_char);
		}
		strcpy( &G.g_tmppth[1], ":\\*.*" );
		op = OP_COPY;
		break;

	  case AT_ISFILE:			/* if destination is	*/
						/*   window or a file	*/
						/*   icon then use	*/
						/*   window path	*/
		strcat( G.g_tmppth, "*.*" );
		op = OP_COPY;
		break;

	  case AT_ISTRSH:
		op = OP_DELETE;
		break;
	}
	return( fun_op(op,pspath,G.g_tmppth,dulx,duly,from_disk,src_ob) );
} /* fun_wdst() */

/*----------------------------------------------------------------------------
*	Routine to call when the source of a drag is a disk
*	and the destination is either a window or another
*	disk.
*/
MLOCAL WORD fun_disk( WORD src_ob, WNODE far * pdw, WORD datype, FNODE far * pdf,
			WORD dulx, WORD duly )
{
WORD		ret;
FNODE far *	pf;
ICONBLK	far *	spib;
PNODE far *	pspath;
BYTE		chr;
WNODE far *	pw ;

	pw = win_find( G.g_cwin ) ;
	if ( pw->w_type & TREEWIN || pw->w_view == V_TEXT )
	  chr = *(char far *)G.g_udefs[src_ob].ab_parm; /* get drive from user obj */
	else
	{
	  spib = get_spec(G.g_screen, src_ob);
	  chr = spib->ib_char;
	} /* else */
						/* build a source path	*/
	pspath = pn_open(chr, "", "*", "*" );
						/* if one available	*/
	if (pspath)
	{
						/* read the directory	*/
	  ret = pn_active( pdw != (WNODE far *)NULL ? pdw : pw );
						/* if files to copy	*/
	  ret = FALSE;
	  if (pspath->p_flist)
	  {
						/* select all files	*/
	    for ( pf = pspath->p_flist; pf != (FNODE far *)0; pf = pf->f_next)
	      pf->f_obid = 0;
	    G.g_screen[0].ob_state = SELECTED;
						/* do the copy or delete*/
	    if (pdw != (WNODE far *)NULL )
	      ret = fun_wdst(pspath, pdw->w_path->p_spec, datype,
	      		     pdf, dulx, duly, TRUE, src_ob);
	    else
	      ret = fun_op(OP_DELETE, pspath, G.g_tmppth,
	      		   dulx, duly, TRUE, src_ob);
						/* return to normalcy	*/
	    G.g_screen[0].ob_state = NORMAL;
	  } /* if */
	  pn_close(pspath);
  		/* rebuild any windows with dpib.ib_char in title	*/
	  desk_clear(0);
	} /* if pspath */
	return(ret);
} /* fun_disk */

/*-----------------------------------------------------------------------------
*	Routine to call when several icons have been dragged from a
*	window to another window (it might be the same window) and 
*	dropped on a particular icon or open space.
*/
void fun_drag( WORD src_wh, WORD dst_wh, WORD dst_ob, WORD dulx, WORD duly )
{
WORD		ret, junk, datype, src_ob;
WNODE far *	psw;
WNODE far *	pdw;
ANODE *		pda;
FNODE far *	pdf;

	psw = win_find(src_wh);
	pdw = win_find(dst_wh);
	if (pdw->w_path->p_spec[0] == '@' && dst_ob <= 3) 
	  return;

	pda = i_find(dst_wh, dst_ob, &pdf, &junk);
	datype = (pda) ? pda->a_type : AT_ISFILE;

	
	if (psw->w_path->p_spec[0] != '@')
	{
          if ( psw->w_type & TREEWIN )
	  {
	    tree_pspec(psw->w_path);		/* Fix the pathspec up */
	    if (!psw->w_path->p_flist->f_name[0])
	    {
		alert( 1, ERBADCOP );
	        fun_rebld(psw);
		return;
	    }
	  }
	  
          if ( pdw->w_type & TREEWIN )
	    tree_pspec(pdw->w_path);

	  ret = fun_wdst(psw->w_path, pdw->w_path->p_spec, 
			 datype, pdf, dulx, duly, FALSE, 0);
		     
	 /* Ran out of FNODEs or TNODEs in the destination window.
	  * For G.g_cwin == 3 or 1, hide treewin side of window 2,
	  * For G.g_cwin == 4 or 2, hide treewin side of window 1.
	  * Avoid any routine that will cause the TREEWIN that'll
	  * get hidden from being re-tree_open()ed until then.
	  */
	  if (SeenEROBJMIS != FALSE)
	  {
	      SeenEROBJMIS = 1 + (SeenEROBJMIS % 2) ;
	      whnorebld = SeenEROBJMIS + 2 ;
	  }
	  else
	      whnorebld = FALSE ;
		      
	  /* Force redraw of all open windows that are showing a path on the
	   * same drive as the destination window, EXCEPT any that is going to
	   * be auto-hidden back at the main event loop.
	   */
	  fun_rebld(pdw);
	  
	  if (ret)
	  {
	    if (src_wh != dst_wh)
	      desk_clear(src_wh);
	  } /* if ret */
	} /* if */
	else
	{
	  src_ob = 0;
	  while ( (src_ob = win_isel(G.g_screen, G.g_croot, src_ob)) != 0 )
	  {
	    ret = fun_disk(src_ob, pdw, datype, pdf, dulx, duly);
	    if (ret)
	      fun_rebld(pdw);
	  } /* while */
	} /* else */
	
} /* fun_drag */

/*----------------------------------------------------------------------------
*	Routine to call when several icons have been dragged from a
*	desktop to the desktop and dropped on a particular icon.
*/
void	fun_del( WNODE far * pdw )
{
	WORD		src_ob;
	WORD		ret;
	ICONBLK far*	spib;
	BYTE		drvch[2];
	BYTE*		ptmp;

	if (pdw->w_path->p_spec[0] != '@')
	{
                if ( pdw->w_type & TREEWIN ) 
	          tree_pspec( pdw->w_path ); /* Make a proper path */
		   
		ret = fun_op(OP_DELETE, pdw->w_path, G.g_tmppth, 0, 0, 0, 0);
		if (ret)
		{	/* Delete was successful so rebuild views */
		    fun_rebld(pdw);
		}
	}
	else
	{
		src_ob = 0;
		while((src_ob = win_isel(G.g_screen, G.g_croot, src_ob)) != 0)
		{
			ret = 1;
			/* BugFix	*/
			if ( pdw->w_type & TREEWIN || pdw->w_view == V_TEXT )
			{
				ptmp = G.g_tmppth;
				while (*ptmp < 0x40)
					ptmp++;
				drvch[0] = *ptmp;
			}
			else
			{
				spib = get_spec(G.g_screen, src_ob);
				drvch[0] = (0x00FF & spib->ib_char);
			}
			drvch[1] = NULL;
			graf_mouse( ARROW, 0x0L );
			ret = alert_s( 0x0202, ERDELDIS, drvch ) ;
			graf_mouse(HOURGLASS, 0x0L);
			if (ret == 1)
			{
				fun_disk(src_ob,(WNODE far *)NULL, AT_ISTRSH,
						(FNODE far *)NULL, 0, 0);
				do_chkall(TRUE);
			}
		}
		graf_mouse(ARROW, 0x0L);
	}
} /* fun_del() */

/*
 *	deskfun.c
 */
