/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskobj.c 3.4 92/04/10 12:06:58 sbc Exp $
* $Log:	deskobj.c $
 * Revision 3.4  92/04/10  12:06:58  sbc
 * correctly bracket initialization of sample objects
 * 
 * Revision 3.3  92/04/03  17:09:51  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 3.2  92/03/12  13:57:09  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 3.1  91/08/19  16:38:16  system
 * ViewMAX 2 sources
 * 
* Revision 3.4  91/06/14  18:23:08  anderson
* Brutish way to get around having 2nd TREEWIN overwrite 1st in G.g_screen
* when 1st TREEWIN isn't open.  Could stand revisiting.
* 
* Revision 3.3  91/06/04  13:01:45  sbc
* misc housekeeping and other ravings...
* 
* Revision 3.2  91/05/17  16:01:51  anderson
* Merged REL05SMW with BETA1 (same as REL05SMW actually).
* 
* Revision 2.1.1.4  91/05/15  14:13:46  anderson
* Merged in split-mode windows for possible release as Beta 1
* 
* Revision 2.1.1.3  91/04/08  12:13:46  fontes
* Find File implementation.
* 
* Revision 2.1.1.2  91/03/25  14:19:12  anderson
* Converted to Medium model, prototyped, and generally cleaned up.
* 
*****************************************************************************/

/****************************************************************************
* File:		deskobj.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/


#include "shell.h"

EXTERN WORD	gl_width;
EXTERN WORD	gl_height;

MLOCAL OBJECT	gl_sampob[2] =
{
    {	NIL, NIL, NIL, G_IBOX, NONE, NORMAL, (FBYTE*)0x0L, 0, 0, 0, 0	},
    {	NIL, NIL, NIL, G_BOX,  NONE, NORMAL, (FBYTE*)0x00001100L, 0, 0, 0, 0 }
};

EXTERN	GLOBES		G;

/*
*	Initialize all objects as children of the 0th root which is
*	the parent of unused objects.
*/
	VOID
obj_init(TREE tree, WORD num_objs, BOOLEAN include_wins)
{
	WORD		ii;


	for (ii = 0; ii < num_objs; ii++)
	{
	  tree[ii].ob_head = NIL;
	  tree[ii].ob_next = NIL;
	  tree[ii].ob_tail = NIL;
	}
	fmemcpy( (char far *)&tree[ROOT],  (char far *)&gl_sampob[0], 
		sizeof(OBJECT) );
	tree[ROOT].ob_box.x = 0;
	tree[ROOT].ob_box.y = 0;
	tree[ROOT].ob_box.w = gl_width;
	tree[ROOT].ob_box.h = gl_height;
	
	if (include_wins)
	{
	  for (ii = 0; ii < ((NUM_WNODES*2) + 1); ii++)		/* (hca) */
	  {
	    fmemcpy( (char far *)&tree[DROOT+ii],  (char far *)&gl_sampob[1], 
		    sizeof(OBJECT) );
	    objc_add(tree, ROOT, DROOT+ii);
	  } /* for */
	}
} /* obj_init */

/*
*	Allocate a window object from the screen tree by looking for 
*	the child of the parent with no size
*/
EXTERN WORD	gl_usewob;	/* (hca) */
WORD obj_walloc(WORD x, WORD y, WORD w, WORD h)
{
#if 0
	WORD		ii;
#endif
	r_set(&G.g_screen[gl_usewob++].ob_x, x, y, w, h);
	return(gl_usewob-1);

/* (hca) There's absolutely no need to get this complex.....is there? */
#if 0	
	for (ii = DROOT; ii < (NUM_WNODES*2)+1; ii++)		/* (hca) */
	{
	  if ( !(G.g_screen[ii+1].ob_width && G.g_screen[ii+1].ob_height) )
	    break;
	}
	if ( ii < ((NUM_WNODES*2) + 1) )			/* (hca) */
	{
	  r_set(&G.g_screen[ii+1].ob_x, x, y, w, h);
	  return(ii+1);
	}
	else
	  return(0);
#endif
	    
} /* obj_walloc */

/*
*	Free a window object by changing its size to zero and
*	NILing out all its children.
*/
	VOID
obj_wfree(obj, x, y, w, h)
	WORD		obj;
{
	WORD		ii, nxtob;

	r_set(&G.g_screen[obj].ob_x, x, y, w, h);
	for (ii = G.g_screen[obj].ob_head; ii > obj; ii = nxtob)
	{
	  nxtob = G.g_screen[ii].ob_next;
	  G.g_screen[ii].ob_next = NIL;
	}
	G.g_screen[obj].ob_head = G.g_screen[obj].ob_tail = NIL;
} /* obj_wfree */

/*
*	Routine to find and allocate a particular item object.  The
*	next free object is found by looking for any object that
*	is available (i.e., a next pointer of NIL).
*/
	WORD
obj_ialloc(wparent, x, y, w, h)
	WORD		wparent;
	WORD		x, y, w, h;
{
	WORD		ii;

	for (ii = (NUM_WNODES*2)+2; ii < NUM_SOBS; ii++)	/* (hca) */
	{
	  if (G.g_screen[ii].ob_next == NIL)
	    break;
	}
	if (ii < NUM_SOBS)
	{
	  G.g_screen[ii].ob_head = G.g_screen[ii].ob_tail = NIL;
	  objc_add( (TREE)&G.g_screen[ROOT], wparent, ii);
	  r_set(&G.g_screen[ii].ob_x, x, y, w, h);
	  return(ii);
	}
	else
	  return(0);
} /* obj_ialloc */


/*
 *	deskobj.c
 */
