/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskpass.c 3.8 92/04/06 09:45:58 Fontes Stable $
* $Log:	deskpass.c $
 * Revision 3.8  92/04/06  09:45:58  Fontes
 * Initial cut to extract/display Windows exe embedded icons.
 * 
 * Revision 3.7  92/04/03  17:11:20  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 3.6  92/03/26  14:44:36  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 3.5  92/03/13  14:41:17  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 3.4  92/03/12  13:57:14  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 3.3  92/02/19  15:55:18  sbc
 * Replace refs to G.a_trees[] with calls to rsrc_gaddr().
 * 
 * Revision 3.2  92/01/31  16:35:43  sbc
 * change params for dos_sdta() to be FCB far * instead of LONG.
 * 
 * Revision 3.1  91/08/19  16:38:40  system
 * ViewMAX 2 sources
 * 
Date    	Who	SPR#	Comments
---------	-------	----	-------------------------------------------------------
91 Oct 16	K.H	----	Add supporting double byte character set.
				(#if DBCS)
91 May 20	WHF		Implement Temporary Default Password
07 Feb 90	JFL	----	Password functions. - Start work.
*****************************************************************************/

#include "shell.h"
#include "list.h"
#include "exobdefs.h"
#include "exproto.h"
#include "viewapps.h"

extern GLOBAL UWORD	DOS_AX;
extern GLOBAL UWORD	DOS_BX;
extern GLOBAL UWORD	DOS_CX;
extern GLOBAL UWORD	DOS_DX;
extern GLOBAL UWORD	DOS_DS;
extern GLOBAL UWORD	DOS_ES;
extern GLOBAL UWORD	DOS_SI;
extern GLOBAL UWORD	DOS_DI;
extern GLOBAL UWORD	DOS_ERR;

extern WORD	gl_wchar;

extern GLOBES	G;

GLOBAL BOOLEAN passw_dial_shown;  /* RSF: TRUE anytime password_dial called */


#define	PASS_DL		0x01
#define	PASS_WR		0x04
#define	PASS_RD		0x08
#define	PASS_DIR	PASS_DL|PASS_WR|PASS_RD

#define	SET_PASSW	0x03
#define	GET_PASSW	0x02
#define NEW_PASSW	0x8000

/*----------------------------------------------------------------------------
*	Set password on a file.
*/
MLOCAL	void passw_assign( BYTE * path, BYTE * name, BYTE * passw, 
								WORD rights )
{
    sprintf( G.g_wdta, "%-8s", passw ) ;    
    dos_sdta( (FCB far *)G.g_wdta );
    
    /* use G.g_1text[] 'cause it's just sitting there anyway... */
    sprintf( G.g_1text, "%s%s", path, name ) ;

    rights |= ( rights<<4 ) | ( rights<<8 ) ;
    dos_chmod( (ULONG)(char far *)G.g_1text, SET_PASSW, (rights|NEW_PASSW) );
    
} /* passw_assign() */

/*----------------------------------------------------------------------------
    Remove password from a file. File and password stored as
	    "C:\SOMEPATH\FILENAME.FOO;PWORD   "
*/
WORD passw_strip( LONG lp )
{
char far *	pChr ;

    pChr = fstrrchr( (char far *)lp, ';' ) ;
    if ( pChr != (char far *)0L )
	*pChr = NULL ;
    
    return( fstrlen( (char far *)lp ) ) ;

} /* passw_strip() */

/*----------------------------------------------------------------------------
    Assign password to a file. File and password stored as
	    "C:\SOMEPATH\FILENAME.FOO;PWORD   "
*/
MLOCAL	void passw_append( BYTE far *path, BYTE *passw )
{
BYTE	tmp[ LEN_PASSW ] ;

    passw_strip( (LONG)path );
    
    sprintf( tmp, "%-8s", passw ) ;

    fstrcat( path, ";" ) ;
    fstrcat( path, tmp ) ;

} /* passw_append() */

/*----------------------------------------------------------------------------
*/
MLOCAL	void passw_remove( BYTE * path, BYTE *name, BYTE *passw )
{
BYTE fname[LEN_ZFNAME+LEN_PASSW+1];

    strcpy( G.g_wdta, "        " ) ;
    dos_sdta( (FCB far *)G.g_wdta );
    
    strcpy( fname, name );
    passw_append( (BYTE far *)(fname), passw );
    
    /* use G.g_1text[] 'cause it's just sitting there anyway... */
    sprintf( G.g_1text, "%s%s", path, fname ) ;

    dos_chmod( (ULONG)(char far *)G.g_1text, SET_PASSW, 0 );
    
} /* passw_remove() */

/*----------------------------------------------------------------------------
*/
MLOCAL	WORD passw_status( BYTE * path, BYTE * name )
{
    /* use G.g_1text[] 'cause it's just sitting there anyway... */
    sprintf( G.g_1text, "%s%s", path, name ) ;

    return( dos_chmod( (ULONG)(char far *)G.g_1text, GET_PASSW, 0 ) );
} /* passw_status() */

/*----------------------------------------------------------------------------
*/
MLOCAL	void passw_globset( BYTE *passw )
{
BYTE	tmp[ LEN_PASSW ] ;

    sprintf( tmp, "%-8s", passw ) ;		/* Space pad the password */

    DOS_AX = 0x4454;	/* Set global password	*/
    DOS_DS = HIWORD( (long)(char far *)tmp );
    DOS_DX = LOWORD( (long)(char far *)tmp );
    __DOS();
    
} /* passw_globset() */

/*----------------------------------------------------------------------------
*/
void passw_global( void )
{
BYTE	passw[LEN_PASSW];
TREE	tree;

	rsrc_gaddr( R_TREE, ADGLOBPA, &tree ) ;
	tedinfo_set( tree, GLOBENEW, (BYTE far *)"\0" );
	show_hide(FMD_START, tree);
#if HELP_ALERTS
	while ( -1 == xform_do( tree, GLOBENEW ) ) {
	    do_help_alert( HGLOBPAS ) ;
	}
#else /* HELP_ALERTS */
  	form_do( tree, GLOBENEW );
#endif /* HELP_ALERTS */
	show_hide(FMD_FINISH, tree);
	if( (tree+GLOBECAN)->ob_state &SELECTED ){ /* Cancel button? */
	  (tree+GLOBECAN)->ob_state = NORMAL ;
	  return;
	}
	passw_globset( "        " );	/* Remove old password	*/
	tedinfo_get( tree,GLOBENEW, (BYTE far *)passw );
	if( (tree+GLOBEASS)->ob_state &SELECTED ){
	  (tree+GLOBEASS)->ob_state = NORMAL ;
	  passw_globset( passw );
	}
	else
	  (tree+GLOBEREM)->ob_state =NORMAL ;
} /* passw_global() */

/*----------------------------------------------------------------------------
    Copy "FRED\BILL" into "FRED"
*/
MLOCAL BOOLEAN passw_nodeget( BYTE *path, BYTE *node )
{
char *	ptr ;

    *node = NULL ;
    ptr = strpbrk( path, "\\*" ) ;
    if ( ptr != (char *)NULL ) {
	memcpy( (void *)node, (void *)path, ptr-path ) ;
	node[ ptr-path ] = '\0' ;
    }
    return( *node != NULL );
    
} /* passw_nodeget() */

/*----------------------------------------------------------------------------
* This is rendered complicated by the need to cater for passwords.
*/
BOOLEAN passw_chdir( BYTE far * pdrvpath )
{
BYTE	tmp_path[LEN_ZPATH];	
BYTE	path_node[LEN_ZFNAME+LEN_PASSW];
BYTE	new_path[LEN_ZPATH];
WORD	ret				= TRUE ;
WORD	n;
BYTE	drv;
WORD	cnt;

    fstrcpy( (void far *)tmp_path, pdrvpath ) ;

    if( *(pdrvpath+1) == ':' )			/* get the drive	*/
      drv = *pdrvpath - 'A' ;
    else
      drv = dos_gdrv();
      
    dos_sdrv( drv );				/* Change to the drive	*/

    sprintf( new_path, "%c:\\", (char)( drv+'A' ) ) ;
    dos_chdir( (LONG)(char far *)new_path );
    new_path[2]=0;				/* rm trailing \	*/
    n=3;
            
    while( passw_nodeget( &tmp_path[n], path_node ) ){
	sprintf( &new_path[ strlen( new_path ) ], "\\%s", path_node ) ;
	n+=(strlen( path_node ))+1;
	ret=TRUE;
	cnt = 0;
	do{	/* Try to change directory a node at a time */
	  dos_chdir( (LONG)(char far *)new_path );
	  if( DOS_ERR && DOS_AX==0x56 )
	    ret = passw_perror( (BYTE far *)new_path, cnt++, TRUE );
	  else{
	    if( DOS_ERR ) 
	      ret = FALSE;
	  }
	}while( ret && DOS_ERR );
    }
    if( !DOS_ERR ){
      strcat(new_path ,  "\\*.*" );
      fmemcpy( (void far *)pdrvpath, (void far *)new_path, LEN_ZPATH );
    }
    return( ret );
} /* passw_chdir() */

/*----------------------------------------------------------------------------
*  Set the Temporary Default Password
*/
MLOCAL BYTE pw_tdf[LEN_PASSW];		/* Last password tried */
void passw_tdf( BYTE * pw )
{
    if( pw == NULL )
	*pw_tdf = NULL;
    else
	strcpy( pw_tdf, pw );
      
} /* passw_tdf() */

/*----------------------------------------------------------------------------
*  Check if Temporary Default Password has been tried (i.e. is on path).
*	Returns TRUE if NOT tried (and places it at end of path).
*/
BOOLEAN passw_chk( BYTE far *path )
{
char far *	pChr ;

    if( *pw_tdf==NULL ) return FALSE;	/* TD Password not set yet */
    
    pChr = fstrrchr( path, ';' ) ;
    if ( pChr != (char far *)0L ) {		/* No password yet */
	  passw_append( path, pw_tdf );
	  return TRUE;
	}
    return FALSE;			/* Password was tried & failed */
					/* WHF Note: we could test to see
					*	if the password was the
					*	TD Password: but we won't.
					*/
} /* passw_chk() */

/*----------------------------------------------------------------------------
*  Password protection dialog
*/
MLOCAL BOOLEAN password_dial( BYTE far * path, BYTE * name, 
		BOOLEAN * first, BOOLEAN is_folder, BOOLEAN end_draw )
{
TREE	tree; 
BYTE	password[LEN_PASSW];
BYTE	tmp[25] ;

    desk_wait( FALSE );	
    passw_dial_shown = TRUE;

    rsrc_gaddr( R_TREE, DPASSWRD, &tree ) ;

    sprintf( tmp, " %s ", name ) ;
    tedinfo_set( tree, PASSNAME, (BYTE far *)tmp );
    (tree+PASSNAME)->ob_box.w = strlen( tmp ) * gl_wchar ;
    tedinfo_set( tree, PASSWORD, (BYTE far *)"" );
    
    if ( is_folder ) {
	(tree+FILETITL)-> ob_flags |= HIDETREE;
	(tree+FOLDTITL)-> ob_flags &= ~HIDETREE;
    } else {
	(tree+FILETITL)-> ob_flags &= ~HIDETREE;
	(tree+FOLDTITL)-> ob_flags |= HIDETREE;
    }
    if ( *first )
	(tree+PASSERR)-> ob_flags |= HIDETREE;
    else
	(tree+PASSERR)-> ob_flags &= ~HIDETREE;
    *first = FALSE;
    
#if HELP_ALERTS    
    inf_show( tree, PASSWORD, HPASSWRD, end_draw );
#else /* HELP_ALERTS */
    inf_show( tree, PASSWORD, end_draw );
#endif /* HELP_ALERTS */

    if( inf_what( tree, PASWOK, PASWCAN ) ) 
       {
	tedinfo_get( tree, PASSWORD, (BYTE far *)password );
	passw_append( path, password );
	passw_tdf( password );
	return( TRUE );
    } 
    else 
	return( FALSE );
    
} /* password_dial() */

/*----------------------------------------------------------------------------
*  Folder (path) error handler
*/
WORD passw_perror( BYTE far * path, WORD pass_count, BOOLEAN end_draw )
{
WORD	nn,ii;
BYTE	path_only[LEN_ZPATH];
static	BOOLEAN first_view;

			/* Check if tmp default password makes sense */
    if( pass_count == 0 )
    {
	first_view = TRUE;
	if( passw_chk( path ) )
	    return( TRUE );
    }
			/* Remove all passwords from path for display */
    for( nn=0,ii=0 ; path[nn] && nn<sizeof(path_only) ; nn++,ii++ ){
	if( path[ii] == ';' ) {
#if DBCS
	    while( path[ii]!='\\' && path[ii]!=NULL )
	    {
		if (dbcs_lead(path[ii]) && path[ii+1]!=NULL)
		    ii+=2;
		else
		    ii++;
	    }
#else /* DBCS */
	    while( path[ii]!='\\' && path[ii]!=NULL )
		ii++;
#endif /* DBCS */	    
	   }
	path_only[nn]=path[ii];
    }
    
    path_only[nn]=0;

    win_stitle( path_only, 23 ) ;

    return( password_dial( path, path_only, &first_view, TRUE, end_draw ) ) ;
    
} /* passw_perror() */

/*----------------------------------------------------------------------------
*  File password error handler 
*/
WORD passw_ferror( BYTE far * fpath, WORD pass_count )
{
BYTE	path[ LEN_ZPATH ] ;
BYTE *	name_only ;
static	BOOLEAN first_view;

			/* Check if tmp default password makes sense */
    if( pass_count == 0 )
    {
	first_view = TRUE;
	if( passw_chk( fpath ) )
	    return( TRUE );
    }
					/* Zap the old password */
    passw_strip( (LONG)fpath );
    fstrcpy( (void far *)path, (void far *)fpath ) ; /* make local copy */
					/* Point to the file name */
    name_only = strrchr( path, '\\' ) ;
    name_only = ( name_only == NULL ) ? path : (name_only+1) ;

    return( password_dial( fpath, name_only, &first_view, FALSE, TRUE ) ) ;

} /* passw_ferror() */

/*----------------------------------------------------------------------------
*/
WORD do_passw( WORD curr )
{
WORD		junk;
ANODE *		pa;
FNODE far *	pf;
WNODE far *	pw;
TREE		tree;
WORD		obj ;
BYTE		fname[LEN_ZFNAME];
BYTE		pfname[LEN_ZFNAME];	/* local copy of pf->f_name */
BYTE		passw[LEN_PASSW];
WORD		rights,status;
BYTE		path[LEN_ZPATH];
		
	pa = i_find(G.g_cwin, curr, &pf, &junk);
	pw = win_find( G.g_cwin );
	if ( pf != (FNODE far *)0 && (pw->w_type & TREEWIN) )
	{
	    tree_pspec( pw->w_path );
	    fstrcpy( (char far *)path, pw->w_path->p_spec);
	    *(strrchr(path, '\\')+1) = '\0';
	}
	else
	    fstrcpy( (char far *)path, pw->w_name );

	rights = 0;
	status = 0;
	
	if ( pa )
	{	
	  fstrcpy( pfname, pf->f_name ) ;		/* get a local copy */
	  switch( pa->a_type )
	  {
	    case AT_ISFILE:
	    case AT_ISWIND:
		status = passw_status( path, pfname );
		status &= 0x0F;
		rsrc_gaddr( R_TREE, ADPASSW, &tree ) ;
		
		(tree+ADPASFDL)-> ob_state =	/* Delete */
		    ( status&(PASS_WR|PASS_RD) )	  ? NORMAL : SELECTED;
		(tree+ADPASFDW)-> ob_state =	/* Delete/Write */
		    ( status==(PASS_WR|PASS_DL) )         ? SELECTED : NORMAL;
		(tree+ADPASFRW)-> ob_state =	/* Delete/Write/Read*/
		    ( status==(PASS_WR|PASS_RD|PASS_DL) ) ? SELECTED : NORMAL;

		fmt_str( pfname, fname );
		tedinfo_set( tree, PNWPASS, (BYTE far *)"" );
		tedinfo_set( tree, PFINAME, (BYTE far *)fname );
#if HELP_ALERTS		
		obj = inf_show(tree, PNWPASS, HPASASFI, TRUE );
#else /* HELP_ALERTS */
	  	obj = inf_show(tree, PNWPASS, TRUE);
#endif /* HELP_ALERTS */
		(tree+obj)->ob_state = NORMAL ;
		if ( obj == PFCANCEL ) { /* Cancel button? */
		  return(FALSE);
		}
		
		if( (tree+ADPASFDL)->ob_state & SELECTED )
		  rights |= PASS_DL;			/* Delete */
		if( (tree+ADPASFDW)->ob_state & SELECTED )
		  rights |= (PASS_DL|PASS_WR);		/* Delete/Write */
		if( (tree+ADPASFRW)->ob_state & SELECTED )
		  rights |= (PASS_RD|PASS_DL|PASS_WR);	/* Delete/Write/Read*/
	      
		tedinfo_get( tree, PNWPASS, (BYTE far *)passw );
		if ( obj == PFASSIGN && *passw ) {	/* assign */
		  passw_assign( path, pfname, passw, rights );
		}
		else{					/* remove */
		  passw_remove( path, pfname, passw );
		}
		fun_rebld(pw);
		break;
	    case AT_ISFOLD:
		passw_chdir( pw->w_path->p_spec );
		rsrc_gaddr( R_TREE, ADPASSWP, &tree ) ;
		fmt_str( pfname, fname );
		tedinfo_set( tree, ADPASPWD, (BYTE far *)"\0" );
		tedinfo_set( tree, ADPASPAT, (BYTE far *)fname );
#if HELP_ALERTS		
	  	inf_show(tree, ADPASPWD, HPASASFD, TRUE );
#else /* HELP_ALERTS */
	  	inf_show(tree, ADPASPWD, TRUE);
#endif /* HELP_ALERTS */
		if( (tree+PPCANCEL)->ob_state &SELECTED ){ /* Cancel button? */
		  (tree+PPCANCEL)->ob_state =NORMAL ;
		  return(FALSE);
		}
		tedinfo_get( tree, ADPASPWD, (BYTE far *)passw );
		if( (tree+PPASSIGN)->ob_state &SELECTED ){
		  (tree+PPASSIGN)->ob_state =NORMAL ;
		  passw_assign( path, pfname, passw, PASS_DIR );
		}
		else{
		  (tree+PPREMOVE)->ob_state =NORMAL ;
		  passw_remove( path, pfname, passw );
		}
		fun_rebld(pw);
		break;
	  }
	}
	
	return( FALSE );
	
} /* do_passw() */

/*
 *	EOF:	deskpass.c
 */
