/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskpro.c 3.3 92/04/03 17:11:36 sbc Exp $
* $Log:	deskpro.c $
 * Revision 3.3  92/04/03  17:11:36  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 3.2  92/03/13  14:41:25  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 3.1  91/08/19  16:38:26  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
-------	---	----	------------------------------------------------------
911016  K.H		Changed pro_cmd to use international strrchr and
			next_path_ch functions.
			Add supporting double byte character set. (#if DBCS)
910626	RSF		Don't display TM dialog upon return if VM not 
			controlling TM.
910529	RSF		Don't display TM dialog upon return from create_task.
910508	RSF		Pulled tm_enable/disable_switching calls out.
910424	RSF		Use TaskMAX to run apps when it's available.
*****************************************************************************/

#include "shell.h"
#include "viewapps.h"

EXTERN WORD	gl_stdrv;
EXTERN WORD	DOS_ERR;
EXTERN GLOBES	G;
EXTERN taskmax_avail;
EXTERN taskmax_control;

/*----------------------------------------------------------------------*/
	WORD
pro_chdir(drv, ppath)
	WORD		drv;
	BYTE		*ppath;
{
	WORD		tmpdrv;
						/* change to directory	*/
						/*   that application	*/
						/*   is in		*/
	if (!drv)
	  return( (DOS_ERR = TRUE) );

	if ( drv != '@' ) 
	{
	  tmpdrv = dos_gdrv();
	  dos_sdrv(drv - 'A');
	  if (DOS_ERR)
	  {
	    dos_sdrv(tmpdrv);
	    return(FALSE);
	  }
	  sprintf( G.g_srcpth, "%c:\\%s", drv, ppath ) ;
	  dos_chdir( (LONG)(BYTE far *)G.g_srcpth );
	}
	else
	  dos_sdrv(gl_stdrv);		/* don't leave closed drive hot	*/
	return(TRUE);
} /* pro_chdir */

/*----------------------------------------------------------------------*/
	WORD
pro_cmd(psubcmd, psubtail, drive, path, exitflag)
	BYTE		*psubcmd, *psubtail;
	WORD		drive;
	BYTE		*path;
	WORD		exitflag;
{
	char far *	ptrComspec ;
	WORD		i, ii, drv;
	BYTE		save_ch;

	shel_envrn( (long)&ptrComspec, (LONG)(BYTE far *)"COMSPEC=" );
	if ( !ptrComspec )
	    return FALSE ;
	
	fstrcpy( (char far *)G.g_cmd, ptrComspec );

	  if (!exitflag)
	  {
				      /* find first backslash		*/
	    i = (WORD)((BYTE *)next_path_ch((UBYTE *)G.g_cmd) - G.g_cmd);
	    
				/* change to drive specified by COMSPEC	*/
	    drv = G.g_cmd[i - 2] - 'A';
	    dos_sdrv(drv);
				/* chdir to path specified by COMSPEC	*/
                                                /* find last backslash	*/
	    ii = (WORD)(strrchr(G.g_cmd, '\\') - G.g_cmd);
	    if (i == ii)		/* root directory?		*/
	      ii++;			/* keep backslash in path name	*/

	    save_ch = G.g_cmd[ii];	/* save char for later		*/
	    G.g_cmd[ii] = NULL;		/* make a null-term. string	*/
	    dos_chdir( (LONG)(BYTE far *)G.g_cmd );  /* change to that dir.	*/
	    G.g_cmd[ii] = save_ch;	/* put the char back		*/
	  }

	  if (exitflag)
	  {
	    sprintf( &G.g_tail[1], "/C %c:\\", drive ) ;
	    if( *path == '\\' ) 
	      G.g_tail[6] = NULL; 
	    if( *path ){
	      strcat( &G.g_tail[1],  path );
#if DBCS
	      if( !isequalto(G.g_tail, strlen(&G.g_tail[1]), '\\') &&
		  *psubcmd!='\\' )
#else /* DBCS */
	      if( G.g_tail[strlen(&G.g_tail[1])]!='\\' && *psubcmd!='\\' )
#endif /* DBCS */
	        strcat(&G.g_tail[1] ,  "\\" );
	    }
	    sprintf( &G.g_tail[ 1 + strlen( &G.g_tail[1] ) ], "%s %s",
		( psubcmd[1] == ':' ) ? &psubcmd[3] : psubcmd, psubtail ) ;
  }
	  else
	    G.g_tail[1] = NULL;
	
  return(TRUE);

} /* pro_cmd */

/*----------------------------------------------------------------------*/
	WORD
pro_run(
	WORD	isgraf, 
	WORD	isover)
{
	WORD	ret, len, i, task_index;
#if 0	
	WORD	pathlen;
#endif /* 0 */    
	BYTE	fcb_area[37];

	if (taskmax_avail)	/* TaskMAX needs full path */
		ret = shel_find( (LONG)(BYTE far *)G.g_cmd );
	G.g_tail[0] = len = strlen(&G.g_tail[1]);

	if ( (len) && (!isgraf) )
	{
		for(i = len; i; i--)
			G.g_tail[i+1] = G.g_tail[i];
		G.g_tail[1] = ' ';
		len++;
	} /* if */
	G.g_tail[0] = len;
	G.g_tail[len+1] = 0x0D;
	
	if( isover )
	{
		if ( taskmax_avail )
		{
#if 0			
			/* Add path to cmd */
			if (drv != 0)
			{
				pathlen = strlen(path)+4;
				len = strlen(G.g_cmd);
				if (G.g_cmd[1] != ':' 
					&& ((len+pathlen) < sizeof(G.g_cmd)))
				{			/* push down name */
					for (i=len-1; i>=0; i--)
					    G.g_cmd[pathlen+i] = G.g_cmd[i];
							/* stuff path ahead */
					sprintf( G.g_cmd, "%c:\\%s", drv, path ) ;
					G.g_cmd[pathlen-1] = '\\';
				}
			}
#endif /* 0 */
			task_index = tm_create_task( G.g_cmd, 
				G.g_tail, fcb_area );
				/* TM invocation never to cause VM exit */
			ret = FALSE;	
			if (taskmax_control)
				taskmax(task_index);
		}
		else
		{
			ret = shel_write( TRUE, isgraf, isover, 
			(LONG)(BYTE far *)G.g_cmd, (LONG)(BYTE far *)G.g_tail );
		}
	}
	else
	{
		dos_exec( G.g_cmd, G.g_tail, fcb_area );
		ret=FALSE;
	}
	if (isover == -1)
		ret = FALSE;
	else
	{
/*	    do_wopen(FALSE, wh, curr, G.g_xdesk, G.g_ydesk,
	    	     G.g_wdesk, G.g_hdesk);
*/	} /* else */
	G.g_exec = ret;
	return(ret);
} /* pro_run */

/*----------------------------------------------------------------------*/
	WORD
pro_exit(pcmd, ptail)
	LONG		pcmd, ptail;
{
	WORD		ret;

	ret = shel_write(FALSE, FALSE, 1, pcmd, ptail);
	return( ret );
} /* pro_exit */


/*
 *	deskpro.c
 */
