/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskwin.c 4.19 92/04/13 11:08:25 sbc Exp $
* $Log:	deskwin.c $
 * Revision 4.19  92/04/13  11:08:25  sbc
 * Add w_next member to WNODE. Keep track of g_whead and g_wavail ptrs.
 * 
 * Revision 4.18  92/04/10  16:07:01  sbc
 * Rm unused members in WSAVE. Replace others with refs to equivs in WNODE
 * 
 * Revision 4.17  92/04/03  17:14:04  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.16  92/03/26  14:46:10  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.15  92/03/20  20:19:42  Fontes
 * Handle kbd commands for desktop objects
 * 
 * Revision 4.15  92/03/13  14:42:18  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.14  92/03/12  13:56:49  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 4.13  92/03/05  09:30:35  sbc
 * Hook up use of New Program Item dialog and INODE structure.
 * 
 * Revision 4.12  92/02/25  14:03:23  sbc
 * Various changes for ANODES and disk drive ANODES. Remove drive id from
 * top,left corner of icon, etc.
 * 
 * Revision 4.11  92/02/25  09:34:40  sbc
 * Add New Icon Dialog and allow assignment of icons (only) to FNODEs/ANODEs.
 * 
 * Revision 4.10  92/02/20  15:56:40  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.9  92/02/19  16:08:37  sbc
 * country => _country. void => void, extern => extern, FAR => far.
 * 
 * Revision 4.8  92/02/14  11:03:19  sbc
 * merged Tom Rolander's changes for Mobile Netware version of ViewMAX.
 * 
 * Revision 4.7  92/02/12  15:40:09  sbc
 * replace refs to BORDER_AREA and WORK_AREA with WC_BORDER and WC_WORK.
 * also add case to create group window: wind_creater( WIND_GROUP...).
 * rename local vars called "split" to "win_type".
 * 
 * Revision 4.6  92/02/06  12:10:49  sbc
 * rename WNODE member w_split to w_type
 * 
 * Revision 4.5  92/02/05  18:00:48  anderson
 * Removed unused tree handling code and fixed a keyboard focus problem.
 * 
 * Revision 4.4  92/01/28  14:59:14  rsf
 * *** empty log message ***
 * 
 * Revision 4.4  92/01/21  13:35:06  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.3  92/01/06  13:20:34  anderson
 * Color icon work from Becky.
 * 
 * Revision 4.2  91/12/20  15:03:54  anderson
 * Converted TNODEs to FNODEs.  Get rid of pointer to FNODE list that's just
 * been freed in win_join(). Moved tree window contents rebuild into win_split()
 * and took it out of win_contents().  Fixed excessive rebuilds on move-size
 * window operation.
 * 
 * Revision 4.1  91/11/08  10:36:27  anderson
 * Moveable-sizeable windows changes.
 * 
 * Revision 3.1  91/08/19  16:38:06  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR	Comments
----	---	---	--------
911016  K.H		Changed win_sname to use international next_path_ch
			function.
*****************************************************************************/

#include <dos.h>
#include "shell.h"
#include "exproto.h"
#include "viewapps.h"

#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
#include "deskmnvm.h"														/* USE_MOBILE_NETWARE  tar  02/13/92 */
#endif /* USE_MOBILE_NETWARE */																		/* USE_MOBILE_NETWARE  tar  02/13/92 */

#define MIN_HINT 2

#define SPACE 0x20

extern struct	internat _country;
extern WORD	DOS_ERR;
extern	GRECT	gl_normwin;
extern	GRECT	gl_siblwin;
extern	GRECT	gl_treewin;

extern	WORD	gl_open1st;
extern	GRECT	gl_savewin[NUM_WNODES];
extern  WORD	gl_idsiztop;
extern	BYTE	SeenEROBJMIS;

extern WORD		gl_wchar;
extern WORD		gl_hchar;
extern WORD		gl_height;
extern GRECT		gl_rfull;

extern ICONBLK	far	*gl_icons;
extern WORD		gl_whsiztop;

extern GLOBES		G;

extern BYTE		gl_lngstr[] ;

/****************************************************************
* Close and delete a window
*/
void close_window( WORD whandle )
{
    wind_close( whandle );	
    wind_delete( whandle );

} /* close_window() */

/****************************************************************
* Create and open a window. Return handle, -1 if error.
*/
WORD create_window( WORD wkind, BYTE * title, BYTE * info, GRECT *work )
{
WORD	wh ;

/* Get desktop work area */
    wind_calc( WC_WORK, wkind, G.g_xfull, G.g_yfull, G.g_wfull, G.g_hfull, 
			    &work->g_x, &work->g_y, &work->g_w, &work->g_h);
/* round work rect to character cell size */				
    work->g_w = (work->g_w / gl_wchar) * gl_wchar;
    work->g_h = (work->g_h / gl_hchar) * gl_hchar;
    
/* Create window */
    wh = wind_create( wkind, G.g_xfull - 1, G.g_yfull, G.g_wfull, G.g_hfull ) ;
    if ( wh == -1) {
	alert( 0x0101, ERNOWIND );
	return( -1 ) ;
    }

    if ( wkind & NAME )
	wind_set(wh, WF_NAME, FP_OFF(title), FP_SEG(title), 0, 0); 
    if ( wkind & INFO )
	wind_set(wh, WF_INFO, FP_OFF(info), FP_SEG(info), 0, 0); 
    
/* open and draw window */    
    wind_open(wh, WORD_ALIGN(G.g_xfull), G.g_yfull, G.g_wfull, G.g_hfull);

/* Get work area of window */
    wind_get( wh, WF_WXYWH, &work->g_x, &work->g_y, &work->g_w, &work->g_h);

    return( wh ) ;
    
} /* create_window() */

/****************************************************************
 *  Calculate object sizes for the window whose handle is given.
 ****************************************************************/
void win_vcalc( WORD wh )
{	
WORD		dummy;
WORD		win_width;
WNODE far *	pw ;

	pw = win_find( wh ) ;
	
	wind_get(wh, WF_CXYWH, &dummy, &dummy, &win_width, &dummy);

	if ( !( pw->w_type & TREEWIN) && (pw->w_view == V_ICON) ) {
		G.g_iwext = G.g_wicon;
		G.g_ihext = G.g_hicon;
		G.g_iwint = (gl_height <= 300) ? 0 : 8;
		G.g_ihint = MIN_HINT;
	    }
	else {	/* V_TEXT or TREEWIN side of split win */
		G.g_iwext = win_width - (4 * gl_wchar);
		G.g_ihext = gl_hchar;
		G.g_iwint = gl_wchar - 1;
		G.g_ihint = 0;
	}
	G.g_iwspc = G.g_iwext + G.g_iwint;
	G.g_ihspc = G.g_ihext + G.g_ihint;
	G.g_incol = (win_width - gl_wchar) / G.g_iwspc;	
	if( G.g_incol < 1 ) G.g_incol = 1;
	
} /* end win_vcalc() */

/***********************************************************************
*	Keep running track of max width of tree/text associated 
*	with FNODE.  The computations done here are completely tied
*	to the string building code in ob_sfcb().  IF you change that
*	routine BE SURE to change the width computation here.
************************************************************************/
WORD	win_twcalc(FNODE far *fn, WORD last_max)
{
	WORD	width = 0;	/* Running count of width */
	WORD	cnt;
	BYTE far *psrc;
	
	psrc = &fn->f_name[0];

	width = 3;
	if ((GET_ISTREE(fn) == FALSE) && (fn->f_attr & F_DISK))
	{
		width += 3;
	}
	else
	{
	    for( cnt = 0 ; fn->f_tree[cnt] && cnt<MAX_LEVEL ; cnt++ )
	    {
		    width++;
		    if( fn->f_tree[cnt] != ' ' && fn->f_tree[cnt] != VERT_BAR )
		    {
			    if (fn->f_treetag == NOKIDS)
				    width += 2;
			    else width += 3;
			    width += 2;
		    }
		    else width += 4;
	    }
	}
	
	for (cnt=0; psrc[cnt] && psrc[cnt] != '.'; cnt++)
		width++;
	if (GET_ISTREE(fn) == FALSE)
	{				/* Don't print '.' in text display */
	    if (width < 12)
		    width = 12;
	    if (psrc[cnt])		/* File/directory or module name */
		    cnt++;
	}
	while (psrc[cnt])
	{
		width++;
		cnt++;
	}
	if (width < 18)
		width = 18;

	return(max(last_max, width*gl_wchar));

} /* win_twcalc() */

/****************************************************************
 *
 ****************************************************************/
void win_view( WNODE far * pw, WORD vtype, WORD isort)
{
    pw->w_view = vtype ;
    pw->w_sort = isort ;
    win_vcalc( pw->w_id ) ;

} /* win_view() */

/*----------------------------------------------------------------------
*	Initialize the list of wnodes
*/
MLOCAL	void wnode_init(void)
{
WORD	ii;

    for (ii = 0; ii < (NUM_WNODES*2)-1; ii++ )
	G.g_wlist[ ii ].w_next = &G.g_wlist[ ii+1 ];
    
    G.g_wlist[(NUM_WNODES*2)-1].w_next = (WNODE far *) NULL;
    
    G.g_wavail = &G.g_wlist[0];
    G.g_whead = (WNODE far *)NULL ;
    
} /* wnode_init() */

/****************************************************************
 *  Start up by initializing global variables
 ****************************************************************/
void win_start( void )
{
WNODE far *	pw;
WORD		ii;

    obj_init( (TREE)&G.g_screen[ROOT], NUM_SOBS, TRUE);

    for (ii = 0; ii < (NUM_WNODES*2); ii++)
    {
	pw = (WNODE far *)&G.g_wlist[ii];
	pw->w_id = 0;
	pw->w_twin = 0;
	pw->w_open = FALSE;
	pw->w_istree = FALSE;
    }

    wnode_init() ;
    
} /* win_start() */

/*----------------------------------------------------------------------------
*	Allocate a WNODE
*/
WNODE far * wnode_alloc( BOOLEAN tohead )
{
WNODE far *	pw ;
WNODE far *	tmp ;

    if ( G.g_wavail == (WNODE far *)NULL )	/* no more available */
	return( (WNODE far *)NULL ) ;

    pw = G.g_wavail;				/* take next avail WNODE */
    G.g_wavail = G.g_wavail->w_next;		/* advance to next avail */
    
    if ( tohead || G.g_whead == (WNODE far *)NULL ) /* append to head of list */
    {
	pw->w_next = G.g_whead;			/* attach to list */
	G.g_whead = pw;				/* fix up ptr to head */
    }	
    else					/* append to end of list */
    {
	tmp = G.g_whead;
	while( tmp->w_next != (WNODE far *)NULL ) /* find last WNODE in list */
	    tmp = tmp->w_next;
	tmp->w_next = pw;			/* attach to list */
	pw->w_next = (WNODE far *)NULL;		/* fixup ptr to next */
    }

    return( pw );
    
} /* wnode_alloc() */

/*----------------------------------------------------------------------------
*	Free a wnode
*/
void wnode_free( WNODE far * pw )
{
WNODE far *	tmp;

    if (G.g_whead == pw)			/* if removing head, */
	G.g_whead = pw->w_next;			/* fix up head ptr */
    else
    {
	tmp = G.g_whead;			/* find preceding WNODE far */
	while ( tmp != (WNODE far *)NULL && tmp->w_next != pw )
	    tmp = tmp->w_next;
	if ( tmp != (WNODE far *)NULL )	
	    tmp->w_next = pw->w_next;		/* re-route .w_next around pw */
    }
    
    pw->w_next = G.g_wavail;			/* attach freed WNODE to top */
    G.g_wavail = pw;				/* of avail list */
    
} /* wnode_free() */

/****************************************************************
 *  Free a window node.
 *  Called from do_dopen() in desksupp.c.    
 ****************************************************************/
MLOCAL void win_free( WNODE far * thewin )
{
    if (thewin->w_id != -1)
	wind_delete(thewin->w_id);

    thewin->w_id = 0;
    objc_order((TREE)&G.g_screen[ROOT], thewin->w_root, 1);
    obj_wfree( thewin->w_root, 0, 0, 0, 0 );
    
    wnode_free( thewin ) ;
	
} /* win_free() */

/****************************************************************
 *  Allocate a window for use as a folder window.
 ****************************************************************/
WNODE far * win_alloc( WORD win_type, WSAVE *pws )
{
WNODE far *	pw;
WORD		wob;
GRECT *		pt;
WORD		x_save;

    pt = (GRECT *) &pws->ws_box;
    if (win_type & TREEWIN)	/* sibling's saved sizes altered */
    {				/* for later use by do_diropen() */
	x_save = pt->g_x;
	pt->g_x = pws->ws_t_x;
	pt->g_w = (x_save - pt->g_x) + 1;
    }

    /* Register the window in the object list */
    wob = obj_walloc( pt->g_x, pt->g_y, pt->g_w, pt->g_h );
    if ( !wob )
	return((WNODE far *) NULL);

    /* allocate a window node */
    pw = wnode_alloc( FALSE ) ;
    if ( pw == (WNODE far *)NULL )
	return((WNODE far *) NULL);

    /* Fill in the window structure */
    pw->w_type = win_type;
    pw->w_root = wob;
    pw->w_cvind = pw->w_cvcol = 0x0;
    pw->w_cvrow = 0x0;
    pw->w_pnind = pw->w_pncol = (pt->g_w  - gl_wchar) / G.g_iwspc;
    pw->w_pnrow = (pt->g_h - gl_hchar) / G.g_ihspc;
    pw->w_vnind = pw->w_vncol = 0x0;
    pw->w_vnrow = 0x0;

    pw->w_id = wind_create( (win_type & SIBLWIN)  ? WKIND_RSPLIT :
			    (win_type & TREEWIN)  ? WKIND_LSPLIT :
			    (win_type & GROUPWIN) ? WKIND_GROUP  : 
			    WKIND_FILE,
			    (win_type & SIBLWIN)  ? gl_siblwin.g_x :
			    (win_type & TREEWIN)  ? gl_treewin.g_x :
			    pt->g_x,
			    G.g_yfull,
			    (win_type & SIBLWIN)  ? gl_siblwin.g_w :
			    (win_type & TREEWIN)  ? gl_treewin.g_w :
			    pt->g_w,
			    G.g_hfull);
			
    if (pw->w_id == -1) 
    {	/* wind_create() failed */
	win_free( (WNODE far *)pw );
	return( (WNODE far *)NULL );
    }

    wind_set(pw->w_id, WF_TATTRB, WA_SUBWIN, 0, 0, 0);
    return(pw);
	
} /* end win_alloc() */

/****************************************************************
 *  Find the WNODE that has this id.
 ****************************************************************/
WNODE far * win_find( WORD wh )
{
WORD	ii;

	for(ii = 0; ii < (NUM_WNODES*2); ii++)
	{
	  if ( G.g_wlist[ii].w_id == wh )
	    return( (WNODE far *)&G.g_wlist[ii] );
	}
	return( (WNODE far *)NULL );

} /* win_find() */

/****************************************************************
 *  Bring a window node to the top of the window list.
 ****************************************************************/
void win_top( WNODE far * thewin)
{
	objc_order((TREE)&G.g_screen[ROOT], thewin->w_root, NIL);
} /* win_top() */

/****************************************************************
 *  Visually disable all windows but the one passed in, which 
 *  should be shown enabled.
 ****************************************************************/
void win_vistop( WORD wh, BOOLEAN co_top)
{
WORD		ii, sl_size, sl_value;
WNODE far *	pw;

	/* Make all other windows underlying */
	for (ii = 1; ii < (NUM_WNODES*2)+1; ii++)
	    if( ii!=wh ) wind_set( ii, WF_TATTRB, 1,0,0,0 );

	wind_set( wh, WF_TATTRB, 0,0,0,0 ); /* Make this window topmost */
					    /* ..and visually top it    */
	wind_set( wh, (co_top) ? WF_COTOP : WF_TOP, 0,0,0,0 );    

	if (wh)
	{				/* Calc object dimensions */	
	    win_vcalc( G.g_cwin ); 
	    pw = win_find( wh );
	    sl_size = mul_div(pw->w_pnrow, 1000, pw->w_vnrow);
	    wind_set(wh, WF_VSLSIZ, sl_size, 0, 0, 0);
	    if ( pw->w_vnrow > pw->w_pnrow )
		sl_value = mul_div(pw->w_cvrow, 1000,
				pw->w_vnrow - pw->w_pnrow);
	    else
		sl_value = 0;
	    wind_set(wh, WF_VSLIDE, sl_value, 0, 0, 0);
	    passw_chdir( pw->w_path->p_spec );
	}
} /* win_vistop() */

/****************************************************************
 *  Find the window node that is the ith from the bottom, where
 *  0 is the bottom (desktop surface) and 1-4 are windows.     
 ****************************************************************/
MLOCAL	WORD win_cnt(WORD level)
{
	WORD		wob;
						/* skip over desktop	*/
						/*   surface and count	*/
						/*   windows		*/
	wob = G.g_screen[ROOT].ob_head;
	while(level--)
	  wob = G.g_screen[wob].ob_next;
	return(wob-2);
} /* win_cnt() */

/****************************************************************
 *  Find the window node that is the ith from the bottom, where
 *  0 is the bottom (desktop surface) and 1-4 are windows.     
 ****************************************************************/
WNODE far * win_ith( WORD level )
{
	return( (WNODE far *)&G.g_wlist[win_cnt(level)] );
} /* win_ith() */

/****************************************************************
 *  Calculate a bunch of parameters related to how many file 
 *  objects will fit in a full-screen window.
 ****************************************************************/
MLOCAL	void win_ocalc( WNODE far * pwin, WORD wfit, WORD hfit, 
						    FNODE far **ppstart)
{
	FNODE far	*pf;
	WORD		start, cnt, w_space, depth;
						/* zero out obid ptrs	*/
						/*   in flist and count	*/
						/*   up # of files in	*/
						/*   virtual file space	*/
	cnt = 0;
	pf=pwin->w_path->p_flist;
	while( pf )
	{
	  pf->f_obid = NIL;
	  if ( (pwin->w_type & TREEWIN) && pf->f_treetag == SHOWKIDS)
	  {					/* Skip over hidden	*/
						/*   children		*/
		  depth = fstrlen(pf->f_tree);
		  pf = pf->f_next;
		  if (pf)
		      pf->f_obid = NIL;
		  while ((pf->f_next != (FNODE far *)NULL) &&
			 (depth < fstrlen(pf->f_tree)))
		  {
			  pf = pf->f_next;
			  pf->f_obid = NIL;
		  }
	  }
	  else pf=pf->f_next;
	  cnt++;
	}
						/* set windows virtual	*/
						/*   number of rows and	*/
						/*   columns		*/
	pwin->w_vncol = (cnt < G.g_incol) ? cnt : G.g_incol;
	pwin->w_vnrow = cnt / G.g_incol;
	if (cnt % G.g_incol)
	  pwin->w_vnrow += 1;
	if (!pwin->w_vnrow)
	  pwin->w_vnrow++;
	if (!pwin->w_vncol)
	  pwin->w_vncol++;
						/* backup cvrow & cvcol	*/
						/*   to account for	*/
						/*   more space in wind.*/
	if (!wfit)
	  wfit++;
	w_space = pwin->w_pncol = min(wfit, pwin->w_vncol);
	while( (pwin->w_vncol - pwin->w_cvcol) < w_space )
	  pwin->w_cvcol--;
	if (!hfit)
	  hfit++;
	w_space = pwin->w_pnrow = min(hfit, pwin->w_vnrow);
	while( (pwin->w_vnrow - pwin->w_cvrow) < w_space )
	  pwin->w_cvrow--;
						/* based on windows	*/
						/*   current virtual	*/
						/*   upper left row &	*/
						/*   column calculate	*/
						/*   the start and stop	*/
						/*   files		*/
	start = (pwin->w_cvrow * G.g_incol) + pwin->w_cvcol;
	pf = pwin->w_path->p_flist;
	while ( (start--) && pf)
	{
	  if ( (pwin->w_type & TREEWIN) && pf->f_treetag == SHOWKIDS)
	  {					/* Skip over hidden	*/
						/*   children		*/
		  depth = fstrlen(pf->f_tree);
		  pf = pf->f_next;
		  while (pf && depth < fstrlen(pf->f_tree))
		  {
			  pf = pf->f_next;
		  }
	  }
	  else pf=pf->f_next;
	}
	*ppstart = pf;
} /* win_ocalc() */

/****************************************************************
 *  Calculate a bunch of parameters dealing with a particular
 *  icon.     
 ****************************************************************/
MLOCAL	void win_icalc( FNODE far *pf )
{
    if (pf->f_attr & F_DISK)
	return;

    pf->f_pa = (void *)find_anode( pf ) ;

} /* win_icalc() */

/****************************************************************
 *  Build an object tree of the list of files that are currently
 *  viewable in a full-screen virtual window.  Next adjust root of
 *  tree to take into account the current view of the full-screen
 *  through a window on the physical display.
 ****************************************************************/
WORD win_bldview( WNODE far * pwin, WORD x, WORD y, WORD w, WORD h)
{
	FNODE far	*pstart;
	WORD		obid, skipcnt;
	WORD		r_cnt, c_cnt;
	WORD		o_wfit, o_hfit;		/* object grid		*/
	WORD		i, n;
	WORD		xoff, yoff, wh, sl_size, sl_value;
	WORD		depth;			/* (RSF) */
	WORD		max_twidth;		/* (RSF) */
	WORD		scoot;			/* (RSF) */
	
						/* free all this windows*/
						/*   kids and set size	*/
	obj_wfree(pwin->w_root, x, y, w, h);
						        /* make pstart point */
	win_vcalc( pwin->w_id );			/*  at 1st file in   */
						        /*  current view     */
	win_ocalc(pwin, w/G.g_iwspc, h/G.g_ihspc, &pstart);
	o_wfit = min(pwin->w_pncol + 1, pwin->w_vncol - pwin->w_cvcol);
	o_hfit = min(pwin->w_pnrow + 1, pwin->w_vnrow - pwin->w_cvrow);
	r_cnt = c_cnt = 0;
	max_twidth = G.g_iwext;		/* (rsf) */
	while ( (c_cnt < o_wfit) &&
		(r_cnt < o_hfit) && 
		(pstart) )
	{
						/* calc offset		*/
	  yoff = r_cnt * G.g_ihspc;
	  xoff = c_cnt * G.g_iwspc;
						/* allocate object	*/
	  obid = obj_ialloc(pwin->w_root, xoff + G.g_iwint, yoff + G.g_ihint,
				 G.g_iwext, G.g_ihext);
	  if (!obid)
	  {
	    /* error case, no more obs */
	  }
						/* remember it		*/
	  pstart->f_obid = obid;
	  pstart->f_wid = pwin->w_id ;
						/* build object		*/
	  G.g_screen[obid].ob_state = WHITEBAK | DRAW3D;
	  G.g_screen[obid].ob_flags = 0x0;
	  if ( !(pwin->w_type & TREEWIN) && (pwin->w_view == V_ICON) ) {
		G.g_screen[obid].ob_type = G_CLRICN;
	        win_icalc(pstart);
		G.g_index[obid] = GetIcon( pstart, (ANODE*)pstart->f_pa ) ;
		G.g_screen[obid].ob_spec = (BYTE far*) &gl_icons[obid];
		init_icon((ICONBLK far *)&gl_icons[obid], G.g_index[obid] );
		gl_icons[obid].ib_ptext = (LONG) &pstart->f_name[0];
#if LETTERS_IN_DISK_DRIVE_ICONS
		gl_icons[obid].ib_char |= (pstart->f_attr & F_DISK) ?
			    (0x00ff & ((ANODE*)pstart->f_pa)->A_LETTER) : 0x0 ;
#endif /* LETTERS_IN_DISK_DRIVE_ICONS */
	  }
	  else {	/* V_TEXT, or TREEWIN side of split win */
		G.g_screen[obid].ob_type = 0 ;
	        init_progdef( (TREE)G.g_screen, obid, (APPLBLK far *)&G.g_udefs[obid] ) ;
		G.g_udefs[obid].ab_parm = (FPARMBLK*)&pstart->f_junk;
	        win_icalc(pstart);
		if ( (pwin->w_type & TREEWIN) && (r_cnt < pwin->w_pnrow) )
			max_twidth = win_twcalc(pstart, max_twidth);
	  }
	  if ( pwin->w_type & TREEWIN && pstart->f_treetag == SHOWKIDS)
	  {					/* Skip over hidden	*/
						/*   children		*/
		  depth = fstrlen(pstart->f_tree);
		  pstart = pstart->f_next;
		  while (pstart && depth < fstrlen(pstart->f_tree))
			  pstart = pstart->f_next;
	  }
	  else pstart = pstart->f_next;
	  
	  c_cnt++;
	  if ( c_cnt == o_wfit )
	  {
						/* next row so skip	*/
						/*   next file in virt	*/
						/*   grid		*/
	    r_cnt++;
	    c_cnt = 0;
	    skipcnt = pwin->w_vncol - o_wfit;
	    while( (skipcnt--) &&
		   (pstart) )
	      pstart = pstart->f_next;
	  }
	}
						/* set slider size &	*/
						/*   position		*/
	wh = pwin->w_id;

	/* Horizontal slider for tree window only */	/* (RSF) */
	if (pwin->w_type & TREEWIN)
	{			/* For trees, we track character cells	*/
		if (pwin->w_vnind > max_twidth/gl_wchar)
		{
			pwin->w_cvind -= (pwin->w_vnind - max_twidth/gl_wchar);
			pwin->w_cvind = max(pwin->w_cvind, 0); /* no < 0 */
			scoot = TRUE;
		}
		else	scoot = FALSE;
		
		pwin->w_vnind = max_twidth/gl_wchar;	
		pwin->w_pnind = G.g_iwext/gl_wchar;
		sl_size = mul_div(G.g_iwext, 1000, max_twidth);
		wind_set(wh, WF_HSLSIZ, sl_size, 0, 0, 0);
		if (pwin->w_vnind > pwin->w_pnind)
			sl_value = mul_div(pwin->w_cvind, 1000,
				pwin->w_vnind - pwin->w_pnind);
		else	sl_value = 0;
		wind_set(wh, WF_HSLIDE, sl_value, 0, 0, 0);
		if (sl_size == 1000)
			pwin->w_cvind = 0;
	}

/**/
/* Only do slider of the top window or its co=top */
	wind_get( wh, WF_TOP, &n, &i, &i, &i );
	if( n == wh || 
	    ( (pwin->w_type & (TREEWIN | SIBLWIN)) && n == pwin->w_twin) )
	{
	    sl_size = mul_div(pwin->w_pnrow, 1000, pwin->w_vnrow);
	    wind_set(wh, WF_VSLSIZ, sl_size, 0, 0, 0);
	    if ( pwin->w_vnrow > pwin->w_pnrow )
	        sl_value = mul_div(pwin->w_cvrow, 1000,
				pwin->w_vnrow - pwin->w_pnrow);
	    else
	        sl_value = 0;
	    wind_set(wh, WF_VSLIDE, sl_value, 0, 0, 0);
	}
	return(scoot);
} /* win_bldview() */

/****************************************************************
 *  Blt the contents of a window based on a new current row or
 *  column.
 ****************************************************************/
void win_blt( WNODE far * pw, WORD newcv)
{
	WORD		delcv, pn, scoot;
	WORD		sx, sy, dx, dy, wblt, hblt, revblt, tmp;
	GRECT		c, t;

	newcv = max(0, newcv);
	
	newcv = min(pw->w_vnrow - pw->w_pnrow, newcv);
	pn = pw->w_pnrow;
	delcv = newcv - pw->w_cvrow;
	pw->w_cvrow += delcv;
	if (!delcv)
	  return;
	wind_get(pw->w_id, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
	scoot = win_bldview(pw, c.g_x, c.g_y, c.g_w, c.g_h);
						/* see if any part is	*/
						/*   off the screen	*/
	rc_copy(&c, &t);
	rc_intersect(&gl_rfull, &t);
	if ( !scoot && rc_equal(&c, &t) )
	{
						/* blt as much as we can*/
						/*   adjust clip & draw	*/
						/*   the rest		*/
	  if ( (revblt = (delcv < 0)) != 0 )
	    delcv = -delcv;
	  if (pn > delcv)
	  {
						/* see how much there is*/
						/* pretend blt up	*/
	    sx = dx = 0;
	    sy = delcv * G.g_ihspc;
	    dy = 0;
	    wblt = c.g_w;
	    hblt = c.g_h - sy;
	    if (revblt)
	    {
	      tmp = sx;
	      sx = dx;
	      dx = tmp;
	      tmp = sy;
	      sy = dy;
	      dy = tmp;
	    }
	    gsx_sclip(&c);
	    bb_screen(S_ONLY, sx+c.g_x, sy+c.g_y, dx+c.g_x, dy+c.g_y, 
			wblt, hblt);
	    if (!revblt)
	      c.g_y += hblt;
	    c.g_h -= hblt;
	  }
	}
	do_wredraw(pw->w_id, c.g_x, c.g_y, c.g_w, c.g_h+1);
} /* win_blt() */

/****************************************************************
*	Act on a horizontal scroll action.
*****************************************************************/
void win_newcol( WNODE far * pw, WORD newcv )
{
	WORD		delcv, sl_value;
	GRECT		c;

	newcv = max(0, newcv);
	
	newcv = min(pw->w_vnind - pw->w_pnind, newcv);
	delcv = newcv - pw->w_cvind;
	pw->w_cvind += delcv;
	if (!delcv)
	  return;
  	wind_get(pw->w_id, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
	do_wredraw(pw->w_id, c.g_x, c.g_y, c.g_w, c.g_h+1);
        sl_value = mul_div(pw->w_cvind, 1000, pw->w_vnind - pw->w_pnind);
	wind_set(pw->w_id, WF_HSLIDE, sl_value, 0, 0, 0);
} /* win_newcol() */

/****************************************************************
 *  Change the current virtual row or column being viewed in
 *  the upper left corner based on a new slide amount.
 *  (type is TRUE for vertical)     
 ****************************************************************/
void win_slide( WORD wh, WORD sl_value, BOOLEAN type)
{
WNODE far *	pw;
WORD		newcv;
WORD		vn, pn, ii, sls, sl_size;

	pw = win_find(wh);
	
	vn =  (type) ? pw->w_vnrow : 
			(pw->w_type & TREEWIN) ? pw->w_vnind : G.g_iwext ;
	pn =  (type) ? pw->w_pnrow : 
			(pw->w_type & TREEWIN) ? pw->w_pnind : pw->w_pncol ;
	sls = (type) ? WF_VSLSIZ : WF_HSLSIZ ;

	wind_get(wh, sls, &sl_size, &ii, &ii, &ii);
	newcv = mul_div(sl_value, vn - pn, 1000);
	if (type)
		win_blt(pw, newcv);
	else	win_newcol(pw, newcv);

} /* win_slide() */

/****************************************************************
 *  Change the current virtual row or column being viewed
 *  in the upper left corner based on a new slide amount.     
 ****************************************************************/
void win_arrow( WORD wh, WORD arrow_type)
{
WNODE far *	pw;
WORD		newcv;

	pw = win_find(wh);
	newcv = pw->w_cvrow;
	switch(arrow_type)
	{
	  case WA_UPPAGE:
		newcv = pw->w_cvrow - pw->w_pnrow;
		break;
	  case WA_DNPAGE:
		newcv = pw->w_cvrow + pw->w_pnrow;
		break;
	  case WA_UPLINE:
		newcv = pw->w_cvrow - 1;
		break;
	  case WA_DNLINE:
		newcv = pw->w_cvrow + 1;
		break;
	}
	if ( !(pw->w_type & TREEWIN) || newcv != pw->w_cvrow)
	{
		win_blt(pw, newcv);
		return;
	}
	
							/* (RSF)	*/
	/* Handle horizontal slider for tree window specially	*/
	switch(arrow_type)
	{
	  case WA_LFPAGE:
		  /* Go over by half window width */
		newcv = pw->w_cvind - pw->w_pnind/2;
		break;
	  case WA_RTPAGE:
		newcv = pw->w_cvind + pw->w_pnind/2;
		break;
	  case WA_LFLINE:
		  /* Go over by one character cell */
		newcv = pw->w_cvind - 1;
		break;
	  case WA_RTLINE:
  		newcv = pw->w_cvind + 1;
		break;
	}
	win_newcol(pw, newcv);
} /* win_arrow() */

/****************************************************************
 *  Build all existing iconic view windows and redisplay.
 ****************************************************************/
void win_rebuild( void )
{
WORD		rootsave;
WORD		xc, yc, wc, hc;	
WORD		ii;
WNODE far *	pw;

	rootsave = G.g_croot;
	
	for (ii = 0; ii < (NUM_WNODES*2); ii++)
	{
	    pw = &G.g_wlist[ii];
	    if ( pw->w_id && pw->w_open && 
		( !(pw->w_type & TREEWIN) && (pw->w_view == V_ICON) ) )
	    {
		    G.g_croot = pw->w_root;
		    wind_get(pw->w_id, WF_WXYWH, &xc, &yc, &wc, &hc);
		    win_bldview(pw, xc, yc, wc, hc);
	    }
	}

	G.g_croot = rootsave;
} /* win_rebuild() */

/****************************************************************
 *  Return the next icon that was selected after the current icon.
 ****************************************************************/
WORD win_isel(OBJECT olist[], WORD root, WORD curr)
{
	if (!curr)
	  curr = olist[root].ob_head;
	else
	  curr = olist[curr].ob_next;

	while(curr > root)
	{
	  if ( olist[curr].ob_state & SELECTED )
	    return(curr);
	  curr = olist[curr].ob_next;
	}
	return(0);
} /* win_isel() */

/****************************************************************
 *
 ****************************************************************/
BYTE *add_commas( long val )
{
BYTE *	tmp = gl_lngstr + 192 ;		/* use the tail end of this global */
BYTE *	ptr ;
short	ii ;

    sprintf( tmp, "%ld", val ) ;
    ii = (strlen(tmp)-1) / 3 ;		/* how many commas are necessary? */
    ptr = tmp + (strlen(tmp)-1) % 3 ;	/* position of 1st comma */
    
    for ( ; ii > 0; ii-- ) {
	memmove( (void *)(ptr+2), (void *)(ptr+1), 1+strlen(ptr+1) ) ;
	*(ptr+1) = _country.d1000[0] ;	/* international number punctuation */
	ptr += 4 ;			/* position of next comma */
       }

    return tmp ;
    
} /* add_commas() */

/****************************************************************
 *  Compress the given path string so that it fits in the given
 *  number of characters.  Used to make long path names fit in
 *  window title bars (SIBLWINs are narrower).  Resulting path
 *  string will be in form: "C:\...\etc".  Source string changed.
 ****************************************************************/
void win_stitle( BYTE *srctitle, WORD wh )
{
    BYTE	tmptitle[LEN_ZPATH];
    BYTE	*here_on;
    WORD	length, dummy;

    wind_get(wh, WF_WXYWH, &dummy, &dummy, &length, &dummy);
	
    length = (length / gl_wchar) - 2;
    
    if (strlen(srctitle) <= length)
	return;
    
    memmove(tmptitle, srctitle, 4);
    tmptitle[4] = '\0';
    strcat(tmptitle, "...\\");
    here_on = srctitle;
    
    while ((strlen(here_on)+8) > length)
	here_on = strchr(here_on, '\\') + 1;

    strcat(tmptitle, here_on);
    strcpy(srctitle, tmptitle);
    
    
} /* end win_stitle() */

/****************************************************************
 *  Set the name and information lines of a particular window.
 *  Don't put the "sorted by..." part onto a SIBLWIN's
 *  info bar string.  Not enough space.
 ****************************************************************/
void win_sname( WNODE far * pw )
{
    BYTE far *	psrc;
    BYTE far *	pdst;
    BYTE *	tmp = gl_lngstr + 128;		/* use this as a tmp area */
    BYTE	tmptitle[LEN_ZPATH];

    pw->w_info[0] = pw->w_name[0] = pw->w_title[0] = NULL ;

    if ( pw->w_type & TREEWIN )			/* tree: annotate with drive */
    {
	sprintf( tmptitle, "%s%c: ", ini_str(STTREES), pw->w_path->p_spec[0] ) ;
	fstrcpy( pw->w_name, (char far *)tmptitle ) ;
	if ( G.g_ndirs0 ) {
	    sprintf( tmptitle, ini_str( STFOLDER ), G.g_ndirs0 );
	    fstrcpy( pw->w_info, (char far *)tmptitle ) ;
	}
	fstrcpy( pw->w_title, pw->w_name );
    }
    
    else if( pw->w_path->p_spec[0] == '@' ) {	/* disk drive window */
	fstrcpy( pw->w_name, (char far *)ini_str(STDSKDRV) );
	fstrcpy( pw->w_title, pw->w_name );
	}
	
    else {	/* regular directory: show #files, folders, size, etc */
	
	if( G.g_ndirs0 ) {			/* "%ld folders." */
	    sprintf( tmptitle, ini_str( STFOLDER ), G.g_ndirs0 );
	    fstrcpy( pw->w_info, (char far *)tmptitle ) ;
	}
	if( G.g_nfiles0 ) { /* Only give file totals if there are any */
	    
	    if (pw->w_type & SIBLWIN) {	/* no room for "sorted by" */
		/* "%ld bytes in %ld files." */
		sprintf( tmptitle, ini_str(STBYTFIL),
				add_commas( G.g_size0 ), G.g_nfiles0 );
		fstrcat( pw->w_info, (char far *)tmptitle ) ;
	       }
	    else {		
		/* "%ld bytes in %ld files sorted by %s". */		
		/* must use tmp area for 2nd call to ini_str() */
		strcpy( tmp, ini_str( TXNAME + pw->w_sort ) ) ;
		sprintf( tmptitle, ini_str(STSORTBY),
				add_commas( G.g_size0 ), G.g_nfiles0, tmp ) ;
		fstrcat( pw->w_info, (char far *)tmptitle ) ;
	       }
	   }
	  
	psrc = pw->w_path->p_spec ;
	pdst = pw->w_name ;

	while ( (*psrc) && (*psrc != '*') ){
	    if( *psrc == ';' )	/* Skip the passwords	*/
#if SBC_920330
		psrc = (BYTE *)next_path_ch((UBYTE *)psrc);
#else
		psrc = fstrchr( psrc, '\\' ) ;
#endif
	    *pdst++ = *psrc++;
	   }
	*pdst = NULL;

	fstrcpy( (char far *)tmptitle, " " ) ;
	fstrcat( (char far *)tmptitle, pw->w_name ) ;
	fstrcat( (char far *)tmptitle, pw->w_wild ) ;
	fstrcat( (char far *)tmptitle, " " ) ;

#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
	MobileNetwareMobileDirectoryCheck(tmptitle, LEN_ZPATH);					/* USE_MOBILE_NETWARE  tar  02/13/92 */
#endif /* USE_MOBILE_NETWARE */

	/* Compress the window's title to fit in the title bar.  pw->w_title */
	/* is now LESS than LEN_ZPATH long; shorten in a temporary copy 1st. */
/* (hca: changing to dynamic string lengths for any window (sizeable)) */
#if 0					
	if (pw->w_type & SIBLWIN)
	    win_stitle(tmptitle, gl_comptlen);
	else win_stitle(tmptitle, gl_normtlen);
#else /* 0 */
	win_stitle( tmptitle, pw->w_id );
#endif /* 0 */
	fstrcpy( pw->w_title, (char far *)tmptitle );
	
       }
    
} /* win_sname */

/****************************************************************
 *  Given a pointer to either the TREE or SIBL side of a split
 *  window, join the window and return a pointer to it.  Also,
 *  return what the view of the SIBLWIN was for use as the view
 *  in the JOINED window.
 ****************************************************************/
WNODE far * win_join( WNODE far * pw )
{
GRECT		prev;
WNODE far *	ptw;
	
    wind_get(G.g_cwin, WF_CXYWH, &prev.g_x, &prev.g_y, &prev.g_w, &prev.g_h);

    ptw = pw;
    if (pw->w_type & SIBLWIN)		/* Make pw -> SIBLWIN	*/
	ptw = win_find(pw->w_twin);	/*  and ptw -> TREEWIN	*/
    else pw = win_find(pw->w_twin);

    wind_close(ptw->w_id);		/* Close the TREEWIN */
    ptw->w_open = FALSE;

    /* Tree gets paged out every time it's hidden. */
    fl_free(ptw->w_path->p_flist);	/* make its FNODEs avail. to others */    
    G.t_drive[ptw->w_path->p_spec[0]-'A'] = (FNODE far *)NULL;
    ptw->w_path->p_flist = (FNODE far *)NULL;
    
    close_window(pw->w_id);		/* Delete the SIBLWIN */
    
					/* Make the new window */
    pw->w_type = FILEWIN;
    pw->w_id = wind_create(WKIND_FILE, G.g_xfull, G.g_yfull, 
				      G.g_wfull, G.g_hfull);
    G.g_cwin = pw->w_id;
				/* RSF: Why set to subwin? */
    wind_set(G.g_cwin, WF_TATTRB, 0, 0, 0, 0);
    wind_open(G.g_cwin, gl_normwin.g_x, prev.g_y,
			gl_normwin.g_w, prev.g_h);
    win_top(pw);
    win_vistop(G.g_cwin, FALSE);
    
    return(pw);
    
}  /* end win_join() */

/****************************************************************
 *  Given pointer to a joined window, split the window and 
 *  return a pointer to the tree side.
 ****************************************************************/
WNODE far * win_split( WNODE far * pw )
{
GRECT		prev;
WNODE far *	ptw;
FNODE far *	pf;
WORD		item;
WORD		drv;
BYTE		path[LEN_ZPATH], name[MAXFILE], ext[MAXEXT];
BYTE		nullstr[1] = {'\0'};

    /* Before doing anything to the windows, make sure we can get onto */
    /* the target drive.  If not, leave the windows as they were. */
    drv = pw->w_path->p_spec[0];
    if (drv == '@')		/* window is currently showing drive icons */
    {
	item = win_isel(G.g_screen, G.g_croot, 0);
	pf = fpd_ofind(pw->w_path->p_flist, item);
	pro_chdir(pf->f_junk, "");	
	if (DOS_ERR)
	    return((WNODE far *)NULL);
    }
    
    /* Look at current window to preserve top/bottom & FULL states */
    wind_get(G.g_cwin, WF_CXYWH, &prev.g_x, &prev.g_y, &prev.g_w, &prev.g_h);

    close_window(pw->w_id);		/* Delete the window */

    /******************  SIBLING side (right)  ********************/
    pw->w_id = wind_create(WKIND_RSPLIT, gl_siblwin.g_x, G.g_yfull,
					gl_siblwin.g_w, G.g_hfull);
    pw->w_type = SIBLWIN;

/********/
    if (drv != '@')
	pn_folder( pw );		/* just to set G.g_ndirs0 etc. right */
/********/
    
    win_sname(pw);
    wind_set(pw->w_id, WF_TATTRB, WA_SUBWIN, 0, 0, 0);
    wind_open(pw->w_id, gl_siblwin.g_x, prev.g_y, gl_siblwin.g_w, prev.g_h);

    pw->w_istree = FALSE;		/* reset a window being auto-split */

    if (drv == '@')			/* fix up drive selection */
    {
	pw->w_path->p_spec[0] = pf->f_junk;
	fpd_parse( pw->w_path->p_spec, &drv, path, name, ext );
	do_fopen(pw, G.g_croot, drv, path, name, ext, FALSE, TRUE);
    }
    else desk_verify(pw->w_id, TRUE);	/* build narrower view */

    /********************  TREE side (left)  **********************/
    ptw = win_find(pw->w_twin);
    G.g_cwin = ptw->w_id;

    path[0] = '\0';
    name[0] = ext[0] = '*';
    name[1] = ext[1] = '\0';
    
    /* This TREEWIN has never been opened. */    
    if ( ptw->w_path == (PNODE far *)NULL )
    {
	prev.g_x = gl_treewin.g_x;
	prev.g_w = gl_treewin.g_w;
	do_diropen(ptw, TRUE, 0, drv, &path[0], &name[0], &ext[0], &prev, TRUE);
	if (SeenEROBJMIS)
	    return((WNODE far *)NULL);
    }
    else
    {
#if 0	
	ptw->w_path->p_spec[0] = drv;
	*(fstrrchr(ptw->w_name, ':') - 1) = drv;
	*(fstrrchr(ptw->w_title, ':') - 1) = drv;
	ptw->w_info[0] = NULL;
	wind_set2(G.g_cwin, WF_INFO, (LONG)ptw->w_info, 0, 0);
#else /* 0 */
	wind_set2(G.g_cwin, WF_NAME, (LONG)(BYTE far *)nullstr, 0, 0);
	wind_set2(G.g_cwin, WF_INFO, (LONG)(BYTE far *)nullstr, 0, 0);
	wind_set(G.g_cwin, WF_TATTRB, WA_SUBWIN, 0, 0, 0);
#endif /* 0 */
	wind_open(G.g_cwin, gl_treewin.g_x, prev.g_y, gl_treewin.g_w, prev.g_h);
	do_fopen(ptw, ptw->w_root, drv, path, name, ext, FALSE, TRUE);
    }
    ptw->w_open = TRUE;    

    win_top(pw);			/* (RSF) */
    win_vistop(ptw->w_twin, FALSE);	/* (RSF) */
    win_top(ptw);
    win_vistop(G.g_cwin, TRUE);

    return(ptw);
    
}  /* end win_split() */

/****************************************************************
 *  Subroutinized the build of a new window display upon
 *  keyboard "ENTER" (in hndl_kbd()) or mouse double-click (in
 *  hndl_button()) on an icon.  Selection of a TREE window item 
 *  is displayed in SIBLING window.
 *  Global item width & height variables will be changed by updating
 *  SIBLWIN display, which uses ICON or TEXT items.  Preserve and
 *  restore the TREEWIN's item sizes, so that kx & ky can be
 *  calculated correctly the next time hndl_button() is executed.
 ****************************************************************/
WORD win_contents(void)
{
WORD		item, drv, tree_wh;
WNODE far *	pw;
WNODE far *	psw;
FNODE far *	pf;
FNODE far *	savflist;
BYTE		path[LEN_ZPATH], name[MAXFILE], ext[MAXEXT];

    item = win_isel(G.g_screen, G.g_croot, 0);
    pw = win_find(G.g_cwin);
	
/* folder opened in TREEWIN changes SIBLWIN contents */	
    if ((pw->w_type & TREEWIN) || pw->w_istree)
    {
#if 0
	saviw = G.g_iwspc;		/* preserve TREEWIN's item size */
	savih = G.g_ihspc;
#endif /* 0 */
	tree_wh = 0;
	pf = fpd_ofind(pw->w_path->p_flist, item);

/* Window was forced to be a JOINWIN when it was closed.  Re-split it. */
	if (pw->w_istree)
	{
	    tree_wh = G.g_cwin;			/* preserve */
	    pw = win_split(pw);			/* NOW pw is a TREEWIN */
	    if (pw == (WNODE far *)NULL)
		return(0);			/* couldn't open rqstd drive */
	}

	if (!tree_wh)
	{
	    G.g_cwin = pw->w_twin;
	    psw = win_find(G.g_cwin);
	    G.g_croot = psw->w_root;

	    /* Opened a TREEWIN item.  Build SIBLWIN's new path */
	    /* using the tree's directory list. */
	    savflist = psw->w_path->p_flist;		/* save */
	    psw->w_path->p_flist = pw->w_path->p_flist;
	    tree_pspec(psw->w_path);
	    psw->w_path->p_flist = savflist;		/* restore */

	    fpd_parse( psw->w_path->p_spec, &drv, path, name, ext );
	    if (path[0] != NULL)
		strcat( path, "\\" );

	/* Don't try to add selected item name if it's a DRIVE item */	
	    if ( (pw->w_type & TREEWIN) && (pf->f_name[1] != ':'))
		fstrcat((BYTE far *)path, pf->f_name);

	    psw->w_cvrow = 0;			/* reset slider	*/
	    do_fopen(psw, G.g_croot, drv, path, name, ext, FALSE, TRUE);
	    win_top(psw);		/* (rsf) Required for proper hilite */
	    win_vistop(G.g_cwin, FALSE);
	    win_top(pw);
	    win_vistop(pw->w_id, TRUE);
	}
	    
/* keep TREEWIN active and restore TREEWIN's item size */	
	desk_verify(pw->w_id, FALSE);
#if 0	
	G.g_iwspc = saviw;
	G.g_ihspc = savih;
#endif /* 0 */
	/* We didn't have a TREEWIN, but we do now. */
  	if (tree_wh)
  	{
#if 0		    
	    fpd_parse( pw->w_path->p_spec, &drv, path, name, ext );
  	    do_fopen(pw, G.g_croot, drv, path, name, ext, FALSE, TRUE);
#endif /* 0 */
	    cursor_init();	    
	}	

    }
    else return( do_open(item) );

    return(0);
    
}  /* end win_contents() */


/****************************************************************
 * This routine is supposed to keep track of the windows between
 * runs of the Desktop.  If a window has been saved in full size,
 * open the other (obscured) window first.  If BOTH have been saved
 * full, open "Window 1", as per the .INI file, first (leaving
 * "Window 2" on top).
 * (NOTE: topmost window should be written to .INI as Window1)
 ****************************************************************/
GLOBAL	void fix_wins(void)
{
	gl_open1st = 0;				/* default case		*/

	if ((gl_savewin[0].g_y == G.g_yfull) &&
	    (gl_savewin[0].g_h == G.g_hfull))
	{
	    gl_open1st = 1;
	    gl_idsiztop = 0;
	}
	else if ((gl_savewin[1].g_y == G.g_yfull) &&
		 (gl_savewin[1].g_h == G.g_hfull))
	{
	    gl_open1st = 0;
	    gl_idsiztop = 1;
	}
	
} /* fix_wins() */

/****************************************************************
 *  Move or resize a window.
 ****************************************************************/
void	win_movsiz( WNODE far * pw, GRECT *req)
{
    GRECT	full;
    GRECT	tside, oside;		/* this & other side of SMW */
    WORD	win_spec, wicon;
    WORD	smwh;
    
    if (pw->w_type & TREEWIN)
	win_spec = WKIND_LSPLIT;
    else win_spec = WKIND_FILE;

    /* Find handle of SMW's other side: 1 <=> 3, 2 <=> 4.	*/
    /* Get window sizes before change.				*/
    if (pw->w_type & (TREEWIN | SIBLWIN))
    {
	smwh = pw->w_twin;
	wind_get(pw->w_id, WF_CXYWH, &tside.g_x, &tside.g_y, 
				     &tside.g_w, &tside.g_h);
	wind_get(smwh, WF_CXYWH, &oside.g_x, &oside.g_y, 
				 &oside.g_w, &oside.g_h);
    }
    else smwh = FALSE;

    wind_calc(WC_WORK, win_spec, req->g_x, req->g_y, req->g_w, req->g_h,
				   &full.g_x, &full.g_y, &full.g_w, &full.g_h);

    wind_calc(WC_BORDER, win_spec, full.g_x, full.g_y, full.g_w, full.g_h,
				     &req->g_x, &req->g_y, &req->g_w, &req->g_h);

    /* Move-Resize a split-mode window's other side.		*/
    /* Don't allow tree side to leave less than one icon's	*/
    /* width of SIBLWIN out of the overall SMW width.		*/
    /* (NOTE: This would be better in the AES.....)		*/
    if ( (pw->w_type & TREEWIN) && smwh)
    {
	wicon = G.g_wicon + (5 * ((gl_height <= 300) ? 0 : 8));
	if (((tside.g_w + oside.g_w) - req->g_w) < wicon)
	    req->g_w = (tside.g_w + oside.g_w) - wicon;

	wind_set(smwh, WF_CXYWH, req->g_x + req->g_w - 1, req->g_y,
				 (tside.g_w + oside.g_w) - req->g_w, req->g_h);
    }
    else if ( (pw->w_type & SIBLWIN) && smwh)
    {				
	wind_set(smwh, WF_CXYWH, req->g_x - oside.g_w + 1, req->g_y,
				 oside.g_w, req->g_h);
    }
    
    if (smwh)				/* rebuild view of SMW's other side */
	desk_verify(smwh, TRUE);

    wind_set(pw->w_id, WF_CXYWH, req->g_x, req->g_y, req->g_w, req->g_h);
    desk_verify(pw->w_id, TRUE);

		
} /* end win_movsiz() */


/*
 *	EOF:	deskwin.c
 */
