/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991  Digital Research Inc.  All rights reserved.    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskwin.h 4.8 92/04/13 11:08:15 sbc Exp $
* $Log:	deskwin.h $
 * Revision 4.8  92/04/13  11:08:15  sbc
 * Add w_next member to WNODE. Keep track of g_whead and g_wavail ptrs.
 * 
 * Revision 4.7  92/04/03  17:13:59  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.6  92/03/26  14:45:04  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.5  92/02/12  15:37:34  sbc
 * add window kind for group windows: WIND_GROUP.
 * also remove defines for BORDER_AREA and WORK_AREA since these are
 * redundant with defines in GEMBIND.H (WC_WORK and WC_BORDER).
 * also remove unused member w_obid from struct WNODE.
 * 
 * Revision 4.4  92/02/06  12:09:21  sbc
 * rename WNODE member w_split to w_type
 * 
 * Revision 4.3  92/02/05  10:21:51  sbc
 * add defines FILEWIN and GROUPWIN to TREEWIN and SIBLWIN for w_type.
 * 
 * Revision 4.2  91/11/07  17:07:32  anderson
 * Moveable-sizeable windows changes.
 * 
 * Revision 4.1  91/09/17  13:57:12  system
 * Initial work for DOS window, screen saver, etc.
 * 
 * Revision 3.1  91/08/19  16:31:03  system
 * ViewMAX 2 sources
 * 
 ****************************************************************************/
#ifndef DESKWIN_INCLUDED
#define DESKWIN_INCLUDED

#define DROOT 1
#define NUM_WNODES 2

/* Total # of objects that can be visible in all windows combined.  Must include
 * a single "next" (invisible) row of objects for each window.  Must also 
 * include a virtual window's worth of drive icons (system dependent).  Maximum
 * would be 2 JOINED, FULL size windows of ICONS on HERCULES driver, or:
 * 2 * ((10 visible + 1 "next") rows * 8 icons/row) = (2 * 88) = 172 + # drives
 */
#define NUM_WOBS 200
#define NUM_SOBS (NUM_WOBS + (NUM_WNODES*2) + 1)

/* Window controls for a regular (non-split mode) window. */
#define WKIND_FILE	(NAME | INFO | VSLIDE | DNARROW | UPARROW \
			    | FULLER | CLOSER | MOVER | SIZER)

/* Window controls for the right and left sides of split-mode windows.	*/
/* NOTE: CLOSE is on the TREEWIN and FULL is on the SIBLWIN.		*/
#define WKIND_RSPLIT (NAME | INFO | FULLER | VSLIDE | DNARROW | UPARROW | \
			MOVER | SIZER)
#define WKIND_LSPLIT (NAME | INFO | CLOSER | VSLIDE | DNARROW | UPARROW | \
			HSLIDE | RTARROW | LFARROW | MOVER | SIZER)
			    
/* Window controls for a program group window. */
#define WKIND_GROUP	(NAME | VSLIDE | DNARROW | UPARROW \
			    | FULLER | CLOSER | MOVER | SIZER)


/* Window attributes for Show Contents window */
#define WKIND_SHOW   ( WKIND_FILE | HSLIDE | RTARROW | LFARROW )

/* Values for w_type field in a WNODE */
#define FILEWIN		0	/* Ordinary, unsplit directory window	*/
#define	SIBLWIN		1	/* Right side of a split mode window	*/
#define TREEWIN		2	/* Left side of a split mode window	*/
#define GROUPWIN	4	/* Program Group window			*/

#define WNODE struct windnode
WNODE
{
	WNODE far *	w_next ;		/* ptr to next wnode	*/
	BOOLEAN		w_open;			/* flag: window open?	*/
	WORD		w_type;			/* flag: window split?	*/
	WORD		w_view;			/* flag: V_TEXT or V_ICON*/
	WORD		w_sort;			/* flag: S_TYPE, S_NAME, etc */
	BOOLEAN		w_istree;		/* flag: "should be TREEWIN" */
	WORD		w_id;			/* window handle id #	*/
	WORD		w_twin;			/* handle: SMW's other side */
	WORD		w_root;			/* pseudo root ob. in	*/
						/*   gl_screen for this	*/
						/*   windows objects	*/
	WORD		w_cvcol;		/* current virt. col	*/
	WORD		w_cvrow;		/* current virt. row	*/
	WORD		w_cvind;		/* (rsf) current virt. indent
						   for trees only	*/
	WORD		w_pncol;		/* physical # of cols	*/
	WORD		w_pnrow;		/* physical # of rows	*/
	WORD		w_pnind;		/* (rsf) physical # of chars
						   can indent display	*/
	WORD		w_vncol;		/* virtual # of cols 	*/
	WORD		w_vnrow;		/* virtual # of rows	*/
	WORD		w_vnind;		/* (rsf) virtual # of chars 
						   can indent display	*/
	PNODE far *	w_path;
	BYTE		w_name[LEN_ZPATH];
	BYTE		w_info[MAX_LEN];	/* window information line */
	BYTE		w_title[MAX_LEN];	/* window title bar	*/
	BYTE		w_wild[65];		/* wildcards		*/
};

#endif /* ndef DESKWIN_INCLUDED */

/*
 *	EOF:	deskwin.h
 */
