#*****************************************************************************
#*   Copyright (c) 1985,1992  Digital Research Inc.  All rights reserved.    *
#*   The Software Code contained in this listing is proprietary to Digital   *
#*   Research Inc., Monterey, California, and is covered by U.S. and other   *
#*   copyright protection.  Unauthorized copying, adaption, distribution,    *
#*   use or display is prohibited and may be subject to civil and criminal   *
#*   penalties.  Disclosure to others is prohibited.  For the terms and      *
#*   conditions of software code use, refer to the appropriate Digital       *
#*   Research License Agreement.					     *
#*****************************************************************************
#*		      U.S. GOVERNMENT RESTRICTED RIGHTS			     *
#*                    ---------------------------------                      *
#*  This software product is provided with RESTRICTED RIGHTS.  Use, 	     *
#*  duplication or disclosure by the Government is subject to restrictions   *
#*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
#*  the applicable provisions of the DOD FAR supplement 252.227-7013 	     *
#*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
#*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
#*  BOX DRI / Monterey, CA 93940.					     *
#*****************************************************************************
# $Header: g:/groups/panther/dsk/rcs/dsk.mak 4.11 92/04/08 14:25:58 sbc Exp $
# $Log:	dsk.mak $
# Revision 4.11  92/04/08  14:25:58  sbc
# change to Borland C++
# 
# 
#*****************************************************************************

#*****************************************************************************
#* File:	dsk_cp.mak
#*
#* Description:	Makefile for ViewMAX II.
#*
#* Build Info:	ndmake -f dsk.mak
#*
#* Toolset:	Turbo C++ v2.0; RASM86 v1.4; TLINK v4.0
#*
#* Notes:
#   >>  This makefile will build a ViewMAX application called VMDSK.EXE (so named
#	for debugging purposes) and copy it to "VIEWMAX", the required name of
#	the executable ViewMAX application.  No executable compression is being
#	done (yet).
#   >>	The VIEWMAX executable that this makefile currently builds contains
#	symbolic information for debugging purposes.  This will make the app.
#	over 200K, but will not affect run-time operation.  Versions to be
#	released to QA should not contain symbols, and we will be modifying this
#	makefile to allow it to build versions for release.
#   >>  Your DOS path must contain <netdrv>:\TOOLS and <netdrv>:\TOOLS\RCS,
#	where <netdrv> is a DOS drive assigned to our Netware server's hard
#	drive.
#   >>	Macros that are used but not defined in this makefile are defined in
#	the Ndmake input file MAKE.INI, in <netdrv>:\TOOLS. The MAKE.INI
#	is used by this makefile and by the AES makefile (AES.MAK).
#   >>  Non-existent working source files will be checked out of the RCS library
#	that's in <netdrv>:\DRDESK\DSK.
#   >>  Current directory must be the destination directory for sources and
#	executable (i.e. "working" directory).
#   >>  All .obj files are kept in an \obj subdirectory of the working
#	directory.  Create this subdirectory before running this makefile.
#   >>  This makefile uses the UNIX-style utility "mv.exe" to put the Rasm86
#	object files into the \obj directory.  (Porting to TASM would solve 
#	this problem!)  This is in <netdrv>:\TOOLS.
#
#	911028 K.H	Added viewapps.c to support double byte character set.
#*****************************************************************************

#-----------------------------------------------------------------------------
#	Allow Tlink to use macros for objects
#	without overflowing line length
#-----------------------------------------------------------------------------
.RESPONSE_LINK:	tlink

#-----------------------------------------------------------------------------
#	Suffixes for compiling rules:
#	OTC = Object Turbo C
#	OTM = Object Turbo Mixed C and Assembler
#	OTA = Object Turbo Assembler
#	ORA = Object Rasm Assembler
#-----------------------------------------------------------------------------
.SUFFIXES .otc .otm .c .ota .ora .a86

#-----------------------------------------------------------------------------
#	How to Build
#-----------------------------------------------------------------------------
#  -c	= compile only, don't link
#  -o	= put object files in \obj
#  -w	= display warnings ON
#  -C	= nested comments ON
#  -r	= register variables ON		(.a86 modules MUST preserve SI & DI!)
#  -v 	= source debugging ON
#  -Z	= register optimization ON
#  -O	= jump optimization ON
#  -y-	= line numbers OFF
#  -f-	= floating point emulation OFF
#  -k-	= standard stack frame OFF	( ??? )
#  -N-	= test stack overflow OFF	(on is expensive)
#-----------------------------------------------------------------------------
RCSFLAGS=-rPANTHER

# flags for Tom Rolander's Mobile Netware source fork
# Shuffle these around (or comment out others) to build Mobile Netware version
MORE_CFLAGS=-DUSE_MOBILE_NETWARE -v
MN_CFILES=	deskmnvm.c
MN_OTCS=	deskmnvm.otc
MN_HFILES=	deskmnvm.h

MN_CFILES=
MN_OTCS=
MN_HFILES=

# assembler flags
AFLAGS=$$pz sz 

# C flags (additional flags are specified in TURBOC.CFG)
MODEL=m
MORE_CFLAGS=-v
MORE_CFLAGS=
CFLAGS=-m$(MODEL) -I$(TCPINC)

# linker flags
MORE_LFLAGS=/v
MORE_LFLAGS=
LFLAGS=/m/s

#-----------------------------------------------------------------------------
#	Rules for compiling, assembling
#-----------------------------------------------------------------------------
.c.otc :
	( del $(OBJ)\$*.otc ;						\
	  $(TCP) $(CFLAGS) $(MORE_CFLAGS) -o$(OBJ)\$*.otc $< )

.c.otm :
	( del $(OBJ)\$*.otm ;						\
	  $(TCP) $(CFLAGS) $(MORE_CFLAGS) -B -o$(OBJ)\$*.otm $< )

.a86.ora :
	( del $(OBJ)\$*.ora ;						\
	  $(RASM) $< $(AFLAGS) ;					\
	  $(TOOLS)\mv $*.obj $(OBJ)\$*.ora )

#-----------------------------------------------------------------------------
#	Paths to RCS, Source and Object files
#-----------------------------------------------------------------------------
OBJ=.\obj
VPATH=.;$(OBJ)

#-----------------------------------------------------------------------------
#	Assembled files
#-----------------------------------------------------------------------------
AFILES= deskosif.a86	deskstar.a86	gsx2.a86       	longasm.a86	\
	optimopt.a86	
		
ORAs=  	deskosif.ora	deskstar.ora	gsx2.ora       	longasm.ora	\
	optimopt.ora	
		
#-----------------------------------------------------------------------------
#	Compiled files
#-----------------------------------------------------------------------------
CFILES=	button.c	danutil.c	deskact.c	deskapp.c	\
	deskbkgd.c	deskcet.c	deskclrs.c	deskdir.c	\
	deskfpd.c	deskfun.c	deskglob.c	deskgraf.c	\
	deskgsx.c	deskinf.c	deskinit.c	deskins.c	\
	deskmain.c	deskobj.c	deskpass.c	deskpgrp.c	\
	deskpro.c	deskrsrc.c	deskscsv.c	desksupp.c	\
	desktmax.c	desktree.c	desktype.c	deskwin.c	\
	ems.c		exformdo.c	exobj.c		fndexobj.c	\
	fndexpnt.c	gembind.c	gemdos.c	inifiles.c	\
	list.c		listbox.c	listexob.c	memyman.c	\
	optimize.c	parsestr.c	radio.c		slider.c	\
	slidtran.c	trnsrsc.c	util.c		valuebox.c	\
	viewapps.c	$(MN_CFILES)

OTCs=  	button.otc	danutil.otc	deskact.otc	deskapp.otc	\
	deskbkgd.otc	deskcet.otc	deskclrs.otc	deskdir.otc	\
	deskfpd.otc	deskfun.otc	deskglob.otc	deskgraf.otc	\
	deskgsx.otc	deskinf.otc	deskinit.otc	deskins.otc	\
	deskmain.otc	deskobj.otc	deskpass.otc	deskpgrp.otc	\
	deskpro.otc	deskrsrc.otc	deskscsv.otc	desksupp.otc	\
	desktmax.otc	desktree.otc	desktype.otc	deskwin.otc	\
	ems.otc		exformdo.otc	exobj.otc	fndexobj.otc	\
	fndexpnt.otc	gembind.otc	gemdos.otc	inifiles.otc	\
	list.otc	listbox.otc	listexob.otc	memyman.otc	\
	optimize.otc	parsestr.otc	radio.otc	slider.otc	\
	slidtran.otc	trnsrsc.otc	util.otc	valuebox.otc	\
	viewapps.otc	$(MN_OTCS)

#-----------------------------------------------------------------------------
#	Compiled files 
#   for mixed C and Assembler
#-----------------------------------------------------------------------------
MIXEDC=	deskcicn.c	fruntime.c
OTMs=	deskcicn.otm	fruntime.otm

#-----------------------------------------------------------------------------
#	Include files
#-----------------------------------------------------------------------------
STANDARD_H= shell.h	portab.h	machine.h	obdefs.h	\
	viewmax.h      	deskdos.h	deskfpd.h      	deskwin.h      	\
	deskapp.h      		      	gembind.h      	deskbind.h     	\
	gsxdefs.h      	proto.h		fruntime.h	viewhelp.h

HFILES=	$(STANDARD_H)	funcdef.h	deskkeys.h	inidefs.h	\
	danutil.h	exobdefs.h	exproto.h	list.h		\
	viewapps.h

#-----------------------------------------------------------------------------
#	Default target
#-----------------------------------------------------------------------------
exec:	$(ORAs) $(OTCs) $(OTMs)
	$(TLINK4) $(LFLAGS) $(MORE_LFLAGS) $(TCPLIB)\c0$(MODEL) 	\
		$(ORAs) $(OTCs) $(OTMs),				\
		vmdsk.exe,						\
		vmdsk.map,						\
		$(TCPLIB)\c$(MODEL).lib


	@ECHO -----------------------------------------
	dir vmdsk
	@ECHO -----------------------------------------
	xsum vmdsk.exe
 	copy vmdsk.exe viewmax

#-----------------------------------------------------------------------------
#	Source files
#-----------------------------------------------------------------------------
$(AFILES) :
	$(RCS)\co $(RCSFLAGS) $(NET)\dsk\rcs\$*.a86

$(CFILES) $(MIXEDC) $(MN_CFILES) :
	$(RCS)\co $(RCSFLAGS) $(NET)\dsk\rcs\$*.c

$(HFILES) $(MN_HFILES) :
	$(RCS)\co $(RCSFLAGS) $(NET)\dsk\rcs\$*.h

#-----------------------------------------------------------------------------
#	Dependencies for Sources
#-----------------------------------------------------------------------------
$(ORAs) 								\
		: $*.a86

$(OTCs) $(OTMs) $(MN_OTCS)						\
		: $*.c $(STANDARD_H) $(MN_HFILES)

deskmain.otc 	exformdo.otc 						\
		: deskkeys.h

deskclrs.otc	desktmax.otc	inifiles.otc 				\
deskapp.otc								\
		: inidefs.h

deskcet.otc	deskgraf.otc 	deskgsx.otc	deskinf.otc 		\
desktype.otc	listexob.otc	radio.otc	slider.otc 		\
		: funcdef.h 

button.otc	deskclrs.otc	desksupp.otc	desktmax.otc		\
deskmain.otc	exformdo.otc	fndexobj.otc	fndexpnt.otc		\
list.otc	listbox.otc	listexob.otc	deskinit.otc		\
slider.otc	slidtran.otc	valuebox.otc	deskinf.otc		\
trnsrsc.otc 	danutil.otc	exobj.otc 				\
radio.otc 								\
		: list.h exobdefs.h danutil.h exproto.h

deskpro.otc	deskdir.otc	desktree.otc	gemdos.otc		\
deskinf.otc	inifiles.otc	desksupp.otc	deskwin.otc		\
deskpass.otc	danutil.otc	deskfun.otc	deskfpd.otc		\
viewapps.otc	desktype.otc						\
		: viewapps.h

#
#	EOF:	dsk.mak
#
