/*----------------------------------------------------------------------+
FRUNTIME.H
    explicit far pointer versions of selected runtime library functions
+-----------------------------------------------------------------------*/

#define fstrcpy( a,b )		fmemcpy( (void far *)(a), (void far *)(b), \
				(unsigned int)(1+fstrlen( (char far *)(b))))
#define fstrcmp( a,b )		fmemcmp( (void far *)(a), (void far *)(b), \
				(unsigned int)(1+fstrlen( (char far *)(b))))
				
/*-----------------------------------------------------------------------*/
extern int	fmemcmp( char far *b1, char far *b2, unsigned int size ) ;
extern char far *fmemcpy( char far *dest, char far *source,unsigned int size);
extern char far *fmemset( char far *dest, int c, unsigned int count ) ;

extern short    fstrlen( char far *pStr ) ;
extern char far *fstrcat( char far *pd, char far *ps) ;
extern char far *fstrchr( char far *ps, char c ) ;
extern char far *fstrrchr( char far *ps, char c ) ;

extern short	lbwmov( short far *dst, unsigned char far *src ) ;

/*-----------------------------------------------------------------------*/
/* FRUNTIME.H */
